
_ssd1306_command:

;ssd1306oled.c,312 :: 		void ssd1306_command(uint8_t c) {
;ssd1306oled.c,313 :: 		SSD1306_Start();
	CALL        _I2C1_Start+0, 0
;ssd1306oled.c,314 :: 		SSD1306_Write(_i2caddr);
	MOVF        __i2caddr+0, 0 
	MOVWF       FARG_I2C1_Wr_data_+0 
	CALL        _I2C1_Wr+0, 0
;ssd1306oled.c,315 :: 		SSD1306_Write(0);
	CLRF        FARG_I2C1_Wr_data_+0 
	CALL        _I2C1_Wr+0, 0
;ssd1306oled.c,316 :: 		SSD1306_Write(c);
	MOVF        FARG_ssd1306_command_c+0, 0 
	MOVWF       FARG_I2C1_Wr_data_+0 
	CALL        _I2C1_Wr+0, 0
;ssd1306oled.c,317 :: 		SSD1306_Stop();
	CALL        _I2C1_Stop+0, 0
;ssd1306oled.c,318 :: 		}
L_end_ssd1306_command:
	RETURN      0
; end of _ssd1306_command

_SSD1306_Begin:

;ssd1306oled.c,320 :: 		void SSD1306_Begin(uint8_t vccstate, uint8_t i2caddr) {
;ssd1306oled.c,321 :: 		_vccstate = vccstate;
	MOVF        FARG_SSD1306_Begin_vccstate+0, 0 
	MOVWF       __vccstate+0 
;ssd1306oled.c,322 :: 		_i2caddr  = i2caddr;
	MOVF        FARG_SSD1306_Begin_i2caddr+0, 0 
	MOVWF       __i2caddr+0 
;ssd1306oled.c,332 :: 		ssd1306_command(SSD1306_DISPLAYOFF);                    // 0xAE
	MOVLW       174
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,333 :: 		ssd1306_command(SSD1306_SETDISPLAYCLOCKDIV);            // 0xD5
	MOVLW       213
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,334 :: 		ssd1306_command(0x80);                                  // the suggested ratio 0x80
	MOVLW       128
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,336 :: 		ssd1306_command(SSD1306_SETMULTIPLEX);                  // 0xA8
	MOVLW       168
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,337 :: 		ssd1306_command(SSD1306_LCDHEIGHT - 1);
	MOVLW       63
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,339 :: 		ssd1306_command(SSD1306_SETDISPLAYOFFSET);              // 0xD3
	MOVLW       211
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,340 :: 		ssd1306_command(0x0);                                   // no offset
	CLRF        FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,341 :: 		ssd1306_command(SSD1306_SETSTARTLINE | 0x0);            // line #0
	MOVLW       64
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,342 :: 		ssd1306_command(SSD1306_CHARGEPUMP);                    // 0x8D
	MOVLW       141
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,343 :: 		if (vccstate == SSD1306_EXTERNALVCC)
	MOVF        FARG_SSD1306_Begin_vccstate+0, 0 
	XORLW       1
	BTFSS       STATUS+0, 2 
	GOTO        L_SSD1306_Begin0
;ssd1306oled.c,344 :: 		{ ssd1306_command(0x10); }
	MOVLW       16
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
	GOTO        L_SSD1306_Begin1
L_SSD1306_Begin0:
;ssd1306oled.c,346 :: 		{ ssd1306_command(0x14); }
	MOVLW       20
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
L_SSD1306_Begin1:
;ssd1306oled.c,347 :: 		ssd1306_command(SSD1306_MEMORYMODE);                    // 0x20
	MOVLW       32
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,348 :: 		ssd1306_command(0x00);                                  // 0x0 act like ks0108
	CLRF        FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,349 :: 		ssd1306_command(SSD1306_SEGREMAP | 0x1);
	MOVLW       161
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,350 :: 		ssd1306_command(SSD1306_COMSCANDEC);
	MOVLW       200
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,359 :: 		ssd1306_command(SSD1306_SETCOMPINS);                    // 0xDA
	MOVLW       218
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,360 :: 		ssd1306_command(0x12);
	MOVLW       18
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,361 :: 		ssd1306_command(SSD1306_SETCONTRAST);                   // 0x81
	MOVLW       129
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,362 :: 		if (vccstate == SSD1306_EXTERNALVCC)
	MOVF        FARG_SSD1306_Begin_vccstate+0, 0 
	XORLW       1
	BTFSS       STATUS+0, 2 
	GOTO        L_SSD1306_Begin2
;ssd1306oled.c,363 :: 		{ ssd1306_command(0x9F); }
	MOVLW       159
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
	GOTO        L_SSD1306_Begin3
L_SSD1306_Begin2:
;ssd1306oled.c,365 :: 		{ ssd1306_command(0xCF); }
	MOVLW       207
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
L_SSD1306_Begin3:
;ssd1306oled.c,378 :: 		ssd1306_command(SSD1306_SETPRECHARGE);                  // 0xd9
	MOVLW       217
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,379 :: 		if (vccstate == SSD1306_EXTERNALVCC)
	MOVF        FARG_SSD1306_Begin_vccstate+0, 0 
	XORLW       1
	BTFSS       STATUS+0, 2 
	GOTO        L_SSD1306_Begin4
;ssd1306oled.c,380 :: 		{ ssd1306_command(0x22); }
	MOVLW       34
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
	GOTO        L_SSD1306_Begin5
L_SSD1306_Begin4:
;ssd1306oled.c,382 :: 		{ ssd1306_command(0xF1); }
	MOVLW       241
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
L_SSD1306_Begin5:
;ssd1306oled.c,383 :: 		ssd1306_command(SSD1306_SETVCOMDETECT);                 // 0xDB
	MOVLW       219
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,384 :: 		ssd1306_command(0x40);
	MOVLW       64
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,385 :: 		ssd1306_command(SSD1306_DISPLAYALLON_RESUME);           // 0xA4
	MOVLW       164
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,386 :: 		ssd1306_command(SSD1306_NORMALDISPLAY);                 // 0xA6
	MOVLW       166
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,388 :: 		ssd1306_command(SSD1306_DEACTIVATE_SCROLL);
	MOVLW       46
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,390 :: 		ssd1306_command(SSD1306_DISPLAYON);//--turn on oled panel
	MOVLW       175
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,391 :: 		}
L_end_SSD1306_Begin:
	RETURN      0
; end of _SSD1306_Begin

_SSD1306_DrawPixel:

;ssd1306oled.c,393 :: 		void SSD1306_DrawPixel(uint8_t x, uint8_t y) {
;ssd1306oled.c,394 :: 		if ((x >= SSD1306_LCDWIDTH) || (y >= SSD1306_LCDHEIGHT))
	MOVLW       128
	SUBWF       FARG_SSD1306_DrawPixel_x+0, 0 
	BTFSC       STATUS+0, 0 
	GOTO        L__SSD1306_DrawPixel179
	MOVLW       64
	SUBWF       FARG_SSD1306_DrawPixel_y+0, 0 
	BTFSC       STATUS+0, 0 
	GOTO        L__SSD1306_DrawPixel179
	GOTO        L_SSD1306_DrawPixel8
L__SSD1306_DrawPixel179:
;ssd1306oled.c,395 :: 		return;
	GOTO        L_end_SSD1306_DrawPixel
L_SSD1306_DrawPixel8:
;ssd1306oled.c,396 :: 		if (SSD1306_Color)
	MOVF        _SSD1306_Color+0, 1 
	BTFSC       STATUS+0, 2 
	GOTO        L_SSD1306_DrawPixel9
;ssd1306oled.c,397 :: 		buffer[x + (uint16_t)(y / 8) * SSD1306_LCDWIDTH] |=  (1 << (y & 7));
	MOVF        FARG_SSD1306_DrawPixel_y+0, 0 
	MOVWF       R0 
	RRCF        R0, 1 
	BCF         R0, 7 
	RRCF        R0, 1 
	BCF         R0, 7 
	RRCF        R0, 1 
	BCF         R0, 7 
	MOVF        R0, 0 
	MOVWF       R3 
	MOVLW       0
	MOVWF       R4 
	MOVLW       7
	MOVWF       R2 
	MOVF        R3, 0 
	MOVWF       R0 
	MOVF        R4, 0 
	MOVWF       R1 
	MOVF        R2, 0 
L__SSD1306_DrawPixel189:
	BZ          L__SSD1306_DrawPixel190
	RLCF        R0, 1 
	BCF         R0, 0 
	RLCF        R1, 1 
	ADDLW       255
	GOTO        L__SSD1306_DrawPixel189
L__SSD1306_DrawPixel190:
	MOVF        FARG_SSD1306_DrawPixel_x+0, 0 
	ADDWF       R0, 1 
	MOVLW       0
	ADDWFC      R1, 1 
	MOVLW       si5351SDR_firmware_buffer+0
	ADDWF       R0, 0 
	MOVWF       R2 
	MOVLW       hi_addr(si5351SDR_firmware_buffer+0)
	ADDWFC      R1, 0 
	MOVWF       R3 
	MOVLW       7
	ANDWF       FARG_SSD1306_DrawPixel_y+0, 0 
	MOVWF       R0 
	MOVF        R0, 0 
	MOVWF       R1 
	MOVLW       1
	MOVWF       R0 
	MOVF        R1, 0 
L__SSD1306_DrawPixel191:
	BZ          L__SSD1306_DrawPixel192
	RLCF        R0, 1 
	BCF         R0, 0 
	ADDLW       255
	GOTO        L__SSD1306_DrawPixel191
L__SSD1306_DrawPixel192:
	MOVFF       R2, FSR0L+0
	MOVFF       R3, FSR0H+0
	MOVF        POSTINC0+0, 0 
	IORWF       R0, 1 
	MOVFF       R2, FSR1L+0
	MOVFF       R3, FSR1H+0
	MOVF        R0, 0 
	MOVWF       POSTINC1+0 
	GOTO        L_SSD1306_DrawPixel10
L_SSD1306_DrawPixel9:
;ssd1306oled.c,399 :: 		buffer[x + (uint16_t)(y / 8) * SSD1306_LCDWIDTH] &=  ~(1 << (y & 7));
	MOVF        FARG_SSD1306_DrawPixel_y+0, 0 
	MOVWF       R0 
	RRCF        R0, 1 
	BCF         R0, 7 
	RRCF        R0, 1 
	BCF         R0, 7 
	RRCF        R0, 1 
	BCF         R0, 7 
	MOVF        R0, 0 
	MOVWF       R3 
	MOVLW       0
	MOVWF       R4 
	MOVLW       7
	MOVWF       R2 
	MOVF        R3, 0 
	MOVWF       R0 
	MOVF        R4, 0 
	MOVWF       R1 
	MOVF        R2, 0 
L__SSD1306_DrawPixel193:
	BZ          L__SSD1306_DrawPixel194
	RLCF        R0, 1 
	BCF         R0, 0 
	RLCF        R1, 1 
	ADDLW       255
	GOTO        L__SSD1306_DrawPixel193
L__SSD1306_DrawPixel194:
	MOVF        FARG_SSD1306_DrawPixel_x+0, 0 
	ADDWF       R0, 1 
	MOVLW       0
	ADDWFC      R1, 1 
	MOVLW       si5351SDR_firmware_buffer+0
	ADDWF       R0, 0 
	MOVWF       R2 
	MOVLW       hi_addr(si5351SDR_firmware_buffer+0)
	ADDWFC      R1, 0 
	MOVWF       R3 
	MOVLW       7
	ANDWF       FARG_SSD1306_DrawPixel_y+0, 0 
	MOVWF       R0 
	MOVF        R0, 0 
	MOVWF       R1 
	MOVLW       1
	MOVWF       R0 
	MOVF        R1, 0 
L__SSD1306_DrawPixel195:
	BZ          L__SSD1306_DrawPixel196
	RLCF        R0, 1 
	BCF         R0, 0 
	ADDLW       255
	GOTO        L__SSD1306_DrawPixel195
L__SSD1306_DrawPixel196:
	COMF        R0, 1 
	MOVFF       R2, FSR0L+0
	MOVFF       R3, FSR0H+0
	MOVF        POSTINC0+0, 0 
	ANDWF       R0, 1 
	MOVFF       R2, FSR1L+0
	MOVFF       R3, FSR1H+0
	MOVF        R0, 0 
	MOVWF       POSTINC1+0 
L_SSD1306_DrawPixel10:
;ssd1306oled.c,400 :: 		}
L_end_SSD1306_DrawPixel:
	RETURN      0
; end of _SSD1306_DrawPixel

_SSD1306_StartScrollRight:

;ssd1306oled.c,402 :: 		void SSD1306_StartScrollRight(uint8_t start, uint8_t stop) {
;ssd1306oled.c,403 :: 		ssd1306_command(SSD1306_RIGHT_HORIZONTAL_SCROLL);
	MOVLW       38
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,404 :: 		ssd1306_command(0X00);
	CLRF        FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,405 :: 		ssd1306_command(start);
	MOVF        FARG_SSD1306_StartScrollRight_start+0, 0 
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,406 :: 		ssd1306_command(0X00);
	CLRF        FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,407 :: 		ssd1306_command(stop);
	MOVF        FARG_SSD1306_StartScrollRight_stop+0, 0 
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,408 :: 		ssd1306_command(0X00);
	CLRF        FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,409 :: 		ssd1306_command(0XFF);
	MOVLW       255
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,410 :: 		ssd1306_command(SSD1306_ACTIVATE_SCROLL);
	MOVLW       47
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,411 :: 		}
L_end_SSD1306_StartScrollRight:
	RETURN      0
; end of _SSD1306_StartScrollRight

_SSD1306_StartScrollLeft:

;ssd1306oled.c,413 :: 		void SSD1306_StartScrollLeft(uint8_t start, uint8_t stop) {
;ssd1306oled.c,414 :: 		ssd1306_command(SSD1306_LEFT_HORIZONTAL_SCROLL);
	MOVLW       39
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,415 :: 		ssd1306_command(0X00);
	CLRF        FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,416 :: 		ssd1306_command(start);
	MOVF        FARG_SSD1306_StartScrollLeft_start+0, 0 
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,417 :: 		ssd1306_command(0X00);
	CLRF        FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,418 :: 		ssd1306_command(stop);
	MOVF        FARG_SSD1306_StartScrollLeft_stop+0, 0 
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,419 :: 		ssd1306_command(0X00);
	CLRF        FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,420 :: 		ssd1306_command(0XFF);
	MOVLW       255
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,421 :: 		ssd1306_command(SSD1306_ACTIVATE_SCROLL);
	MOVLW       47
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,422 :: 		}
L_end_SSD1306_StartScrollLeft:
	RETURN      0
; end of _SSD1306_StartScrollLeft

_SSD1306_StartScrollDiagRight:

;ssd1306oled.c,424 :: 		void SSD1306_StartScrollDiagRight(uint8_t start, uint8_t stop) {
;ssd1306oled.c,425 :: 		ssd1306_command(SSD1306_SET_VERTICAL_SCROLL_AREA);
	MOVLW       163
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,426 :: 		ssd1306_command(0X00);
	CLRF        FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,427 :: 		ssd1306_command(SSD1306_LCDHEIGHT);
	MOVLW       64
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,428 :: 		ssd1306_command(SSD1306_VERTICAL_AND_RIGHT_HORIZONTAL_SCROLL);
	MOVLW       41
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,429 :: 		ssd1306_command(0X00);
	CLRF        FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,430 :: 		ssd1306_command(start);
	MOVF        FARG_SSD1306_StartScrollDiagRight_start+0, 0 
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,431 :: 		ssd1306_command(0X00);
	CLRF        FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,432 :: 		ssd1306_command(stop);
	MOVF        FARG_SSD1306_StartScrollDiagRight_stop+0, 0 
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,433 :: 		ssd1306_command(0X01);
	MOVLW       1
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,434 :: 		ssd1306_command(SSD1306_ACTIVATE_SCROLL);
	MOVLW       47
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,435 :: 		}
L_end_SSD1306_StartScrollDiagRight:
	RETURN      0
; end of _SSD1306_StartScrollDiagRight

_SSD1306_StartScrollDiagLeft:

;ssd1306oled.c,437 :: 		void SSD1306_StartScrollDiagLeft(uint8_t start, uint8_t stop) {
;ssd1306oled.c,438 :: 		ssd1306_command(SSD1306_SET_VERTICAL_SCROLL_AREA);
	MOVLW       163
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,439 :: 		ssd1306_command(0X00);
	CLRF        FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,440 :: 		ssd1306_command(SSD1306_LCDHEIGHT);
	MOVLW       64
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,441 :: 		ssd1306_command(SSD1306_VERTICAL_AND_LEFT_HORIZONTAL_SCROLL);
	MOVLW       42
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,442 :: 		ssd1306_command(0X00);
	CLRF        FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,443 :: 		ssd1306_command(start);
	MOVF        FARG_SSD1306_StartScrollDiagLeft_start+0, 0 
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,444 :: 		ssd1306_command(0X00);
	CLRF        FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,445 :: 		ssd1306_command(stop);
	MOVF        FARG_SSD1306_StartScrollDiagLeft_stop+0, 0 
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,446 :: 		ssd1306_command(0X01);
	MOVLW       1
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,447 :: 		ssd1306_command(SSD1306_ACTIVATE_SCROLL);
	MOVLW       47
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,448 :: 		}
L_end_SSD1306_StartScrollDiagLeft:
	RETURN      0
; end of _SSD1306_StartScrollDiagLeft

_SSD1306_StopScroll:

;ssd1306oled.c,450 :: 		void SSD1306_StopScroll(void) {
;ssd1306oled.c,451 :: 		ssd1306_command(SSD1306_DEACTIVATE_SCROLL);
	MOVLW       46
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,452 :: 		}
L_end_SSD1306_StopScroll:
	RETURN      0
; end of _SSD1306_StopScroll

_SSD1306_Dim:

;ssd1306oled.c,454 :: 		void SSD1306_Dim(bool dim) {
;ssd1306oled.c,456 :: 		if (dim)
	MOVF        FARG_SSD1306_Dim_dim+0, 1 
	BTFSC       STATUS+0, 2 
	GOTO        L_SSD1306_Dim11
;ssd1306oled.c,457 :: 		contrast = 0; // Dimmed display
	CLRF        SSD1306_Dim_contrast_L0+0 
	GOTO        L_SSD1306_Dim12
L_SSD1306_Dim11:
;ssd1306oled.c,459 :: 		if (_vccstate == SSD1306_EXTERNALVCC)
	MOVF        __vccstate+0, 0 
	XORLW       1
	BTFSS       STATUS+0, 2 
	GOTO        L_SSD1306_Dim13
;ssd1306oled.c,460 :: 		contrast = 0x9F;
	MOVLW       159
	MOVWF       SSD1306_Dim_contrast_L0+0 
	GOTO        L_SSD1306_Dim14
L_SSD1306_Dim13:
;ssd1306oled.c,462 :: 		contrast = 0xCF;
	MOVLW       207
	MOVWF       SSD1306_Dim_contrast_L0+0 
L_SSD1306_Dim14:
;ssd1306oled.c,463 :: 		}
L_SSD1306_Dim12:
;ssd1306oled.c,466 :: 		ssd1306_command(SSD1306_SETCONTRAST);
	MOVLW       129
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,467 :: 		ssd1306_command(contrast);
	MOVF        SSD1306_Dim_contrast_L0+0, 0 
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,468 :: 		}
L_end_SSD1306_Dim:
	RETURN      0
; end of _SSD1306_Dim

_SSD1306_Display:

;ssd1306oled.c,470 :: 		void SSD1306_Display(void) {
;ssd1306oled.c,473 :: 		ssd1306_command(SSD1306_COLUMNADDR);
	MOVLW       33
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,474 :: 		ssd1306_command(0);   // Column start address (0 = reset)
	CLRF        FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,475 :: 		ssd1306_command(SSD1306_LCDWIDTH-1); // Column end address (127 = reset)
	MOVLW       127
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,477 :: 		ssd1306_command(SSD1306_PAGEADDR);
	MOVLW       34
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,478 :: 		ssd1306_command(0); // Page start address (0 = reset)
	CLRF        FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,480 :: 		ssd1306_command(7); // Page end address
	MOVLW       7
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
;ssd1306oled.c,489 :: 		for (i = 0; i < (SSD1306_LCDWIDTH*SSD1306_LCDHEIGHT / 8); i++) {
	CLRF        SSD1306_Display_i_L0+0 
	CLRF        SSD1306_Display_i_L0+1 
L_SSD1306_Display15:
	MOVLW       4
	SUBWF       SSD1306_Display_i_L0+1, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_Display204
	MOVLW       0
	SUBWF       SSD1306_Display_i_L0+0, 0 
L__SSD1306_Display204:
	BTFSC       STATUS+0, 0 
	GOTO        L_SSD1306_Display16
;ssd1306oled.c,491 :: 		SSD1306_Start();
	CALL        _I2C1_Start+0, 0
;ssd1306oled.c,492 :: 		SSD1306_Write(_i2caddr);
	MOVF        __i2caddr+0, 0 
	MOVWF       FARG_I2C1_Wr_data_+0 
	CALL        _I2C1_Wr+0, 0
;ssd1306oled.c,493 :: 		SSD1306_Write(0x40);
	MOVLW       64
	MOVWF       FARG_I2C1_Wr_data_+0 
	CALL        _I2C1_Wr+0, 0
;ssd1306oled.c,494 :: 		for (x = 0; x < 16; x++) {
	CLRF        SSD1306_Display_x_L0+0 
L_SSD1306_Display18:
	MOVLW       16
	SUBWF       SSD1306_Display_x_L0+0, 0 
	BTFSC       STATUS+0, 0 
	GOTO        L_SSD1306_Display19
;ssd1306oled.c,495 :: 		SSD1306_Write(buffer[i]);
	MOVLW       si5351SDR_firmware_buffer+0
	ADDWF       SSD1306_Display_i_L0+0, 0 
	MOVWF       FSR0L+0 
	MOVLW       hi_addr(si5351SDR_firmware_buffer+0)
	ADDWFC      SSD1306_Display_i_L0+1, 0 
	MOVWF       FSR0L+1 
	MOVF        POSTINC0+0, 0 
	MOVWF       FARG_I2C1_Wr_data_+0 
	CALL        _I2C1_Wr+0, 0
;ssd1306oled.c,496 :: 		i++;
	INFSNZ      SSD1306_Display_i_L0+0, 1 
	INCF        SSD1306_Display_i_L0+1, 1 
;ssd1306oled.c,494 :: 		for (x = 0; x < 16; x++) {
	INCF        SSD1306_Display_x_L0+0, 1 
;ssd1306oled.c,497 :: 		}
	GOTO        L_SSD1306_Display18
L_SSD1306_Display19:
;ssd1306oled.c,498 :: 		i--;
	MOVLW       1
	SUBWF       SSD1306_Display_i_L0+0, 1 
	MOVLW       0
	SUBWFB      SSD1306_Display_i_L0+1, 1 
;ssd1306oled.c,499 :: 		SSD1306_Stop();
	CALL        _I2C1_Stop+0, 0
;ssd1306oled.c,489 :: 		for (i = 0; i < (SSD1306_LCDWIDTH*SSD1306_LCDHEIGHT / 8); i++) {
	INFSNZ      SSD1306_Display_i_L0+0, 1 
	INCF        SSD1306_Display_i_L0+1, 1 
;ssd1306oled.c,500 :: 		}
	GOTO        L_SSD1306_Display15
L_SSD1306_Display16:
;ssd1306oled.c,501 :: 		}
L_end_SSD1306_Display:
	RETURN      0
; end of _SSD1306_Display

_SSD1306_ClearDisplay:

;ssd1306oled.c,503 :: 		void SSD1306_ClearDisplay(void) {
;ssd1306oled.c,505 :: 		for (i = 0; i < (SSD1306_LCDWIDTH*SSD1306_LCDHEIGHT / 8); i++)
	CLRF        R1 
	CLRF        R2 
L_SSD1306_ClearDisplay21:
	MOVLW       128
	XORWF       R2, 0 
	MOVWF       R0 
	MOVLW       128
	XORLW       4
	SUBWF       R0, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_ClearDisplay206
	MOVLW       0
	SUBWF       R1, 0 
L__SSD1306_ClearDisplay206:
	BTFSC       STATUS+0, 0 
	GOTO        L_SSD1306_ClearDisplay22
;ssd1306oled.c,506 :: 		buffer[i] = 0;
	MOVLW       si5351SDR_firmware_buffer+0
	ADDWF       R1, 0 
	MOVWF       FSR1L+0 
	MOVLW       hi_addr(si5351SDR_firmware_buffer+0)
	ADDWFC      R2, 0 
	MOVWF       FSR1L+1 
	CLRF        POSTINC1+0 
;ssd1306oled.c,505 :: 		for (i = 0; i < (SSD1306_LCDWIDTH*SSD1306_LCDHEIGHT / 8); i++)
	INFSNZ      R1, 1 
	INCF        R2, 1 
;ssd1306oled.c,506 :: 		buffer[i] = 0;
	GOTO        L_SSD1306_ClearDisplay21
L_SSD1306_ClearDisplay22:
;ssd1306oled.c,507 :: 		}
L_end_SSD1306_ClearDisplay:
	RETURN      0
; end of _SSD1306_ClearDisplay

_SSD1306_DrawLine:

;ssd1306oled.c,509 :: 		void SSD1306_DrawLine(int16_t x0, int16_t y0, int16_t x1, int16_t y1) {
;ssd1306oled.c,514 :: 		steep = abs(y1 - y0) > abs(x1 - x0);
	MOVF        FARG_SSD1306_DrawLine_y0+0, 0 
	SUBWF       FARG_SSD1306_DrawLine_y1+0, 0 
	MOVWF       FARG_abs_a+0 
	MOVF        FARG_SSD1306_DrawLine_y0+1, 0 
	SUBWFB      FARG_SSD1306_DrawLine_y1+1, 0 
	MOVWF       FARG_abs_a+1 
	CALL        _abs+0, 0
	MOVF        R0, 0 
	MOVWF       FLOC__SSD1306_DrawLine+0 
	MOVF        R1, 0 
	MOVWF       FLOC__SSD1306_DrawLine+1 
	MOVF        FARG_SSD1306_DrawLine_x0+0, 0 
	SUBWF       FARG_SSD1306_DrawLine_x1+0, 0 
	MOVWF       FARG_abs_a+0 
	MOVF        FARG_SSD1306_DrawLine_x0+1, 0 
	SUBWFB      FARG_SSD1306_DrawLine_x1+1, 0 
	MOVWF       FARG_abs_a+1 
	CALL        _abs+0, 0
	MOVLW       128
	XORWF       R1, 0 
	MOVWF       R2 
	MOVLW       128
	XORWF       FLOC__SSD1306_DrawLine+1, 0 
	SUBWF       R2, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_DrawLine208
	MOVF        FLOC__SSD1306_DrawLine+0, 0 
	SUBWF       R0, 0 
L__SSD1306_DrawLine208:
	MOVLW       1
	BTFSC       STATUS+0, 0 
	MOVLW       0
	MOVWF       R2 
	MOVF        R2, 0 
	MOVWF       SSD1306_DrawLine_steep_L0+0 
;ssd1306oled.c,515 :: 		if (steep) {
	MOVF        R2, 1 
	BTFSC       STATUS+0, 2 
	GOTO        L_SSD1306_DrawLine24
;ssd1306oled.c,516 :: 		ssd1306_swap(x0, y0);
	MOVF        FARG_SSD1306_DrawLine_x0+0, 0 
	MOVWF       SSD1306_DrawLine_t_L2+0 
	MOVF        FARG_SSD1306_DrawLine_x0+1, 0 
	MOVWF       SSD1306_DrawLine_t_L2+1 
	MOVF        FARG_SSD1306_DrawLine_y0+0, 0 
	MOVWF       FARG_SSD1306_DrawLine_x0+0 
	MOVF        FARG_SSD1306_DrawLine_y0+1, 0 
	MOVWF       FARG_SSD1306_DrawLine_x0+1 
	MOVF        SSD1306_DrawLine_t_L2+0, 0 
	MOVWF       FARG_SSD1306_DrawLine_y0+0 
	MOVF        SSD1306_DrawLine_t_L2+1, 0 
	MOVWF       FARG_SSD1306_DrawLine_y0+1 
;ssd1306oled.c,517 :: 		ssd1306_swap(x1, y1);
	MOVF        FARG_SSD1306_DrawLine_x1+0, 0 
	MOVWF       SSD1306_DrawLine_t_L2_L2+0 
	MOVF        FARG_SSD1306_DrawLine_x1+1, 0 
	MOVWF       SSD1306_DrawLine_t_L2_L2+1 
	MOVF        FARG_SSD1306_DrawLine_y1+0, 0 
	MOVWF       FARG_SSD1306_DrawLine_x1+0 
	MOVF        FARG_SSD1306_DrawLine_y1+1, 0 
	MOVWF       FARG_SSD1306_DrawLine_x1+1 
	MOVF        SSD1306_DrawLine_t_L2_L2+0, 0 
	MOVWF       FARG_SSD1306_DrawLine_y1+0 
	MOVF        SSD1306_DrawLine_t_L2_L2+1, 0 
	MOVWF       FARG_SSD1306_DrawLine_y1+1 
;ssd1306oled.c,518 :: 		}
L_SSD1306_DrawLine24:
;ssd1306oled.c,519 :: 		if (x0 > x1) {
	MOVLW       128
	XORWF       FARG_SSD1306_DrawLine_x1+1, 0 
	MOVWF       R0 
	MOVLW       128
	XORWF       FARG_SSD1306_DrawLine_x0+1, 0 
	SUBWF       R0, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_DrawLine209
	MOVF        FARG_SSD1306_DrawLine_x0+0, 0 
	SUBWF       FARG_SSD1306_DrawLine_x1+0, 0 
L__SSD1306_DrawLine209:
	BTFSC       STATUS+0, 0 
	GOTO        L_SSD1306_DrawLine25
;ssd1306oled.c,520 :: 		ssd1306_swap(x0, x1);
	MOVF        FARG_SSD1306_DrawLine_x0+0, 0 
	MOVWF       SSD1306_DrawLine_t_L2_L2_L2+0 
	MOVF        FARG_SSD1306_DrawLine_x0+1, 0 
	MOVWF       SSD1306_DrawLine_t_L2_L2_L2+1 
	MOVF        FARG_SSD1306_DrawLine_x1+0, 0 
	MOVWF       FARG_SSD1306_DrawLine_x0+0 
	MOVF        FARG_SSD1306_DrawLine_x1+1, 0 
	MOVWF       FARG_SSD1306_DrawLine_x0+1 
	MOVF        SSD1306_DrawLine_t_L2_L2_L2+0, 0 
	MOVWF       FARG_SSD1306_DrawLine_x1+0 
	MOVF        SSD1306_DrawLine_t_L2_L2_L2+1, 0 
	MOVWF       FARG_SSD1306_DrawLine_x1+1 
;ssd1306oled.c,521 :: 		ssd1306_swap(y0, y1);
	MOVF        FARG_SSD1306_DrawLine_y0+0, 0 
	MOVWF       SSD1306_DrawLine_t_L2_L2_L2_L2+0 
	MOVF        FARG_SSD1306_DrawLine_y0+1, 0 
	MOVWF       SSD1306_DrawLine_t_L2_L2_L2_L2+1 
	MOVF        FARG_SSD1306_DrawLine_y1+0, 0 
	MOVWF       FARG_SSD1306_DrawLine_y0+0 
	MOVF        FARG_SSD1306_DrawLine_y1+1, 0 
	MOVWF       FARG_SSD1306_DrawLine_y0+1 
	MOVF        SSD1306_DrawLine_t_L2_L2_L2_L2+0, 0 
	MOVWF       FARG_SSD1306_DrawLine_y1+0 
	MOVF        SSD1306_DrawLine_t_L2_L2_L2_L2+1, 0 
	MOVWF       FARG_SSD1306_DrawLine_y1+1 
;ssd1306oled.c,522 :: 		}
L_SSD1306_DrawLine25:
;ssd1306oled.c,523 :: 		dx = x1 - x0;
	MOVF        FARG_SSD1306_DrawLine_x0+0, 0 
	SUBWF       FARG_SSD1306_DrawLine_x1+0, 0 
	MOVWF       SSD1306_DrawLine_dx_L0+0 
;ssd1306oled.c,524 :: 		dy = abs(y1 - y0);
	MOVF        FARG_SSD1306_DrawLine_y0+0, 0 
	SUBWF       FARG_SSD1306_DrawLine_y1+0, 0 
	MOVWF       FARG_abs_a+0 
	MOVF        FARG_SSD1306_DrawLine_y0+1, 0 
	SUBWFB      FARG_SSD1306_DrawLine_y1+1, 0 
	MOVWF       FARG_abs_a+1 
	CALL        _abs+0, 0
	MOVF        R0, 0 
	MOVWF       SSD1306_DrawLine_dy_L0+0 
;ssd1306oled.c,526 :: 		err = dx / 2;
	MOVF        SSD1306_DrawLine_dx_L0+0, 0 
	MOVWF       SSD1306_DrawLine_err_L0+0 
	MOVLW       0
	MOVWF       SSD1306_DrawLine_err_L0+1 
	RRCF        SSD1306_DrawLine_err_L0+0, 1 
	BCF         SSD1306_DrawLine_err_L0+0, 7 
	MOVLW       0
	MOVWF       SSD1306_DrawLine_err_L0+1 
;ssd1306oled.c,527 :: 		if (y0 < y1)
	MOVLW       128
	XORWF       FARG_SSD1306_DrawLine_y0+1, 0 
	MOVWF       R0 
	MOVLW       128
	XORWF       FARG_SSD1306_DrawLine_y1+1, 0 
	SUBWF       R0, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_DrawLine210
	MOVF        FARG_SSD1306_DrawLine_y1+0, 0 
	SUBWF       FARG_SSD1306_DrawLine_y0+0, 0 
L__SSD1306_DrawLine210:
	BTFSC       STATUS+0, 0 
	GOTO        L_SSD1306_DrawLine26
;ssd1306oled.c,528 :: 		ystep = 1;
	MOVLW       1
	MOVWF       SSD1306_DrawLine_ystep_L0+0 
	GOTO        L_SSD1306_DrawLine27
L_SSD1306_DrawLine26:
;ssd1306oled.c,530 :: 		ystep = -1;
	MOVLW       255
	MOVWF       SSD1306_DrawLine_ystep_L0+0 
L_SSD1306_DrawLine27:
;ssd1306oled.c,532 :: 		for (; x0 <= x1; x0++) {
L_SSD1306_DrawLine28:
	MOVLW       128
	XORWF       FARG_SSD1306_DrawLine_x1+1, 0 
	MOVWF       R0 
	MOVLW       128
	XORWF       FARG_SSD1306_DrawLine_x0+1, 0 
	SUBWF       R0, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_DrawLine211
	MOVF        FARG_SSD1306_DrawLine_x0+0, 0 
	SUBWF       FARG_SSD1306_DrawLine_x1+0, 0 
L__SSD1306_DrawLine211:
	BTFSS       STATUS+0, 0 
	GOTO        L_SSD1306_DrawLine29
;ssd1306oled.c,533 :: 		if (steep)
	MOVF        SSD1306_DrawLine_steep_L0+0, 1 
	BTFSC       STATUS+0, 2 
	GOTO        L_SSD1306_DrawLine31
;ssd1306oled.c,534 :: 		SSD1306_DrawPixel(y0, x0);
	MOVF        FARG_SSD1306_DrawLine_y0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_x+0 
	MOVF        FARG_SSD1306_DrawLine_x0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_y+0 
	CALL        _SSD1306_DrawPixel+0, 0
	GOTO        L_SSD1306_DrawLine32
L_SSD1306_DrawLine31:
;ssd1306oled.c,536 :: 		SSD1306_DrawPixel(x0, y0);
	MOVF        FARG_SSD1306_DrawLine_x0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_x+0 
	MOVF        FARG_SSD1306_DrawLine_y0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_y+0 
	CALL        _SSD1306_DrawPixel+0, 0
L_SSD1306_DrawLine32:
;ssd1306oled.c,537 :: 		err -= dy;
	MOVF        SSD1306_DrawLine_dy_L0+0, 0 
	SUBWF       SSD1306_DrawLine_err_L0+0, 0 
	MOVWF       R1 
	MOVLW       0
	SUBWFB      SSD1306_DrawLine_err_L0+1, 0 
	MOVWF       R2 
	MOVF        R1, 0 
	MOVWF       SSD1306_DrawLine_err_L0+0 
	MOVF        R2, 0 
	MOVWF       SSD1306_DrawLine_err_L0+1 
;ssd1306oled.c,538 :: 		if (err < 0) {
	MOVLW       128
	XORWF       R2, 0 
	MOVWF       R0 
	MOVLW       128
	SUBWF       R0, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_DrawLine212
	MOVLW       0
	SUBWF       R1, 0 
L__SSD1306_DrawLine212:
	BTFSC       STATUS+0, 0 
	GOTO        L_SSD1306_DrawLine33
;ssd1306oled.c,539 :: 		y0  += ystep;
	MOVF        SSD1306_DrawLine_ystep_L0+0, 0 
	ADDWF       FARG_SSD1306_DrawLine_y0+0, 1 
	MOVLW       0
	BTFSC       SSD1306_DrawLine_ystep_L0+0, 7 
	MOVLW       255
	ADDWFC      FARG_SSD1306_DrawLine_y0+1, 1 
;ssd1306oled.c,540 :: 		err += dx;
	MOVF        SSD1306_DrawLine_dx_L0+0, 0 
	ADDWF       SSD1306_DrawLine_err_L0+0, 1 
	MOVLW       0
	ADDWFC      SSD1306_DrawLine_err_L0+1, 1 
;ssd1306oled.c,541 :: 		}
L_SSD1306_DrawLine33:
;ssd1306oled.c,532 :: 		for (; x0 <= x1; x0++) {
	INFSNZ      FARG_SSD1306_DrawLine_x0+0, 1 
	INCF        FARG_SSD1306_DrawLine_x0+1, 1 
;ssd1306oled.c,542 :: 		}
	GOTO        L_SSD1306_DrawLine28
L_SSD1306_DrawLine29:
;ssd1306oled.c,543 :: 		}
L_end_SSD1306_DrawLine:
	RETURN      0
; end of _SSD1306_DrawLine

_SSD1306_DrawFastHLine:

;ssd1306oled.c,545 :: 		void SSD1306_DrawFastHLine(uint8_t x, uint8_t y, uint8_t w) {
;ssd1306oled.c,546 :: 		SSD1306_DrawLine(x, y, x + w - 1, y);
	MOVF        FARG_SSD1306_DrawFastHLine_x+0, 0 
	MOVWF       FARG_SSD1306_DrawLine_x0+0 
	MOVLW       0
	MOVWF       FARG_SSD1306_DrawLine_x0+1 
	MOVF        FARG_SSD1306_DrawFastHLine_y+0, 0 
	MOVWF       FARG_SSD1306_DrawLine_y0+0 
	MOVLW       0
	MOVWF       FARG_SSD1306_DrawLine_y0+1 
	MOVF        FARG_SSD1306_DrawFastHLine_w+0, 0 
	ADDWF       FARG_SSD1306_DrawFastHLine_x+0, 0 
	MOVWF       FARG_SSD1306_DrawLine_x1+0 
	CLRF        FARG_SSD1306_DrawLine_x1+1 
	MOVLW       0
	ADDWFC      FARG_SSD1306_DrawLine_x1+1, 1 
	MOVLW       1
	SUBWF       FARG_SSD1306_DrawLine_x1+0, 1 
	MOVLW       0
	SUBWFB      FARG_SSD1306_DrawLine_x1+1, 1 
	MOVF        FARG_SSD1306_DrawFastHLine_y+0, 0 
	MOVWF       FARG_SSD1306_DrawLine_y1+0 
	MOVLW       0
	MOVWF       FARG_SSD1306_DrawLine_y1+1 
	CALL        _SSD1306_DrawLine+0, 0
;ssd1306oled.c,547 :: 		}
L_end_SSD1306_DrawFastHLine:
	RETURN      0
; end of _SSD1306_DrawFastHLine

_SSD1306_DrawFastVLine:

;ssd1306oled.c,549 :: 		void SSD1306_DrawFastVLine(uint8_t x, uint8_t y, uint8_t h) {
;ssd1306oled.c,550 :: 		SSD1306_DrawLine(x, y, x, y + h - 1);
	MOVF        FARG_SSD1306_DrawFastVLine_x+0, 0 
	MOVWF       FARG_SSD1306_DrawLine_x0+0 
	MOVLW       0
	MOVWF       FARG_SSD1306_DrawLine_x0+1 
	MOVF        FARG_SSD1306_DrawFastVLine_y+0, 0 
	MOVWF       FARG_SSD1306_DrawLine_y0+0 
	MOVLW       0
	MOVWF       FARG_SSD1306_DrawLine_y0+1 
	MOVF        FARG_SSD1306_DrawFastVLine_x+0, 0 
	MOVWF       FARG_SSD1306_DrawLine_x1+0 
	MOVLW       0
	MOVWF       FARG_SSD1306_DrawLine_x1+1 
	MOVF        FARG_SSD1306_DrawFastVLine_h+0, 0 
	ADDWF       FARG_SSD1306_DrawFastVLine_y+0, 0 
	MOVWF       FARG_SSD1306_DrawLine_y1+0 
	CLRF        FARG_SSD1306_DrawLine_y1+1 
	MOVLW       0
	ADDWFC      FARG_SSD1306_DrawLine_y1+1, 1 
	MOVLW       1
	SUBWF       FARG_SSD1306_DrawLine_y1+0, 1 
	MOVLW       0
	SUBWFB      FARG_SSD1306_DrawLine_y1+1, 1 
	CALL        _SSD1306_DrawLine+0, 0
;ssd1306oled.c,551 :: 		}
L_end_SSD1306_DrawFastVLine:
	RETURN      0
; end of _SSD1306_DrawFastVLine

_SSD1306_FillRect:

;ssd1306oled.c,553 :: 		void SSD1306_FillRect(uint8_t x, uint8_t y, uint8_t w, uint8_t h) {
;ssd1306oled.c,555 :: 		for (i = x; i < x + w; i++)
	MOVF        FARG_SSD1306_FillRect_x+0, 0 
	MOVWF       SSD1306_FillRect_i_L0+0 
	MOVLW       0
	MOVWF       SSD1306_FillRect_i_L0+1 
L_SSD1306_FillRect34:
	MOVF        FARG_SSD1306_FillRect_w+0, 0 
	ADDWF       FARG_SSD1306_FillRect_x+0, 0 
	MOVWF       R1 
	CLRF        R2 
	MOVLW       0
	ADDWFC      R2, 1 
	MOVLW       128
	XORWF       SSD1306_FillRect_i_L0+1, 0 
	MOVWF       R0 
	MOVLW       128
	XORWF       R2, 0 
	SUBWF       R0, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_FillRect216
	MOVF        R1, 0 
	SUBWF       SSD1306_FillRect_i_L0+0, 0 
L__SSD1306_FillRect216:
	BTFSC       STATUS+0, 0 
	GOTO        L_SSD1306_FillRect35
;ssd1306oled.c,556 :: 		SSD1306_DrawFastVLine(i, y, h);
	MOVF        SSD1306_FillRect_i_L0+0, 0 
	MOVWF       FARG_SSD1306_DrawFastVLine_x+0 
	MOVF        FARG_SSD1306_FillRect_y+0, 0 
	MOVWF       FARG_SSD1306_DrawFastVLine_y+0 
	MOVF        FARG_SSD1306_FillRect_h+0, 0 
	MOVWF       FARG_SSD1306_DrawFastVLine_h+0 
	CALL        _SSD1306_DrawFastVLine+0, 0
;ssd1306oled.c,555 :: 		for (i = x; i < x + w; i++)
	INFSNZ      SSD1306_FillRect_i_L0+0, 1 
	INCF        SSD1306_FillRect_i_L0+1, 1 
;ssd1306oled.c,556 :: 		SSD1306_DrawFastVLine(i, y, h);
	GOTO        L_SSD1306_FillRect34
L_SSD1306_FillRect35:
;ssd1306oled.c,557 :: 		}
L_end_SSD1306_FillRect:
	RETURN      0
; end of _SSD1306_FillRect

_SSD1306_DrawCircle:

;ssd1306oled.c,559 :: 		void SSD1306_DrawCircle(int16_t x0, int16_t y0, int16_t r) {
;ssd1306oled.c,560 :: 		int16_t f = 1 - r;
	MOVF        FARG_SSD1306_DrawCircle_r+0, 0 
	SUBLW       1
	MOVWF       SSD1306_DrawCircle_f_L0+0 
	MOVF        FARG_SSD1306_DrawCircle_r+1, 0 
	MOVWF       SSD1306_DrawCircle_f_L0+1 
	MOVLW       0
	SUBFWB      SSD1306_DrawCircle_f_L0+1, 1 
;ssd1306oled.c,561 :: 		int16_t ddF_x = 1;
	MOVLW       1
	MOVWF       SSD1306_DrawCircle_ddF_x_L0+0 
	MOVLW       0
	MOVWF       SSD1306_DrawCircle_ddF_x_L0+1 
;ssd1306oled.c,562 :: 		int16_t ddF_y = -2 * r;
	MOVLW       254
	MOVWF       R0 
	MOVLW       255
	MOVWF       R1 
	MOVF        FARG_SSD1306_DrawCircle_r+0, 0 
	MOVWF       R4 
	MOVF        FARG_SSD1306_DrawCircle_r+1, 0 
	MOVWF       R5 
	CALL        _Mul_16X16_U+0, 0
	MOVF        R0, 0 
	MOVWF       SSD1306_DrawCircle_ddF_y_L0+0 
	MOVF        R1, 0 
	MOVWF       SSD1306_DrawCircle_ddF_y_L0+1 
;ssd1306oled.c,563 :: 		int16_t x = 0;
	CLRF        SSD1306_DrawCircle_x_L0+0 
	CLRF        SSD1306_DrawCircle_x_L0+1 
;ssd1306oled.c,564 :: 		int16_t y = r;
	MOVF        FARG_SSD1306_DrawCircle_r+0, 0 
	MOVWF       SSD1306_DrawCircle_y_L0+0 
	MOVF        FARG_SSD1306_DrawCircle_r+1, 0 
	MOVWF       SSD1306_DrawCircle_y_L0+1 
;ssd1306oled.c,566 :: 		SSD1306_DrawPixel(x0  , y0 + r);
	MOVF        FARG_SSD1306_DrawCircle_x0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_x+0 
	MOVF        FARG_SSD1306_DrawCircle_r+0, 0 
	ADDWF       FARG_SSD1306_DrawCircle_y0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_y+0 
	CALL        _SSD1306_DrawPixel+0, 0
;ssd1306oled.c,567 :: 		SSD1306_DrawPixel(x0  , y0 - r);
	MOVF        FARG_SSD1306_DrawCircle_x0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_x+0 
	MOVF        FARG_SSD1306_DrawCircle_r+0, 0 
	SUBWF       FARG_SSD1306_DrawCircle_y0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_y+0 
	CALL        _SSD1306_DrawPixel+0, 0
;ssd1306oled.c,568 :: 		SSD1306_DrawPixel(x0 + r, y0);
	MOVF        FARG_SSD1306_DrawCircle_r+0, 0 
	ADDWF       FARG_SSD1306_DrawCircle_x0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_x+0 
	MOVF        FARG_SSD1306_DrawCircle_y0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_y+0 
	CALL        _SSD1306_DrawPixel+0, 0
;ssd1306oled.c,569 :: 		SSD1306_DrawPixel(x0 - r, y0);
	MOVF        FARG_SSD1306_DrawCircle_r+0, 0 
	SUBWF       FARG_SSD1306_DrawCircle_x0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_x+0 
	MOVF        FARG_SSD1306_DrawCircle_y0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_y+0 
	CALL        _SSD1306_DrawPixel+0, 0
;ssd1306oled.c,571 :: 		while (x < y) {
L_SSD1306_DrawCircle37:
	MOVLW       128
	XORWF       SSD1306_DrawCircle_x_L0+1, 0 
	MOVWF       R0 
	MOVLW       128
	XORWF       SSD1306_DrawCircle_y_L0+1, 0 
	SUBWF       R0, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_DrawCircle218
	MOVF        SSD1306_DrawCircle_y_L0+0, 0 
	SUBWF       SSD1306_DrawCircle_x_L0+0, 0 
L__SSD1306_DrawCircle218:
	BTFSC       STATUS+0, 0 
	GOTO        L_SSD1306_DrawCircle38
;ssd1306oled.c,572 :: 		if (f >= 0) {
	MOVLW       128
	XORWF       SSD1306_DrawCircle_f_L0+1, 0 
	MOVWF       R0 
	MOVLW       128
	SUBWF       R0, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_DrawCircle219
	MOVLW       0
	SUBWF       SSD1306_DrawCircle_f_L0+0, 0 
L__SSD1306_DrawCircle219:
	BTFSS       STATUS+0, 0 
	GOTO        L_SSD1306_DrawCircle39
;ssd1306oled.c,573 :: 		y--;
	MOVLW       1
	SUBWF       SSD1306_DrawCircle_y_L0+0, 1 
	MOVLW       0
	SUBWFB      SSD1306_DrawCircle_y_L0+1, 1 
;ssd1306oled.c,574 :: 		ddF_y += 2;
	MOVLW       2
	ADDWF       SSD1306_DrawCircle_ddF_y_L0+0, 0 
	MOVWF       R0 
	MOVLW       0
	ADDWFC      SSD1306_DrawCircle_ddF_y_L0+1, 0 
	MOVWF       R1 
	MOVF        R0, 0 
	MOVWF       SSD1306_DrawCircle_ddF_y_L0+0 
	MOVF        R1, 0 
	MOVWF       SSD1306_DrawCircle_ddF_y_L0+1 
;ssd1306oled.c,575 :: 		f += ddF_y;
	MOVF        R0, 0 
	ADDWF       SSD1306_DrawCircle_f_L0+0, 1 
	MOVF        R1, 0 
	ADDWFC      SSD1306_DrawCircle_f_L0+1, 1 
;ssd1306oled.c,576 :: 		}
L_SSD1306_DrawCircle39:
;ssd1306oled.c,577 :: 		x++;
	INFSNZ      SSD1306_DrawCircle_x_L0+0, 1 
	INCF        SSD1306_DrawCircle_x_L0+1, 1 
;ssd1306oled.c,578 :: 		ddF_x += 2;
	MOVLW       2
	ADDWF       SSD1306_DrawCircle_ddF_x_L0+0, 0 
	MOVWF       R0 
	MOVLW       0
	ADDWFC      SSD1306_DrawCircle_ddF_x_L0+1, 0 
	MOVWF       R1 
	MOVF        R0, 0 
	MOVWF       SSD1306_DrawCircle_ddF_x_L0+0 
	MOVF        R1, 0 
	MOVWF       SSD1306_DrawCircle_ddF_x_L0+1 
;ssd1306oled.c,579 :: 		f += ddF_x;
	MOVF        R0, 0 
	ADDWF       SSD1306_DrawCircle_f_L0+0, 1 
	MOVF        R1, 0 
	ADDWFC      SSD1306_DrawCircle_f_L0+1, 1 
;ssd1306oled.c,581 :: 		SSD1306_DrawPixel(x0 + x, y0 + y);
	MOVF        SSD1306_DrawCircle_x_L0+0, 0 
	ADDWF       FARG_SSD1306_DrawCircle_x0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_x+0 
	MOVF        SSD1306_DrawCircle_y_L0+0, 0 
	ADDWF       FARG_SSD1306_DrawCircle_y0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_y+0 
	CALL        _SSD1306_DrawPixel+0, 0
;ssd1306oled.c,582 :: 		SSD1306_DrawPixel(x0 - x, y0 + y);
	MOVF        SSD1306_DrawCircle_x_L0+0, 0 
	SUBWF       FARG_SSD1306_DrawCircle_x0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_x+0 
	MOVF        SSD1306_DrawCircle_y_L0+0, 0 
	ADDWF       FARG_SSD1306_DrawCircle_y0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_y+0 
	CALL        _SSD1306_DrawPixel+0, 0
;ssd1306oled.c,583 :: 		SSD1306_DrawPixel(x0 + x, y0 - y);
	MOVF        SSD1306_DrawCircle_x_L0+0, 0 
	ADDWF       FARG_SSD1306_DrawCircle_x0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_x+0 
	MOVF        SSD1306_DrawCircle_y_L0+0, 0 
	SUBWF       FARG_SSD1306_DrawCircle_y0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_y+0 
	CALL        _SSD1306_DrawPixel+0, 0
;ssd1306oled.c,584 :: 		SSD1306_DrawPixel(x0 - x, y0 - y);
	MOVF        SSD1306_DrawCircle_x_L0+0, 0 
	SUBWF       FARG_SSD1306_DrawCircle_x0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_x+0 
	MOVF        SSD1306_DrawCircle_y_L0+0, 0 
	SUBWF       FARG_SSD1306_DrawCircle_y0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_y+0 
	CALL        _SSD1306_DrawPixel+0, 0
;ssd1306oled.c,585 :: 		SSD1306_DrawPixel(x0 + y, y0 + x);
	MOVF        SSD1306_DrawCircle_y_L0+0, 0 
	ADDWF       FARG_SSD1306_DrawCircle_x0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_x+0 
	MOVF        SSD1306_DrawCircle_x_L0+0, 0 
	ADDWF       FARG_SSD1306_DrawCircle_y0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_y+0 
	CALL        _SSD1306_DrawPixel+0, 0
;ssd1306oled.c,586 :: 		SSD1306_DrawPixel(x0 - y, y0 + x);
	MOVF        SSD1306_DrawCircle_y_L0+0, 0 
	SUBWF       FARG_SSD1306_DrawCircle_x0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_x+0 
	MOVF        SSD1306_DrawCircle_x_L0+0, 0 
	ADDWF       FARG_SSD1306_DrawCircle_y0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_y+0 
	CALL        _SSD1306_DrawPixel+0, 0
;ssd1306oled.c,587 :: 		SSD1306_DrawPixel(x0 + y, y0 - x);
	MOVF        SSD1306_DrawCircle_y_L0+0, 0 
	ADDWF       FARG_SSD1306_DrawCircle_x0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_x+0 
	MOVF        SSD1306_DrawCircle_x_L0+0, 0 
	SUBWF       FARG_SSD1306_DrawCircle_y0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_y+0 
	CALL        _SSD1306_DrawPixel+0, 0
;ssd1306oled.c,588 :: 		SSD1306_DrawPixel(x0 - y, y0 - x);
	MOVF        SSD1306_DrawCircle_y_L0+0, 0 
	SUBWF       FARG_SSD1306_DrawCircle_x0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_x+0 
	MOVF        SSD1306_DrawCircle_x_L0+0, 0 
	SUBWF       FARG_SSD1306_DrawCircle_y0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_y+0 
	CALL        _SSD1306_DrawPixel+0, 0
;ssd1306oled.c,589 :: 		}
	GOTO        L_SSD1306_DrawCircle37
L_SSD1306_DrawCircle38:
;ssd1306oled.c,591 :: 		}
L_end_SSD1306_DrawCircle:
	RETURN      0
; end of _SSD1306_DrawCircle

_SSD1306_DrawCircleHelper:

;ssd1306oled.c,593 :: 		void SSD1306_DrawCircleHelper(int16_t x0, int16_t y0, int16_t r, uint8_t cornername) {
;ssd1306oled.c,594 :: 		int16_t f     = 1 - r;
	MOVF        FARG_SSD1306_DrawCircleHelper_r+0, 0 
	SUBLW       1
	MOVWF       SSD1306_DrawCircleHelper_f_L0+0 
	MOVF        FARG_SSD1306_DrawCircleHelper_r+1, 0 
	MOVWF       SSD1306_DrawCircleHelper_f_L0+1 
	MOVLW       0
	SUBFWB      SSD1306_DrawCircleHelper_f_L0+1, 1 
;ssd1306oled.c,595 :: 		int16_t ddF_x = 1;
	MOVLW       1
	MOVWF       SSD1306_DrawCircleHelper_ddF_x_L0+0 
	MOVLW       0
	MOVWF       SSD1306_DrawCircleHelper_ddF_x_L0+1 
;ssd1306oled.c,596 :: 		int16_t ddF_y = -2 * r;
	MOVLW       254
	MOVWF       R0 
	MOVLW       255
	MOVWF       R1 
	MOVF        FARG_SSD1306_DrawCircleHelper_r+0, 0 
	MOVWF       R4 
	MOVF        FARG_SSD1306_DrawCircleHelper_r+1, 0 
	MOVWF       R5 
	CALL        _Mul_16X16_U+0, 0
	MOVF        R0, 0 
	MOVWF       SSD1306_DrawCircleHelper_ddF_y_L0+0 
	MOVF        R1, 0 
	MOVWF       SSD1306_DrawCircleHelper_ddF_y_L0+1 
;ssd1306oled.c,597 :: 		int16_t x     = 0;
	CLRF        SSD1306_DrawCircleHelper_x_L0+0 
	CLRF        SSD1306_DrawCircleHelper_x_L0+1 
;ssd1306oled.c,598 :: 		int16_t y     = r;
	MOVF        FARG_SSD1306_DrawCircleHelper_r+0, 0 
	MOVWF       SSD1306_DrawCircleHelper_y_L0+0 
	MOVF        FARG_SSD1306_DrawCircleHelper_r+1, 0 
	MOVWF       SSD1306_DrawCircleHelper_y_L0+1 
;ssd1306oled.c,600 :: 		while (x < y) {
L_SSD1306_DrawCircleHelper40:
	MOVLW       128
	XORWF       SSD1306_DrawCircleHelper_x_L0+1, 0 
	MOVWF       R0 
	MOVLW       128
	XORWF       SSD1306_DrawCircleHelper_y_L0+1, 0 
	SUBWF       R0, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_DrawCircleHelper221
	MOVF        SSD1306_DrawCircleHelper_y_L0+0, 0 
	SUBWF       SSD1306_DrawCircleHelper_x_L0+0, 0 
L__SSD1306_DrawCircleHelper221:
	BTFSC       STATUS+0, 0 
	GOTO        L_SSD1306_DrawCircleHelper41
;ssd1306oled.c,601 :: 		if (f >= 0) {
	MOVLW       128
	XORWF       SSD1306_DrawCircleHelper_f_L0+1, 0 
	MOVWF       R0 
	MOVLW       128
	SUBWF       R0, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_DrawCircleHelper222
	MOVLW       0
	SUBWF       SSD1306_DrawCircleHelper_f_L0+0, 0 
L__SSD1306_DrawCircleHelper222:
	BTFSS       STATUS+0, 0 
	GOTO        L_SSD1306_DrawCircleHelper42
;ssd1306oled.c,602 :: 		y--;
	MOVLW       1
	SUBWF       SSD1306_DrawCircleHelper_y_L0+0, 1 
	MOVLW       0
	SUBWFB      SSD1306_DrawCircleHelper_y_L0+1, 1 
;ssd1306oled.c,603 :: 		ddF_y += 2;
	MOVLW       2
	ADDWF       SSD1306_DrawCircleHelper_ddF_y_L0+0, 0 
	MOVWF       R0 
	MOVLW       0
	ADDWFC      SSD1306_DrawCircleHelper_ddF_y_L0+1, 0 
	MOVWF       R1 
	MOVF        R0, 0 
	MOVWF       SSD1306_DrawCircleHelper_ddF_y_L0+0 
	MOVF        R1, 0 
	MOVWF       SSD1306_DrawCircleHelper_ddF_y_L0+1 
;ssd1306oled.c,604 :: 		f     += ddF_y;
	MOVF        R0, 0 
	ADDWF       SSD1306_DrawCircleHelper_f_L0+0, 1 
	MOVF        R1, 0 
	ADDWFC      SSD1306_DrawCircleHelper_f_L0+1, 1 
;ssd1306oled.c,605 :: 		}
L_SSD1306_DrawCircleHelper42:
;ssd1306oled.c,606 :: 		x++;
	INFSNZ      SSD1306_DrawCircleHelper_x_L0+0, 1 
	INCF        SSD1306_DrawCircleHelper_x_L0+1, 1 
;ssd1306oled.c,607 :: 		ddF_x += 2;
	MOVLW       2
	ADDWF       SSD1306_DrawCircleHelper_ddF_x_L0+0, 0 
	MOVWF       R0 
	MOVLW       0
	ADDWFC      SSD1306_DrawCircleHelper_ddF_x_L0+1, 0 
	MOVWF       R1 
	MOVF        R0, 0 
	MOVWF       SSD1306_DrawCircleHelper_ddF_x_L0+0 
	MOVF        R1, 0 
	MOVWF       SSD1306_DrawCircleHelper_ddF_x_L0+1 
;ssd1306oled.c,608 :: 		f     += ddF_x;
	MOVF        R0, 0 
	ADDWF       SSD1306_DrawCircleHelper_f_L0+0, 1 
	MOVF        R1, 0 
	ADDWFC      SSD1306_DrawCircleHelper_f_L0+1, 1 
;ssd1306oled.c,609 :: 		if (cornername & 0x4) {
	BTFSS       FARG_SSD1306_DrawCircleHelper_cornername+0, 2 
	GOTO        L_SSD1306_DrawCircleHelper43
;ssd1306oled.c,610 :: 		SSD1306_DrawPixel(x0 + x, y0 + y);
	MOVF        SSD1306_DrawCircleHelper_x_L0+0, 0 
	ADDWF       FARG_SSD1306_DrawCircleHelper_x0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_x+0 
	MOVF        SSD1306_DrawCircleHelper_y_L0+0, 0 
	ADDWF       FARG_SSD1306_DrawCircleHelper_y0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_y+0 
	CALL        _SSD1306_DrawPixel+0, 0
;ssd1306oled.c,611 :: 		SSD1306_DrawPixel(x0 + y, y0 + x);
	MOVF        SSD1306_DrawCircleHelper_y_L0+0, 0 
	ADDWF       FARG_SSD1306_DrawCircleHelper_x0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_x+0 
	MOVF        SSD1306_DrawCircleHelper_x_L0+0, 0 
	ADDWF       FARG_SSD1306_DrawCircleHelper_y0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_y+0 
	CALL        _SSD1306_DrawPixel+0, 0
;ssd1306oled.c,612 :: 		}
L_SSD1306_DrawCircleHelper43:
;ssd1306oled.c,613 :: 		if (cornername & 0x2) {
	BTFSS       FARG_SSD1306_DrawCircleHelper_cornername+0, 1 
	GOTO        L_SSD1306_DrawCircleHelper44
;ssd1306oled.c,614 :: 		SSD1306_DrawPixel(x0 + x, y0 - y);
	MOVF        SSD1306_DrawCircleHelper_x_L0+0, 0 
	ADDWF       FARG_SSD1306_DrawCircleHelper_x0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_x+0 
	MOVF        SSD1306_DrawCircleHelper_y_L0+0, 0 
	SUBWF       FARG_SSD1306_DrawCircleHelper_y0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_y+0 
	CALL        _SSD1306_DrawPixel+0, 0
;ssd1306oled.c,615 :: 		SSD1306_DrawPixel(x0 + y, y0 - x);
	MOVF        SSD1306_DrawCircleHelper_y_L0+0, 0 
	ADDWF       FARG_SSD1306_DrawCircleHelper_x0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_x+0 
	MOVF        SSD1306_DrawCircleHelper_x_L0+0, 0 
	SUBWF       FARG_SSD1306_DrawCircleHelper_y0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_y+0 
	CALL        _SSD1306_DrawPixel+0, 0
;ssd1306oled.c,616 :: 		}
L_SSD1306_DrawCircleHelper44:
;ssd1306oled.c,617 :: 		if (cornername & 0x8) {
	BTFSS       FARG_SSD1306_DrawCircleHelper_cornername+0, 3 
	GOTO        L_SSD1306_DrawCircleHelper45
;ssd1306oled.c,618 :: 		SSD1306_DrawPixel(x0 - y, y0 + x);
	MOVF        SSD1306_DrawCircleHelper_y_L0+0, 0 
	SUBWF       FARG_SSD1306_DrawCircleHelper_x0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_x+0 
	MOVF        SSD1306_DrawCircleHelper_x_L0+0, 0 
	ADDWF       FARG_SSD1306_DrawCircleHelper_y0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_y+0 
	CALL        _SSD1306_DrawPixel+0, 0
;ssd1306oled.c,619 :: 		SSD1306_DrawPixel(x0 - x, y0 + y);
	MOVF        SSD1306_DrawCircleHelper_x_L0+0, 0 
	SUBWF       FARG_SSD1306_DrawCircleHelper_x0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_x+0 
	MOVF        SSD1306_DrawCircleHelper_y_L0+0, 0 
	ADDWF       FARG_SSD1306_DrawCircleHelper_y0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_y+0 
	CALL        _SSD1306_DrawPixel+0, 0
;ssd1306oled.c,620 :: 		}
L_SSD1306_DrawCircleHelper45:
;ssd1306oled.c,621 :: 		if (cornername & 0x1) {
	BTFSS       FARG_SSD1306_DrawCircleHelper_cornername+0, 0 
	GOTO        L_SSD1306_DrawCircleHelper46
;ssd1306oled.c,622 :: 		SSD1306_DrawPixel(x0 - y, y0 - x);
	MOVF        SSD1306_DrawCircleHelper_y_L0+0, 0 
	SUBWF       FARG_SSD1306_DrawCircleHelper_x0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_x+0 
	MOVF        SSD1306_DrawCircleHelper_x_L0+0, 0 
	SUBWF       FARG_SSD1306_DrawCircleHelper_y0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_y+0 
	CALL        _SSD1306_DrawPixel+0, 0
;ssd1306oled.c,623 :: 		SSD1306_DrawPixel(x0 - x, y0 - y);
	MOVF        SSD1306_DrawCircleHelper_x_L0+0, 0 
	SUBWF       FARG_SSD1306_DrawCircleHelper_x0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_x+0 
	MOVF        SSD1306_DrawCircleHelper_y_L0+0, 0 
	SUBWF       FARG_SSD1306_DrawCircleHelper_y0+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_y+0 
	CALL        _SSD1306_DrawPixel+0, 0
;ssd1306oled.c,624 :: 		}
L_SSD1306_DrawCircleHelper46:
;ssd1306oled.c,625 :: 		}
	GOTO        L_SSD1306_DrawCircleHelper40
L_SSD1306_DrawCircleHelper41:
;ssd1306oled.c,627 :: 		}
L_end_SSD1306_DrawCircleHelper:
	RETURN      0
; end of _SSD1306_DrawCircleHelper

_SSD1306_FillCircle:

;ssd1306oled.c,629 :: 		void SSD1306_FillCircle(int16_t x0, int16_t y0, int16_t r) {
;ssd1306oled.c,630 :: 		SSD1306_DrawFastVLine(x0, y0 - r, 2 * r + 1);
	MOVF        FARG_SSD1306_FillCircle_x0+0, 0 
	MOVWF       FARG_SSD1306_DrawFastVLine_x+0 
	MOVF        FARG_SSD1306_FillCircle_r+0, 0 
	SUBWF       FARG_SSD1306_FillCircle_y0+0, 0 
	MOVWF       FARG_SSD1306_DrawFastVLine_y+0 
	MOVF        FARG_SSD1306_FillCircle_r+0, 0 
	MOVWF       FARG_SSD1306_DrawFastVLine_h+0 
	RLCF        FARG_SSD1306_DrawFastVLine_h+0, 1 
	BCF         FARG_SSD1306_DrawFastVLine_h+0, 0 
	INCF        FARG_SSD1306_DrawFastVLine_h+0, 1 
	CALL        _SSD1306_DrawFastVLine+0, 0
;ssd1306oled.c,631 :: 		SSD1306_FillCircleHelper(x0, y0, r, 3, 0);
	MOVF        FARG_SSD1306_FillCircle_x0+0, 0 
	MOVWF       FARG_SSD1306_FillCircleHelper_x0+0 
	MOVF        FARG_SSD1306_FillCircle_x0+1, 0 
	MOVWF       FARG_SSD1306_FillCircleHelper_x0+1 
	MOVF        FARG_SSD1306_FillCircle_y0+0, 0 
	MOVWF       FARG_SSD1306_FillCircleHelper_y0+0 
	MOVF        FARG_SSD1306_FillCircle_y0+1, 0 
	MOVWF       FARG_SSD1306_FillCircleHelper_y0+1 
	MOVF        FARG_SSD1306_FillCircle_r+0, 0 
	MOVWF       FARG_SSD1306_FillCircleHelper_r+0 
	MOVF        FARG_SSD1306_FillCircle_r+1, 0 
	MOVWF       FARG_SSD1306_FillCircleHelper_r+1 
	MOVLW       3
	MOVWF       FARG_SSD1306_FillCircleHelper_cornername+0 
	CLRF        FARG_SSD1306_FillCircleHelper_delta+0 
	CLRF        FARG_SSD1306_FillCircleHelper_delta+1 
	CALL        _SSD1306_FillCircleHelper+0, 0
;ssd1306oled.c,632 :: 		}
L_end_SSD1306_FillCircle:
	RETURN      0
; end of _SSD1306_FillCircle

_SSD1306_FillCircleHelper:

;ssd1306oled.c,635 :: 		void SSD1306_FillCircleHelper(int16_t x0, int16_t y0, int16_t r, uint8_t cornername, int16_t delta) {
;ssd1306oled.c,636 :: 		int16_t f     = 1 - r;
	MOVF        FARG_SSD1306_FillCircleHelper_r+0, 0 
	SUBLW       1
	MOVWF       SSD1306_FillCircleHelper_f_L0+0 
	MOVF        FARG_SSD1306_FillCircleHelper_r+1, 0 
	MOVWF       SSD1306_FillCircleHelper_f_L0+1 
	MOVLW       0
	SUBFWB      SSD1306_FillCircleHelper_f_L0+1, 1 
;ssd1306oled.c,637 :: 		int16_t ddF_x = 1;
	MOVLW       1
	MOVWF       SSD1306_FillCircleHelper_ddF_x_L0+0 
	MOVLW       0
	MOVWF       SSD1306_FillCircleHelper_ddF_x_L0+1 
;ssd1306oled.c,638 :: 		int16_t ddF_y = -2 * r;
	MOVLW       254
	MOVWF       R0 
	MOVLW       255
	MOVWF       R1 
	MOVF        FARG_SSD1306_FillCircleHelper_r+0, 0 
	MOVWF       R4 
	MOVF        FARG_SSD1306_FillCircleHelper_r+1, 0 
	MOVWF       R5 
	CALL        _Mul_16X16_U+0, 0
	MOVF        R0, 0 
	MOVWF       SSD1306_FillCircleHelper_ddF_y_L0+0 
	MOVF        R1, 0 
	MOVWF       SSD1306_FillCircleHelper_ddF_y_L0+1 
;ssd1306oled.c,639 :: 		int16_t x     = 0;
	CLRF        SSD1306_FillCircleHelper_x_L0+0 
	CLRF        SSD1306_FillCircleHelper_x_L0+1 
;ssd1306oled.c,640 :: 		int16_t y     = r;
	MOVF        FARG_SSD1306_FillCircleHelper_r+0, 0 
	MOVWF       SSD1306_FillCircleHelper_y_L0+0 
	MOVF        FARG_SSD1306_FillCircleHelper_r+1, 0 
	MOVWF       SSD1306_FillCircleHelper_y_L0+1 
;ssd1306oled.c,642 :: 		while (x < y) {
L_SSD1306_FillCircleHelper47:
	MOVLW       128
	XORWF       SSD1306_FillCircleHelper_x_L0+1, 0 
	MOVWF       R0 
	MOVLW       128
	XORWF       SSD1306_FillCircleHelper_y_L0+1, 0 
	SUBWF       R0, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_FillCircleHelper225
	MOVF        SSD1306_FillCircleHelper_y_L0+0, 0 
	SUBWF       SSD1306_FillCircleHelper_x_L0+0, 0 
L__SSD1306_FillCircleHelper225:
	BTFSC       STATUS+0, 0 
	GOTO        L_SSD1306_FillCircleHelper48
;ssd1306oled.c,643 :: 		if (f >= 0) {
	MOVLW       128
	XORWF       SSD1306_FillCircleHelper_f_L0+1, 0 
	MOVWF       R0 
	MOVLW       128
	SUBWF       R0, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_FillCircleHelper226
	MOVLW       0
	SUBWF       SSD1306_FillCircleHelper_f_L0+0, 0 
L__SSD1306_FillCircleHelper226:
	BTFSS       STATUS+0, 0 
	GOTO        L_SSD1306_FillCircleHelper49
;ssd1306oled.c,644 :: 		y--;
	MOVLW       1
	SUBWF       SSD1306_FillCircleHelper_y_L0+0, 1 
	MOVLW       0
	SUBWFB      SSD1306_FillCircleHelper_y_L0+1, 1 
;ssd1306oled.c,645 :: 		ddF_y += 2;
	MOVLW       2
	ADDWF       SSD1306_FillCircleHelper_ddF_y_L0+0, 0 
	MOVWF       R0 
	MOVLW       0
	ADDWFC      SSD1306_FillCircleHelper_ddF_y_L0+1, 0 
	MOVWF       R1 
	MOVF        R0, 0 
	MOVWF       SSD1306_FillCircleHelper_ddF_y_L0+0 
	MOVF        R1, 0 
	MOVWF       SSD1306_FillCircleHelper_ddF_y_L0+1 
;ssd1306oled.c,646 :: 		f     += ddF_y;
	MOVF        R0, 0 
	ADDWF       SSD1306_FillCircleHelper_f_L0+0, 1 
	MOVF        R1, 0 
	ADDWFC      SSD1306_FillCircleHelper_f_L0+1, 1 
;ssd1306oled.c,647 :: 		}
L_SSD1306_FillCircleHelper49:
;ssd1306oled.c,648 :: 		x++;
	INFSNZ      SSD1306_FillCircleHelper_x_L0+0, 1 
	INCF        SSD1306_FillCircleHelper_x_L0+1, 1 
;ssd1306oled.c,649 :: 		ddF_x += 2;
	MOVLW       2
	ADDWF       SSD1306_FillCircleHelper_ddF_x_L0+0, 0 
	MOVWF       R0 
	MOVLW       0
	ADDWFC      SSD1306_FillCircleHelper_ddF_x_L0+1, 0 
	MOVWF       R1 
	MOVF        R0, 0 
	MOVWF       SSD1306_FillCircleHelper_ddF_x_L0+0 
	MOVF        R1, 0 
	MOVWF       SSD1306_FillCircleHelper_ddF_x_L0+1 
;ssd1306oled.c,650 :: 		f     += ddF_x;
	MOVF        R0, 0 
	ADDWF       SSD1306_FillCircleHelper_f_L0+0, 1 
	MOVF        R1, 0 
	ADDWFC      SSD1306_FillCircleHelper_f_L0+1, 1 
;ssd1306oled.c,652 :: 		if (cornername & 0x01) {
	BTFSS       FARG_SSD1306_FillCircleHelper_cornername+0, 0 
	GOTO        L_SSD1306_FillCircleHelper50
;ssd1306oled.c,653 :: 		SSD1306_DrawFastVLine(x0 + x, y0 - y, 2 * y + 1 + delta);
	MOVF        SSD1306_FillCircleHelper_x_L0+0, 0 
	ADDWF       FARG_SSD1306_FillCircleHelper_x0+0, 0 
	MOVWF       FARG_SSD1306_DrawFastVLine_x+0 
	MOVF        SSD1306_FillCircleHelper_y_L0+0, 0 
	SUBWF       FARG_SSD1306_FillCircleHelper_y0+0, 0 
	MOVWF       FARG_SSD1306_DrawFastVLine_y+0 
	MOVF        SSD1306_FillCircleHelper_y_L0+0, 0 
	MOVWF       FARG_SSD1306_DrawFastVLine_h+0 
	RLCF        FARG_SSD1306_DrawFastVLine_h+0, 1 
	BCF         FARG_SSD1306_DrawFastVLine_h+0, 0 
	INCF        FARG_SSD1306_DrawFastVLine_h+0, 1 
	MOVF        FARG_SSD1306_FillCircleHelper_delta+0, 0 
	ADDWF       FARG_SSD1306_DrawFastVLine_h+0, 1 
	CALL        _SSD1306_DrawFastVLine+0, 0
;ssd1306oled.c,654 :: 		SSD1306_DrawFastVLine(x0 + y, y0 - x, 2 * x + 1 + delta);
	MOVF        SSD1306_FillCircleHelper_y_L0+0, 0 
	ADDWF       FARG_SSD1306_FillCircleHelper_x0+0, 0 
	MOVWF       FARG_SSD1306_DrawFastVLine_x+0 
	MOVF        SSD1306_FillCircleHelper_x_L0+0, 0 
	SUBWF       FARG_SSD1306_FillCircleHelper_y0+0, 0 
	MOVWF       FARG_SSD1306_DrawFastVLine_y+0 
	MOVF        SSD1306_FillCircleHelper_x_L0+0, 0 
	MOVWF       FARG_SSD1306_DrawFastVLine_h+0 
	RLCF        FARG_SSD1306_DrawFastVLine_h+0, 1 
	BCF         FARG_SSD1306_DrawFastVLine_h+0, 0 
	INCF        FARG_SSD1306_DrawFastVLine_h+0, 1 
	MOVF        FARG_SSD1306_FillCircleHelper_delta+0, 0 
	ADDWF       FARG_SSD1306_DrawFastVLine_h+0, 1 
	CALL        _SSD1306_DrawFastVLine+0, 0
;ssd1306oled.c,655 :: 		}
L_SSD1306_FillCircleHelper50:
;ssd1306oled.c,656 :: 		if (cornername & 0x02) {
	BTFSS       FARG_SSD1306_FillCircleHelper_cornername+0, 1 
	GOTO        L_SSD1306_FillCircleHelper51
;ssd1306oled.c,657 :: 		SSD1306_DrawFastVLine(x0 - x, y0 - y, 2 * y + 1 + delta);
	MOVF        SSD1306_FillCircleHelper_x_L0+0, 0 
	SUBWF       FARG_SSD1306_FillCircleHelper_x0+0, 0 
	MOVWF       FARG_SSD1306_DrawFastVLine_x+0 
	MOVF        SSD1306_FillCircleHelper_y_L0+0, 0 
	SUBWF       FARG_SSD1306_FillCircleHelper_y0+0, 0 
	MOVWF       FARG_SSD1306_DrawFastVLine_y+0 
	MOVF        SSD1306_FillCircleHelper_y_L0+0, 0 
	MOVWF       FARG_SSD1306_DrawFastVLine_h+0 
	RLCF        FARG_SSD1306_DrawFastVLine_h+0, 1 
	BCF         FARG_SSD1306_DrawFastVLine_h+0, 0 
	INCF        FARG_SSD1306_DrawFastVLine_h+0, 1 
	MOVF        FARG_SSD1306_FillCircleHelper_delta+0, 0 
	ADDWF       FARG_SSD1306_DrawFastVLine_h+0, 1 
	CALL        _SSD1306_DrawFastVLine+0, 0
;ssd1306oled.c,658 :: 		SSD1306_DrawFastVLine(x0 - y, y0 - x, 2 * x + 1 + delta);
	MOVF        SSD1306_FillCircleHelper_y_L0+0, 0 
	SUBWF       FARG_SSD1306_FillCircleHelper_x0+0, 0 
	MOVWF       FARG_SSD1306_DrawFastVLine_x+0 
	MOVF        SSD1306_FillCircleHelper_x_L0+0, 0 
	SUBWF       FARG_SSD1306_FillCircleHelper_y0+0, 0 
	MOVWF       FARG_SSD1306_DrawFastVLine_y+0 
	MOVF        SSD1306_FillCircleHelper_x_L0+0, 0 
	MOVWF       FARG_SSD1306_DrawFastVLine_h+0 
	RLCF        FARG_SSD1306_DrawFastVLine_h+0, 1 
	BCF         FARG_SSD1306_DrawFastVLine_h+0, 0 
	INCF        FARG_SSD1306_DrawFastVLine_h+0, 1 
	MOVF        FARG_SSD1306_FillCircleHelper_delta+0, 0 
	ADDWF       FARG_SSD1306_DrawFastVLine_h+0, 1 
	CALL        _SSD1306_DrawFastVLine+0, 0
;ssd1306oled.c,659 :: 		}
L_SSD1306_FillCircleHelper51:
;ssd1306oled.c,660 :: 		}
	GOTO        L_SSD1306_FillCircleHelper47
L_SSD1306_FillCircleHelper48:
;ssd1306oled.c,662 :: 		}
L_end_SSD1306_FillCircleHelper:
	RETURN      0
; end of _SSD1306_FillCircleHelper

_SSD1306_DrawRect:

;ssd1306oled.c,665 :: 		void SSD1306_DrawRect(uint8_t x, uint8_t y, uint8_t w, uint8_t h) {
;ssd1306oled.c,666 :: 		SSD1306_DrawFastHLine(x, y, w);
	MOVF        FARG_SSD1306_DrawRect_x+0, 0 
	MOVWF       FARG_SSD1306_DrawFastHLine_x+0 
	MOVF        FARG_SSD1306_DrawRect_y+0, 0 
	MOVWF       FARG_SSD1306_DrawFastHLine_y+0 
	MOVF        FARG_SSD1306_DrawRect_w+0, 0 
	MOVWF       FARG_SSD1306_DrawFastHLine_w+0 
	CALL        _SSD1306_DrawFastHLine+0, 0
;ssd1306oled.c,667 :: 		SSD1306_DrawFastHLine(x, y + h - 1, w);
	MOVF        FARG_SSD1306_DrawRect_x+0, 0 
	MOVWF       FARG_SSD1306_DrawFastHLine_x+0 
	MOVF        FARG_SSD1306_DrawRect_h+0, 0 
	ADDWF       FARG_SSD1306_DrawRect_y+0, 0 
	MOVWF       FARG_SSD1306_DrawFastHLine_y+0 
	DECF        FARG_SSD1306_DrawFastHLine_y+0, 1 
	MOVF        FARG_SSD1306_DrawRect_w+0, 0 
	MOVWF       FARG_SSD1306_DrawFastHLine_w+0 
	CALL        _SSD1306_DrawFastHLine+0, 0
;ssd1306oled.c,668 :: 		SSD1306_DrawFastVLine(x, y, h);
	MOVF        FARG_SSD1306_DrawRect_x+0, 0 
	MOVWF       FARG_SSD1306_DrawFastVLine_x+0 
	MOVF        FARG_SSD1306_DrawRect_y+0, 0 
	MOVWF       FARG_SSD1306_DrawFastVLine_y+0 
	MOVF        FARG_SSD1306_DrawRect_h+0, 0 
	MOVWF       FARG_SSD1306_DrawFastVLine_h+0 
	CALL        _SSD1306_DrawFastVLine+0, 0
;ssd1306oled.c,669 :: 		SSD1306_DrawFastVLine(x + w - 1, y, h);
	MOVF        FARG_SSD1306_DrawRect_w+0, 0 
	ADDWF       FARG_SSD1306_DrawRect_x+0, 0 
	MOVWF       FARG_SSD1306_DrawFastVLine_x+0 
	DECF        FARG_SSD1306_DrawFastVLine_x+0, 1 
	MOVF        FARG_SSD1306_DrawRect_y+0, 0 
	MOVWF       FARG_SSD1306_DrawFastVLine_y+0 
	MOVF        FARG_SSD1306_DrawRect_h+0, 0 
	MOVWF       FARG_SSD1306_DrawFastVLine_h+0 
	CALL        _SSD1306_DrawFastVLine+0, 0
;ssd1306oled.c,670 :: 		}
L_end_SSD1306_DrawRect:
	RETURN      0
; end of _SSD1306_DrawRect

_SSD1306_DrawRoundRect:

;ssd1306oled.c,673 :: 		void SSD1306_DrawRoundRect(uint8_t x, uint8_t y, uint8_t w, uint8_t h, uint8_t r) {
;ssd1306oled.c,675 :: 		SSD1306_DrawFastHLine(x + r, y, w - 2 * r); // Top
	MOVF        FARG_SSD1306_DrawRoundRect_r+0, 0 
	ADDWF       FARG_SSD1306_DrawRoundRect_x+0, 0 
	MOVWF       FARG_SSD1306_DrawFastHLine_x+0 
	MOVF        FARG_SSD1306_DrawRoundRect_y+0, 0 
	MOVWF       FARG_SSD1306_DrawFastHLine_y+0 
	MOVF        FARG_SSD1306_DrawRoundRect_r+0, 0 
	MOVWF       R0 
	RLCF        R0, 1 
	BCF         R0, 0 
	MOVF        R0, 0 
	SUBWF       FARG_SSD1306_DrawRoundRect_w+0, 0 
	MOVWF       FARG_SSD1306_DrawFastHLine_w+0 
	CALL        _SSD1306_DrawFastHLine+0, 0
;ssd1306oled.c,676 :: 		SSD1306_DrawFastHLine(x + r, y + h - 1, w - 2 * r); // Bottom
	MOVF        FARG_SSD1306_DrawRoundRect_r+0, 0 
	ADDWF       FARG_SSD1306_DrawRoundRect_x+0, 0 
	MOVWF       FARG_SSD1306_DrawFastHLine_x+0 
	MOVF        FARG_SSD1306_DrawRoundRect_h+0, 0 
	ADDWF       FARG_SSD1306_DrawRoundRect_y+0, 0 
	MOVWF       FARG_SSD1306_DrawFastHLine_y+0 
	DECF        FARG_SSD1306_DrawFastHLine_y+0, 1 
	MOVF        FARG_SSD1306_DrawRoundRect_r+0, 0 
	MOVWF       R0 
	RLCF        R0, 1 
	BCF         R0, 0 
	MOVF        R0, 0 
	SUBWF       FARG_SSD1306_DrawRoundRect_w+0, 0 
	MOVWF       FARG_SSD1306_DrawFastHLine_w+0 
	CALL        _SSD1306_DrawFastHLine+0, 0
;ssd1306oled.c,677 :: 		SSD1306_DrawFastVLine(x, y + r, h - 2 * r); // Left
	MOVF        FARG_SSD1306_DrawRoundRect_x+0, 0 
	MOVWF       FARG_SSD1306_DrawFastVLine_x+0 
	MOVF        FARG_SSD1306_DrawRoundRect_r+0, 0 
	ADDWF       FARG_SSD1306_DrawRoundRect_y+0, 0 
	MOVWF       FARG_SSD1306_DrawFastVLine_y+0 
	MOVF        FARG_SSD1306_DrawRoundRect_r+0, 0 
	MOVWF       R0 
	RLCF        R0, 1 
	BCF         R0, 0 
	MOVF        R0, 0 
	SUBWF       FARG_SSD1306_DrawRoundRect_h+0, 0 
	MOVWF       FARG_SSD1306_DrawFastVLine_h+0 
	CALL        _SSD1306_DrawFastVLine+0, 0
;ssd1306oled.c,678 :: 		SSD1306_DrawFastVLine(x + w - 1, y + r, h - 2 * r); // Right
	MOVF        FARG_SSD1306_DrawRoundRect_w+0, 0 
	ADDWF       FARG_SSD1306_DrawRoundRect_x+0, 0 
	MOVWF       FARG_SSD1306_DrawFastVLine_x+0 
	DECF        FARG_SSD1306_DrawFastVLine_x+0, 1 
	MOVF        FARG_SSD1306_DrawRoundRect_r+0, 0 
	ADDWF       FARG_SSD1306_DrawRoundRect_y+0, 0 
	MOVWF       FARG_SSD1306_DrawFastVLine_y+0 
	MOVF        FARG_SSD1306_DrawRoundRect_r+0, 0 
	MOVWF       R0 
	RLCF        R0, 1 
	BCF         R0, 0 
	MOVF        R0, 0 
	SUBWF       FARG_SSD1306_DrawRoundRect_h+0, 0 
	MOVWF       FARG_SSD1306_DrawFastVLine_h+0 
	CALL        _SSD1306_DrawFastVLine+0, 0
;ssd1306oled.c,680 :: 		SSD1306_DrawCircleHelper(x + r, y + r, r, 1);
	MOVF        FARG_SSD1306_DrawRoundRect_r+0, 0 
	ADDWF       FARG_SSD1306_DrawRoundRect_x+0, 0 
	MOVWF       FARG_SSD1306_DrawCircleHelper_x0+0 
	CLRF        FARG_SSD1306_DrawCircleHelper_x0+1 
	MOVLW       0
	ADDWFC      FARG_SSD1306_DrawCircleHelper_x0+1, 1 
	MOVF        FARG_SSD1306_DrawRoundRect_r+0, 0 
	ADDWF       FARG_SSD1306_DrawRoundRect_y+0, 0 
	MOVWF       FARG_SSD1306_DrawCircleHelper_y0+0 
	CLRF        FARG_SSD1306_DrawCircleHelper_y0+1 
	MOVLW       0
	ADDWFC      FARG_SSD1306_DrawCircleHelper_y0+1, 1 
	MOVF        FARG_SSD1306_DrawRoundRect_r+0, 0 
	MOVWF       FARG_SSD1306_DrawCircleHelper_r+0 
	MOVLW       0
	MOVWF       FARG_SSD1306_DrawCircleHelper_r+1 
	MOVLW       1
	MOVWF       FARG_SSD1306_DrawCircleHelper_cornername+0 
	CALL        _SSD1306_DrawCircleHelper+0, 0
;ssd1306oled.c,681 :: 		SSD1306_DrawCircleHelper(x + w - r - 1, y + r, r, 2);
	MOVF        FARG_SSD1306_DrawRoundRect_w+0, 0 
	ADDWF       FARG_SSD1306_DrawRoundRect_x+0, 0 
	MOVWF       FARG_SSD1306_DrawCircleHelper_x0+0 
	CLRF        FARG_SSD1306_DrawCircleHelper_x0+1 
	MOVLW       0
	ADDWFC      FARG_SSD1306_DrawCircleHelper_x0+1, 1 
	MOVF        FARG_SSD1306_DrawRoundRect_r+0, 0 
	SUBWF       FARG_SSD1306_DrawCircleHelper_x0+0, 1 
	MOVLW       0
	SUBWFB      FARG_SSD1306_DrawCircleHelper_x0+1, 1 
	MOVLW       1
	SUBWF       FARG_SSD1306_DrawCircleHelper_x0+0, 1 
	MOVLW       0
	SUBWFB      FARG_SSD1306_DrawCircleHelper_x0+1, 1 
	MOVF        FARG_SSD1306_DrawRoundRect_r+0, 0 
	ADDWF       FARG_SSD1306_DrawRoundRect_y+0, 0 
	MOVWF       FARG_SSD1306_DrawCircleHelper_y0+0 
	CLRF        FARG_SSD1306_DrawCircleHelper_y0+1 
	MOVLW       0
	ADDWFC      FARG_SSD1306_DrawCircleHelper_y0+1, 1 
	MOVF        FARG_SSD1306_DrawRoundRect_r+0, 0 
	MOVWF       FARG_SSD1306_DrawCircleHelper_r+0 
	MOVLW       0
	MOVWF       FARG_SSD1306_DrawCircleHelper_r+1 
	MOVLW       2
	MOVWF       FARG_SSD1306_DrawCircleHelper_cornername+0 
	CALL        _SSD1306_DrawCircleHelper+0, 0
;ssd1306oled.c,682 :: 		SSD1306_DrawCircleHelper(x + w - r - 1, y + h - r - 1, r, 4);
	MOVF        FARG_SSD1306_DrawRoundRect_w+0, 0 
	ADDWF       FARG_SSD1306_DrawRoundRect_x+0, 0 
	MOVWF       FARG_SSD1306_DrawCircleHelper_x0+0 
	CLRF        FARG_SSD1306_DrawCircleHelper_x0+1 
	MOVLW       0
	ADDWFC      FARG_SSD1306_DrawCircleHelper_x0+1, 1 
	MOVF        FARG_SSD1306_DrawRoundRect_r+0, 0 
	SUBWF       FARG_SSD1306_DrawCircleHelper_x0+0, 1 
	MOVLW       0
	SUBWFB      FARG_SSD1306_DrawCircleHelper_x0+1, 1 
	MOVLW       1
	SUBWF       FARG_SSD1306_DrawCircleHelper_x0+0, 1 
	MOVLW       0
	SUBWFB      FARG_SSD1306_DrawCircleHelper_x0+1, 1 
	MOVF        FARG_SSD1306_DrawRoundRect_h+0, 0 
	ADDWF       FARG_SSD1306_DrawRoundRect_y+0, 0 
	MOVWF       FARG_SSD1306_DrawCircleHelper_y0+0 
	CLRF        FARG_SSD1306_DrawCircleHelper_y0+1 
	MOVLW       0
	ADDWFC      FARG_SSD1306_DrawCircleHelper_y0+1, 1 
	MOVF        FARG_SSD1306_DrawRoundRect_r+0, 0 
	SUBWF       FARG_SSD1306_DrawCircleHelper_y0+0, 1 
	MOVLW       0
	SUBWFB      FARG_SSD1306_DrawCircleHelper_y0+1, 1 
	MOVLW       1
	SUBWF       FARG_SSD1306_DrawCircleHelper_y0+0, 1 
	MOVLW       0
	SUBWFB      FARG_SSD1306_DrawCircleHelper_y0+1, 1 
	MOVF        FARG_SSD1306_DrawRoundRect_r+0, 0 
	MOVWF       FARG_SSD1306_DrawCircleHelper_r+0 
	MOVLW       0
	MOVWF       FARG_SSD1306_DrawCircleHelper_r+1 
	MOVLW       4
	MOVWF       FARG_SSD1306_DrawCircleHelper_cornername+0 
	CALL        _SSD1306_DrawCircleHelper+0, 0
;ssd1306oled.c,683 :: 		SSD1306_DrawCircleHelper(x + r, y + h - r - 1, r, 8);
	MOVF        FARG_SSD1306_DrawRoundRect_r+0, 0 
	ADDWF       FARG_SSD1306_DrawRoundRect_x+0, 0 
	MOVWF       FARG_SSD1306_DrawCircleHelper_x0+0 
	CLRF        FARG_SSD1306_DrawCircleHelper_x0+1 
	MOVLW       0
	ADDWFC      FARG_SSD1306_DrawCircleHelper_x0+1, 1 
	MOVF        FARG_SSD1306_DrawRoundRect_h+0, 0 
	ADDWF       FARG_SSD1306_DrawRoundRect_y+0, 0 
	MOVWF       FARG_SSD1306_DrawCircleHelper_y0+0 
	CLRF        FARG_SSD1306_DrawCircleHelper_y0+1 
	MOVLW       0
	ADDWFC      FARG_SSD1306_DrawCircleHelper_y0+1, 1 
	MOVF        FARG_SSD1306_DrawRoundRect_r+0, 0 
	SUBWF       FARG_SSD1306_DrawCircleHelper_y0+0, 1 
	MOVLW       0
	SUBWFB      FARG_SSD1306_DrawCircleHelper_y0+1, 1 
	MOVLW       1
	SUBWF       FARG_SSD1306_DrawCircleHelper_y0+0, 1 
	MOVLW       0
	SUBWFB      FARG_SSD1306_DrawCircleHelper_y0+1, 1 
	MOVF        FARG_SSD1306_DrawRoundRect_r+0, 0 
	MOVWF       FARG_SSD1306_DrawCircleHelper_r+0 
	MOVLW       0
	MOVWF       FARG_SSD1306_DrawCircleHelper_r+1 
	MOVLW       8
	MOVWF       FARG_SSD1306_DrawCircleHelper_cornername+0 
	CALL        _SSD1306_DrawCircleHelper+0, 0
;ssd1306oled.c,684 :: 		}
L_end_SSD1306_DrawRoundRect:
	RETURN      0
; end of _SSD1306_DrawRoundRect

_SSD1306_FillRoundRect:

;ssd1306oled.c,687 :: 		void SSD1306_FillRoundRect(uint8_t x, uint8_t y, uint8_t w, uint8_t h, uint8_t r) {
;ssd1306oled.c,689 :: 		SSD1306_FillRect(x + r, y, w - 2 * r, h);
	MOVF        FARG_SSD1306_FillRoundRect_r+0, 0 
	ADDWF       FARG_SSD1306_FillRoundRect_x+0, 0 
	MOVWF       FARG_SSD1306_FillRect_x+0 
	MOVF        FARG_SSD1306_FillRoundRect_y+0, 0 
	MOVWF       FARG_SSD1306_FillRect_y+0 
	MOVF        FARG_SSD1306_FillRoundRect_r+0, 0 
	MOVWF       R0 
	RLCF        R0, 1 
	BCF         R0, 0 
	MOVF        R0, 0 
	SUBWF       FARG_SSD1306_FillRoundRect_w+0, 0 
	MOVWF       FARG_SSD1306_FillRect_w+0 
	MOVF        FARG_SSD1306_FillRoundRect_h+0, 0 
	MOVWF       FARG_SSD1306_FillRect_h+0 
	CALL        _SSD1306_FillRect+0, 0
;ssd1306oled.c,691 :: 		SSD1306_FillCircleHelper(x + w - r - 1, y + r, r, 1, h - 2 * r - 1);
	MOVF        FARG_SSD1306_FillRoundRect_w+0, 0 
	ADDWF       FARG_SSD1306_FillRoundRect_x+0, 0 
	MOVWF       FARG_SSD1306_FillCircleHelper_x0+0 
	CLRF        FARG_SSD1306_FillCircleHelper_x0+1 
	MOVLW       0
	ADDWFC      FARG_SSD1306_FillCircleHelper_x0+1, 1 
	MOVF        FARG_SSD1306_FillRoundRect_r+0, 0 
	SUBWF       FARG_SSD1306_FillCircleHelper_x0+0, 1 
	MOVLW       0
	SUBWFB      FARG_SSD1306_FillCircleHelper_x0+1, 1 
	MOVLW       1
	SUBWF       FARG_SSD1306_FillCircleHelper_x0+0, 1 
	MOVLW       0
	SUBWFB      FARG_SSD1306_FillCircleHelper_x0+1, 1 
	MOVF        FARG_SSD1306_FillRoundRect_r+0, 0 
	ADDWF       FARG_SSD1306_FillRoundRect_y+0, 0 
	MOVWF       FARG_SSD1306_FillCircleHelper_y0+0 
	CLRF        FARG_SSD1306_FillCircleHelper_y0+1 
	MOVLW       0
	ADDWFC      FARG_SSD1306_FillCircleHelper_y0+1, 1 
	MOVF        FARG_SSD1306_FillRoundRect_r+0, 0 
	MOVWF       FARG_SSD1306_FillCircleHelper_r+0 
	MOVLW       0
	MOVWF       FARG_SSD1306_FillCircleHelper_r+1 
	MOVLW       1
	MOVWF       FARG_SSD1306_FillCircleHelper_cornername+0 
	MOVF        FARG_SSD1306_FillRoundRect_r+0, 0 
	MOVWF       R0 
	MOVLW       0
	MOVWF       R1 
	RLCF        R0, 1 
	RLCF        R1, 1 
	BCF         R0, 0 
	MOVF        R0, 0 
	SUBWF       FARG_SSD1306_FillRoundRect_h+0, 0 
	MOVWF       FARG_SSD1306_FillCircleHelper_delta+0 
	MOVF        R1, 0 
	MOVWF       FARG_SSD1306_FillCircleHelper_delta+1 
	MOVLW       0
	SUBFWB      FARG_SSD1306_FillCircleHelper_delta+1, 1 
	MOVLW       1
	SUBWF       FARG_SSD1306_FillCircleHelper_delta+0, 1 
	MOVLW       0
	SUBWFB      FARG_SSD1306_FillCircleHelper_delta+1, 1 
	CALL        _SSD1306_FillCircleHelper+0, 0
;ssd1306oled.c,692 :: 		SSD1306_FillCircleHelper(x + r        , y + r, r, 2, h - 2 * r - 1);
	MOVF        FARG_SSD1306_FillRoundRect_r+0, 0 
	ADDWF       FARG_SSD1306_FillRoundRect_x+0, 0 
	MOVWF       FARG_SSD1306_FillCircleHelper_x0+0 
	CLRF        FARG_SSD1306_FillCircleHelper_x0+1 
	MOVLW       0
	ADDWFC      FARG_SSD1306_FillCircleHelper_x0+1, 1 
	MOVF        FARG_SSD1306_FillRoundRect_r+0, 0 
	ADDWF       FARG_SSD1306_FillRoundRect_y+0, 0 
	MOVWF       FARG_SSD1306_FillCircleHelper_y0+0 
	CLRF        FARG_SSD1306_FillCircleHelper_y0+1 
	MOVLW       0
	ADDWFC      FARG_SSD1306_FillCircleHelper_y0+1, 1 
	MOVF        FARG_SSD1306_FillRoundRect_r+0, 0 
	MOVWF       FARG_SSD1306_FillCircleHelper_r+0 
	MOVLW       0
	MOVWF       FARG_SSD1306_FillCircleHelper_r+1 
	MOVLW       2
	MOVWF       FARG_SSD1306_FillCircleHelper_cornername+0 
	MOVF        FARG_SSD1306_FillRoundRect_r+0, 0 
	MOVWF       R0 
	MOVLW       0
	MOVWF       R1 
	RLCF        R0, 1 
	RLCF        R1, 1 
	BCF         R0, 0 
	MOVF        R0, 0 
	SUBWF       FARG_SSD1306_FillRoundRect_h+0, 0 
	MOVWF       FARG_SSD1306_FillCircleHelper_delta+0 
	MOVF        R1, 0 
	MOVWF       FARG_SSD1306_FillCircleHelper_delta+1 
	MOVLW       0
	SUBFWB      FARG_SSD1306_FillCircleHelper_delta+1, 1 
	MOVLW       1
	SUBWF       FARG_SSD1306_FillCircleHelper_delta+0, 1 
	MOVLW       0
	SUBWFB      FARG_SSD1306_FillCircleHelper_delta+1, 1 
	CALL        _SSD1306_FillCircleHelper+0, 0
;ssd1306oled.c,693 :: 		}
L_end_SSD1306_FillRoundRect:
	RETURN      0
; end of _SSD1306_FillRoundRect

_SSD1306_DrawTriangle:

;ssd1306oled.c,696 :: 		void SSD1306_DrawTriangle(uint8_t x0, uint8_t y0, uint8_t x1, uint8_t y1, uint8_t x2, uint8_t y2) {
;ssd1306oled.c,697 :: 		SSD1306_DrawLine(x0, y0, x1, y1);
	MOVF        FARG_SSD1306_DrawTriangle_x0+0, 0 
	MOVWF       FARG_SSD1306_DrawLine_x0+0 
	MOVLW       0
	MOVWF       FARG_SSD1306_DrawLine_x0+1 
	MOVF        FARG_SSD1306_DrawTriangle_y0+0, 0 
	MOVWF       FARG_SSD1306_DrawLine_y0+0 
	MOVLW       0
	MOVWF       FARG_SSD1306_DrawLine_y0+1 
	MOVF        FARG_SSD1306_DrawTriangle_x1+0, 0 
	MOVWF       FARG_SSD1306_DrawLine_x1+0 
	MOVLW       0
	MOVWF       FARG_SSD1306_DrawLine_x1+1 
	MOVF        FARG_SSD1306_DrawTriangle_y1+0, 0 
	MOVWF       FARG_SSD1306_DrawLine_y1+0 
	MOVLW       0
	MOVWF       FARG_SSD1306_DrawLine_y1+1 
	CALL        _SSD1306_DrawLine+0, 0
;ssd1306oled.c,698 :: 		SSD1306_DrawLine(x1, y1, x2, y2);
	MOVF        FARG_SSD1306_DrawTriangle_x1+0, 0 
	MOVWF       FARG_SSD1306_DrawLine_x0+0 
	MOVLW       0
	MOVWF       FARG_SSD1306_DrawLine_x0+1 
	MOVF        FARG_SSD1306_DrawTriangle_y1+0, 0 
	MOVWF       FARG_SSD1306_DrawLine_y0+0 
	MOVLW       0
	MOVWF       FARG_SSD1306_DrawLine_y0+1 
	MOVF        FARG_SSD1306_DrawTriangle_x2+0, 0 
	MOVWF       FARG_SSD1306_DrawLine_x1+0 
	MOVLW       0
	MOVWF       FARG_SSD1306_DrawLine_x1+1 
	MOVF        FARG_SSD1306_DrawTriangle_y2+0, 0 
	MOVWF       FARG_SSD1306_DrawLine_y1+0 
	MOVLW       0
	MOVWF       FARG_SSD1306_DrawLine_y1+1 
	CALL        _SSD1306_DrawLine+0, 0
;ssd1306oled.c,699 :: 		SSD1306_DrawLine(x2, y2, x0, y0);
	MOVF        FARG_SSD1306_DrawTriangle_x2+0, 0 
	MOVWF       FARG_SSD1306_DrawLine_x0+0 
	MOVLW       0
	MOVWF       FARG_SSD1306_DrawLine_x0+1 
	MOVF        FARG_SSD1306_DrawTriangle_y2+0, 0 
	MOVWF       FARG_SSD1306_DrawLine_y0+0 
	MOVLW       0
	MOVWF       FARG_SSD1306_DrawLine_y0+1 
	MOVF        FARG_SSD1306_DrawTriangle_x0+0, 0 
	MOVWF       FARG_SSD1306_DrawLine_x1+0 
	MOVLW       0
	MOVWF       FARG_SSD1306_DrawLine_x1+1 
	MOVF        FARG_SSD1306_DrawTriangle_y0+0, 0 
	MOVWF       FARG_SSD1306_DrawLine_y1+0 
	MOVLW       0
	MOVWF       FARG_SSD1306_DrawLine_y1+1 
	CALL        _SSD1306_DrawLine+0, 0
;ssd1306oled.c,700 :: 		}
L_end_SSD1306_DrawTriangle:
	RETURN      0
; end of _SSD1306_DrawTriangle

_SSD1306_FillTriangle:

;ssd1306oled.c,703 :: 		void SSD1306_FillTriangle(int16_t x0, int16_t y0, int16_t x1, int16_t y1, int16_t x2, int16_t y2) {
;ssd1306oled.c,705 :: 		dx01 = x1 - x0,
	MOVF        FARG_SSD1306_FillTriangle_x0+0, 0 
	SUBWF       FARG_SSD1306_FillTriangle_x1+0, 0 
	MOVWF       SSD1306_FillTriangle_dx01_L0+0 
	MOVF        FARG_SSD1306_FillTriangle_x0+1, 0 
	SUBWFB      FARG_SSD1306_FillTriangle_x1+1, 0 
	MOVWF       SSD1306_FillTriangle_dx01_L0+1 
;ssd1306oled.c,706 :: 		dy01 = y1 - y0,
	MOVF        FARG_SSD1306_FillTriangle_y0+0, 0 
	SUBWF       FARG_SSD1306_FillTriangle_y1+0, 0 
	MOVWF       SSD1306_FillTriangle_dy01_L0+0 
	MOVF        FARG_SSD1306_FillTriangle_y0+1, 0 
	SUBWFB      FARG_SSD1306_FillTriangle_y1+1, 0 
	MOVWF       SSD1306_FillTriangle_dy01_L0+1 
;ssd1306oled.c,707 :: 		dx02 = x2 - x0,
	MOVF        FARG_SSD1306_FillTriangle_x0+0, 0 
	SUBWF       FARG_SSD1306_FillTriangle_x2+0, 0 
	MOVWF       SSD1306_FillTriangle_dx02_L0+0 
	MOVF        FARG_SSD1306_FillTriangle_x0+1, 0 
	SUBWFB      FARG_SSD1306_FillTriangle_x2+1, 0 
	MOVWF       SSD1306_FillTriangle_dx02_L0+1 
;ssd1306oled.c,708 :: 		dy02 = y2 - y0,
	MOVF        FARG_SSD1306_FillTriangle_y0+0, 0 
	SUBWF       FARG_SSD1306_FillTriangle_y2+0, 0 
	MOVWF       SSD1306_FillTriangle_dy02_L0+0 
	MOVF        FARG_SSD1306_FillTriangle_y0+1, 0 
	SUBWFB      FARG_SSD1306_FillTriangle_y2+1, 0 
	MOVWF       SSD1306_FillTriangle_dy02_L0+1 
;ssd1306oled.c,709 :: 		dx12 = x2 - x1,
	MOVF        FARG_SSD1306_FillTriangle_x1+0, 0 
	SUBWF       FARG_SSD1306_FillTriangle_x2+0, 0 
	MOVWF       SSD1306_FillTriangle_dx12_L0+0 
	MOVF        FARG_SSD1306_FillTriangle_x1+1, 0 
	SUBWFB      FARG_SSD1306_FillTriangle_x2+1, 0 
	MOVWF       SSD1306_FillTriangle_dx12_L0+1 
;ssd1306oled.c,710 :: 		dy12 = y2 - y1;
	MOVF        FARG_SSD1306_FillTriangle_y1+0, 0 
	SUBWF       FARG_SSD1306_FillTriangle_y2+0, 0 
	MOVWF       SSD1306_FillTriangle_dy12_L0+0 
	MOVF        FARG_SSD1306_FillTriangle_y1+1, 0 
	SUBWFB      FARG_SSD1306_FillTriangle_y2+1, 0 
	MOVWF       SSD1306_FillTriangle_dy12_L0+1 
;ssd1306oled.c,711 :: 		int32_t  sa   = 0, sb   = 0;
	CLRF        SSD1306_FillTriangle_sa_L0+0 
	CLRF        SSD1306_FillTriangle_sa_L0+1 
	CLRF        SSD1306_FillTriangle_sa_L0+2 
	CLRF        SSD1306_FillTriangle_sa_L0+3 
	CLRF        SSD1306_FillTriangle_sb_L0+0 
	CLRF        SSD1306_FillTriangle_sb_L0+1 
	CLRF        SSD1306_FillTriangle_sb_L0+2 
	CLRF        SSD1306_FillTriangle_sb_L0+3 
;ssd1306oled.c,713 :: 		if (y0 > y1) {
	MOVLW       128
	XORWF       FARG_SSD1306_FillTriangle_y1+1, 0 
	MOVWF       R0 
	MOVLW       128
	XORWF       FARG_SSD1306_FillTriangle_y0+1, 0 
	SUBWF       R0, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_FillTriangle232
	MOVF        FARG_SSD1306_FillTriangle_y0+0, 0 
	SUBWF       FARG_SSD1306_FillTriangle_y1+0, 0 
L__SSD1306_FillTriangle232:
	BTFSC       STATUS+0, 0 
	GOTO        L_SSD1306_FillTriangle52
;ssd1306oled.c,714 :: 		ssd1306_swap(y0, y1); ssd1306_swap(x0, x1);
	MOVF        FARG_SSD1306_FillTriangle_y0+0, 0 
	MOVWF       SSD1306_FillTriangle_t_L2+0 
	MOVF        FARG_SSD1306_FillTriangle_y0+1, 0 
	MOVWF       SSD1306_FillTriangle_t_L2+1 
	MOVF        FARG_SSD1306_FillTriangle_y1+0, 0 
	MOVWF       FARG_SSD1306_FillTriangle_y0+0 
	MOVF        FARG_SSD1306_FillTriangle_y1+1, 0 
	MOVWF       FARG_SSD1306_FillTriangle_y0+1 
	MOVF        SSD1306_FillTriangle_t_L2+0, 0 
	MOVWF       FARG_SSD1306_FillTriangle_y1+0 
	MOVF        SSD1306_FillTriangle_t_L2+1, 0 
	MOVWF       FARG_SSD1306_FillTriangle_y1+1 
	MOVF        FARG_SSD1306_FillTriangle_x0+0, 0 
	MOVWF       SSD1306_FillTriangle_t_L2_L2+0 
	MOVF        FARG_SSD1306_FillTriangle_x0+1, 0 
	MOVWF       SSD1306_FillTriangle_t_L2_L2+1 
	MOVF        FARG_SSD1306_FillTriangle_x1+0, 0 
	MOVWF       FARG_SSD1306_FillTriangle_x0+0 
	MOVF        FARG_SSD1306_FillTriangle_x1+1, 0 
	MOVWF       FARG_SSD1306_FillTriangle_x0+1 
	MOVF        SSD1306_FillTriangle_t_L2_L2+0, 0 
	MOVWF       FARG_SSD1306_FillTriangle_x1+0 
	MOVF        SSD1306_FillTriangle_t_L2_L2+1, 0 
	MOVWF       FARG_SSD1306_FillTriangle_x1+1 
;ssd1306oled.c,715 :: 		}
L_SSD1306_FillTriangle52:
;ssd1306oled.c,716 :: 		if (y1 > y2) {
	MOVLW       128
	XORWF       FARG_SSD1306_FillTriangle_y2+1, 0 
	MOVWF       R0 
	MOVLW       128
	XORWF       FARG_SSD1306_FillTriangle_y1+1, 0 
	SUBWF       R0, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_FillTriangle233
	MOVF        FARG_SSD1306_FillTriangle_y1+0, 0 
	SUBWF       FARG_SSD1306_FillTriangle_y2+0, 0 
L__SSD1306_FillTriangle233:
	BTFSC       STATUS+0, 0 
	GOTO        L_SSD1306_FillTriangle53
;ssd1306oled.c,717 :: 		ssd1306_swap(y2, y1); ssd1306_swap(x2, x1);
	MOVF        FARG_SSD1306_FillTriangle_y2+0, 0 
	MOVWF       SSD1306_FillTriangle_t_L2_L2_L2+0 
	MOVF        FARG_SSD1306_FillTriangle_y2+1, 0 
	MOVWF       SSD1306_FillTriangle_t_L2_L2_L2+1 
	MOVF        FARG_SSD1306_FillTriangle_y1+0, 0 
	MOVWF       FARG_SSD1306_FillTriangle_y2+0 
	MOVF        FARG_SSD1306_FillTriangle_y1+1, 0 
	MOVWF       FARG_SSD1306_FillTriangle_y2+1 
	MOVF        SSD1306_FillTriangle_t_L2_L2_L2+0, 0 
	MOVWF       FARG_SSD1306_FillTriangle_y1+0 
	MOVF        SSD1306_FillTriangle_t_L2_L2_L2+1, 0 
	MOVWF       FARG_SSD1306_FillTriangle_y1+1 
	MOVF        FARG_SSD1306_FillTriangle_x2+0, 0 
	MOVWF       SSD1306_FillTriangle_t_L2_L2_L2_L2+0 
	MOVF        FARG_SSD1306_FillTriangle_x2+1, 0 
	MOVWF       SSD1306_FillTriangle_t_L2_L2_L2_L2+1 
	MOVF        FARG_SSD1306_FillTriangle_x1+0, 0 
	MOVWF       FARG_SSD1306_FillTriangle_x2+0 
	MOVF        FARG_SSD1306_FillTriangle_x1+1, 0 
	MOVWF       FARG_SSD1306_FillTriangle_x2+1 
	MOVF        SSD1306_FillTriangle_t_L2_L2_L2_L2+0, 0 
	MOVWF       FARG_SSD1306_FillTriangle_x1+0 
	MOVF        SSD1306_FillTriangle_t_L2_L2_L2_L2+1, 0 
	MOVWF       FARG_SSD1306_FillTriangle_x1+1 
;ssd1306oled.c,718 :: 		}
L_SSD1306_FillTriangle53:
;ssd1306oled.c,719 :: 		if (y0 > y1) {
	MOVLW       128
	XORWF       FARG_SSD1306_FillTriangle_y1+1, 0 
	MOVWF       R0 
	MOVLW       128
	XORWF       FARG_SSD1306_FillTriangle_y0+1, 0 
	SUBWF       R0, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_FillTriangle234
	MOVF        FARG_SSD1306_FillTriangle_y0+0, 0 
	SUBWF       FARG_SSD1306_FillTriangle_y1+0, 0 
L__SSD1306_FillTriangle234:
	BTFSC       STATUS+0, 0 
	GOTO        L_SSD1306_FillTriangle54
;ssd1306oled.c,720 :: 		ssd1306_swap(y0, y1); ssd1306_swap(x0, x1);
	MOVF        FARG_SSD1306_FillTriangle_y0+0, 0 
	MOVWF       SSD1306_FillTriangle_t_L2_L2_L2_L2_L2+0 
	MOVF        FARG_SSD1306_FillTriangle_y0+1, 0 
	MOVWF       SSD1306_FillTriangle_t_L2_L2_L2_L2_L2+1 
	MOVF        FARG_SSD1306_FillTriangle_y1+0, 0 
	MOVWF       FARG_SSD1306_FillTriangle_y0+0 
	MOVF        FARG_SSD1306_FillTriangle_y1+1, 0 
	MOVWF       FARG_SSD1306_FillTriangle_y0+1 
	MOVF        SSD1306_FillTriangle_t_L2_L2_L2_L2_L2+0, 0 
	MOVWF       FARG_SSD1306_FillTriangle_y1+0 
	MOVF        SSD1306_FillTriangle_t_L2_L2_L2_L2_L2+1, 0 
	MOVWF       FARG_SSD1306_FillTriangle_y1+1 
	MOVF        FARG_SSD1306_FillTriangle_x0+0, 0 
	MOVWF       SSD1306_FillTriangle_t_L2_L2_L2_L2_L2_L2+0 
	MOVF        FARG_SSD1306_FillTriangle_x0+1, 0 
	MOVWF       SSD1306_FillTriangle_t_L2_L2_L2_L2_L2_L2+1 
	MOVF        FARG_SSD1306_FillTriangle_x1+0, 0 
	MOVWF       FARG_SSD1306_FillTriangle_x0+0 
	MOVF        FARG_SSD1306_FillTriangle_x1+1, 0 
	MOVWF       FARG_SSD1306_FillTriangle_x0+1 
	MOVF        SSD1306_FillTriangle_t_L2_L2_L2_L2_L2_L2+0, 0 
	MOVWF       FARG_SSD1306_FillTriangle_x1+0 
	MOVF        SSD1306_FillTriangle_t_L2_L2_L2_L2_L2_L2+1, 0 
	MOVWF       FARG_SSD1306_FillTriangle_x1+1 
;ssd1306oled.c,721 :: 		}
L_SSD1306_FillTriangle54:
;ssd1306oled.c,723 :: 		if(y0 == y2) { // Handle awkward all-on-same-line case as its own thing
	MOVF        FARG_SSD1306_FillTriangle_y0+1, 0 
	XORWF       FARG_SSD1306_FillTriangle_y2+1, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_FillTriangle235
	MOVF        FARG_SSD1306_FillTriangle_y2+0, 0 
	XORWF       FARG_SSD1306_FillTriangle_y0+0, 0 
L__SSD1306_FillTriangle235:
	BTFSS       STATUS+0, 2 
	GOTO        L_SSD1306_FillTriangle55
;ssd1306oled.c,724 :: 		a = b = x0;
	MOVF        FARG_SSD1306_FillTriangle_x0+0, 0 
	MOVWF       SSD1306_FillTriangle_b_L0+0 
	MOVF        FARG_SSD1306_FillTriangle_x0+1, 0 
	MOVWF       SSD1306_FillTriangle_b_L0+1 
	MOVF        FARG_SSD1306_FillTriangle_x0+0, 0 
	MOVWF       SSD1306_FillTriangle_a_L0+0 
	MOVF        FARG_SSD1306_FillTriangle_x0+1, 0 
	MOVWF       SSD1306_FillTriangle_a_L0+1 
;ssd1306oled.c,725 :: 		if(x1 < a)      a = x1;
	MOVLW       128
	XORWF       FARG_SSD1306_FillTriangle_x1+1, 0 
	MOVWF       R0 
	MOVLW       128
	XORWF       FARG_SSD1306_FillTriangle_x0+1, 0 
	SUBWF       R0, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_FillTriangle236
	MOVF        FARG_SSD1306_FillTriangle_x0+0, 0 
	SUBWF       FARG_SSD1306_FillTriangle_x1+0, 0 
L__SSD1306_FillTriangle236:
	BTFSC       STATUS+0, 0 
	GOTO        L_SSD1306_FillTriangle56
	MOVF        FARG_SSD1306_FillTriangle_x1+0, 0 
	MOVWF       SSD1306_FillTriangle_a_L0+0 
	MOVF        FARG_SSD1306_FillTriangle_x1+1, 0 
	MOVWF       SSD1306_FillTriangle_a_L0+1 
	GOTO        L_SSD1306_FillTriangle57
L_SSD1306_FillTriangle56:
;ssd1306oled.c,726 :: 		else if(x1 > b) b = x1;
	MOVLW       128
	XORWF       SSD1306_FillTriangle_b_L0+1, 0 
	MOVWF       R0 
	MOVLW       128
	XORWF       FARG_SSD1306_FillTriangle_x1+1, 0 
	SUBWF       R0, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_FillTriangle237
	MOVF        FARG_SSD1306_FillTriangle_x1+0, 0 
	SUBWF       SSD1306_FillTriangle_b_L0+0, 0 
L__SSD1306_FillTriangle237:
	BTFSC       STATUS+0, 0 
	GOTO        L_SSD1306_FillTriangle58
	MOVF        FARG_SSD1306_FillTriangle_x1+0, 0 
	MOVWF       SSD1306_FillTriangle_b_L0+0 
	MOVF        FARG_SSD1306_FillTriangle_x1+1, 0 
	MOVWF       SSD1306_FillTriangle_b_L0+1 
L_SSD1306_FillTriangle58:
L_SSD1306_FillTriangle57:
;ssd1306oled.c,727 :: 		if(x2 < a)      a = x2;
	MOVLW       128
	XORWF       FARG_SSD1306_FillTriangle_x2+1, 0 
	MOVWF       R0 
	MOVLW       128
	XORWF       SSD1306_FillTriangle_a_L0+1, 0 
	SUBWF       R0, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_FillTriangle238
	MOVF        SSD1306_FillTriangle_a_L0+0, 0 
	SUBWF       FARG_SSD1306_FillTriangle_x2+0, 0 
L__SSD1306_FillTriangle238:
	BTFSC       STATUS+0, 0 
	GOTO        L_SSD1306_FillTriangle59
	MOVF        FARG_SSD1306_FillTriangle_x2+0, 0 
	MOVWF       SSD1306_FillTriangle_a_L0+0 
	MOVF        FARG_SSD1306_FillTriangle_x2+1, 0 
	MOVWF       SSD1306_FillTriangle_a_L0+1 
	GOTO        L_SSD1306_FillTriangle60
L_SSD1306_FillTriangle59:
;ssd1306oled.c,728 :: 		else if(x2 > b) b = x2;
	MOVLW       128
	XORWF       SSD1306_FillTriangle_b_L0+1, 0 
	MOVWF       R0 
	MOVLW       128
	XORWF       FARG_SSD1306_FillTriangle_x2+1, 0 
	SUBWF       R0, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_FillTriangle239
	MOVF        FARG_SSD1306_FillTriangle_x2+0, 0 
	SUBWF       SSD1306_FillTriangle_b_L0+0, 0 
L__SSD1306_FillTriangle239:
	BTFSC       STATUS+0, 0 
	GOTO        L_SSD1306_FillTriangle61
	MOVF        FARG_SSD1306_FillTriangle_x2+0, 0 
	MOVWF       SSD1306_FillTriangle_b_L0+0 
	MOVF        FARG_SSD1306_FillTriangle_x2+1, 0 
	MOVWF       SSD1306_FillTriangle_b_L0+1 
L_SSD1306_FillTriangle61:
L_SSD1306_FillTriangle60:
;ssd1306oled.c,729 :: 		SSD1306_DrawFastHLine(a, y0, b - a + 1);
	MOVF        SSD1306_FillTriangle_a_L0+0, 0 
	MOVWF       FARG_SSD1306_DrawFastHLine_x+0 
	MOVF        FARG_SSD1306_FillTriangle_y0+0, 0 
	MOVWF       FARG_SSD1306_DrawFastHLine_y+0 
	MOVF        SSD1306_FillTriangle_a_L0+0, 0 
	SUBWF       SSD1306_FillTriangle_b_L0+0, 0 
	MOVWF       FARG_SSD1306_DrawFastHLine_w+0 
	INCF        FARG_SSD1306_DrawFastHLine_w+0, 1 
	CALL        _SSD1306_DrawFastHLine+0, 0
;ssd1306oled.c,730 :: 		return;
	GOTO        L_end_SSD1306_FillTriangle
;ssd1306oled.c,731 :: 		}
L_SSD1306_FillTriangle55:
;ssd1306oled.c,733 :: 		if(y1 == y2) last = y1;   // Include y1 scanline
	MOVF        FARG_SSD1306_FillTriangle_y1+1, 0 
	XORWF       FARG_SSD1306_FillTriangle_y2+1, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_FillTriangle240
	MOVF        FARG_SSD1306_FillTriangle_y2+0, 0 
	XORWF       FARG_SSD1306_FillTriangle_y1+0, 0 
L__SSD1306_FillTriangle240:
	BTFSS       STATUS+0, 2 
	GOTO        L_SSD1306_FillTriangle62
	MOVF        FARG_SSD1306_FillTriangle_y1+0, 0 
	MOVWF       SSD1306_FillTriangle_last_L0+0 
	MOVF        FARG_SSD1306_FillTriangle_y1+1, 0 
	MOVWF       SSD1306_FillTriangle_last_L0+1 
	GOTO        L_SSD1306_FillTriangle63
L_SSD1306_FillTriangle62:
;ssd1306oled.c,734 :: 		else         last = y1 - 1; // Skip it
	MOVLW       1
	SUBWF       FARG_SSD1306_FillTriangle_y1+0, 0 
	MOVWF       SSD1306_FillTriangle_last_L0+0 
	MOVLW       0
	SUBWFB      FARG_SSD1306_FillTriangle_y1+1, 0 
	MOVWF       SSD1306_FillTriangle_last_L0+1 
L_SSD1306_FillTriangle63:
;ssd1306oled.c,736 :: 		for(y = y0; y <= last; y++) {
	MOVF        FARG_SSD1306_FillTriangle_y0+0, 0 
	MOVWF       SSD1306_FillTriangle_y_L0+0 
	MOVF        FARG_SSD1306_FillTriangle_y0+1, 0 
	MOVWF       SSD1306_FillTriangle_y_L0+1 
L_SSD1306_FillTriangle64:
	MOVLW       128
	XORWF       SSD1306_FillTriangle_last_L0+1, 0 
	MOVWF       R0 
	MOVLW       128
	XORWF       SSD1306_FillTriangle_y_L0+1, 0 
	SUBWF       R0, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_FillTriangle241
	MOVF        SSD1306_FillTriangle_y_L0+0, 0 
	SUBWF       SSD1306_FillTriangle_last_L0+0, 0 
L__SSD1306_FillTriangle241:
	BTFSS       STATUS+0, 0 
	GOTO        L_SSD1306_FillTriangle65
;ssd1306oled.c,737 :: 		a   = x0 + sa / dy01;
	MOVF        SSD1306_FillTriangle_dy01_L0+0, 0 
	MOVWF       R4 
	MOVF        SSD1306_FillTriangle_dy01_L0+1, 0 
	MOVWF       R5 
	MOVLW       0
	BTFSC       SSD1306_FillTriangle_dy01_L0+1, 7 
	MOVLW       255
	MOVWF       R6 
	MOVWF       R7 
	MOVF        SSD1306_FillTriangle_sa_L0+0, 0 
	MOVWF       R0 
	MOVF        SSD1306_FillTriangle_sa_L0+1, 0 
	MOVWF       R1 
	MOVF        SSD1306_FillTriangle_sa_L0+2, 0 
	MOVWF       R2 
	MOVF        SSD1306_FillTriangle_sa_L0+3, 0 
	MOVWF       R3 
	CALL        _Div_32x32_S+0, 0
	MOVF        FARG_SSD1306_FillTriangle_x0+0, 0 
	ADDWF       R0, 0 
	MOVWF       FLOC__SSD1306_FillTriangle+0 
	MOVF        FARG_SSD1306_FillTriangle_x0+1, 0 
	ADDWFC      R1, 0 
	MOVWF       FLOC__SSD1306_FillTriangle+1 
	MOVF        FLOC__SSD1306_FillTriangle+0, 0 
	MOVWF       SSD1306_FillTriangle_a_L0+0 
	MOVF        FLOC__SSD1306_FillTriangle+1, 0 
	MOVWF       SSD1306_FillTriangle_a_L0+1 
;ssd1306oled.c,738 :: 		b   = x0 + sb / dy02;
	MOVF        SSD1306_FillTriangle_dy02_L0+0, 0 
	MOVWF       R4 
	MOVF        SSD1306_FillTriangle_dy02_L0+1, 0 
	MOVWF       R5 
	MOVLW       0
	BTFSC       SSD1306_FillTriangle_dy02_L0+1, 7 
	MOVLW       255
	MOVWF       R6 
	MOVWF       R7 
	MOVF        SSD1306_FillTriangle_sb_L0+0, 0 
	MOVWF       R0 
	MOVF        SSD1306_FillTriangle_sb_L0+1, 0 
	MOVWF       R1 
	MOVF        SSD1306_FillTriangle_sb_L0+2, 0 
	MOVWF       R2 
	MOVF        SSD1306_FillTriangle_sb_L0+3, 0 
	MOVWF       R3 
	CALL        _Div_32x32_S+0, 0
	MOVF        FARG_SSD1306_FillTriangle_x0+0, 0 
	ADDWF       R0, 0 
	MOVWF       R4 
	MOVF        FARG_SSD1306_FillTriangle_x0+1, 0 
	ADDWFC      R1, 0 
	MOVWF       R5 
	MOVF        R4, 0 
	MOVWF       SSD1306_FillTriangle_b_L0+0 
	MOVF        R5, 0 
	MOVWF       SSD1306_FillTriangle_b_L0+1 
;ssd1306oled.c,739 :: 		sa += dx01;
	MOVF        SSD1306_FillTriangle_dx01_L0+0, 0 
	ADDWF       SSD1306_FillTriangle_sa_L0+0, 1 
	MOVF        SSD1306_FillTriangle_dx01_L0+1, 0 
	ADDWFC      SSD1306_FillTriangle_sa_L0+1, 1 
	MOVLW       0
	BTFSC       SSD1306_FillTriangle_dx01_L0+1, 7 
	MOVLW       255
	ADDWFC      SSD1306_FillTriangle_sa_L0+2, 1 
	ADDWFC      SSD1306_FillTriangle_sa_L0+3, 1 
;ssd1306oled.c,740 :: 		sb += dx02;
	MOVF        SSD1306_FillTriangle_dx02_L0+0, 0 
	ADDWF       SSD1306_FillTriangle_sb_L0+0, 1 
	MOVF        SSD1306_FillTriangle_dx02_L0+1, 0 
	ADDWFC      SSD1306_FillTriangle_sb_L0+1, 1 
	MOVLW       0
	BTFSC       SSD1306_FillTriangle_dx02_L0+1, 7 
	MOVLW       255
	ADDWFC      SSD1306_FillTriangle_sb_L0+2, 1 
	ADDWFC      SSD1306_FillTriangle_sb_L0+3, 1 
;ssd1306oled.c,745 :: 		if(a > b) ssd1306_swap(a, b);
	MOVLW       128
	XORWF       R5, 0 
	MOVWF       R0 
	MOVLW       128
	XORWF       FLOC__SSD1306_FillTriangle+1, 0 
	SUBWF       R0, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_FillTriangle242
	MOVF        FLOC__SSD1306_FillTriangle+0, 0 
	SUBWF       R4, 0 
L__SSD1306_FillTriangle242:
	BTFSC       STATUS+0, 0 
	GOTO        L_SSD1306_FillTriangle67
	MOVF        SSD1306_FillTriangle_a_L0+0, 0 
	MOVWF       SSD1306_FillTriangle_t_L2_L2_L2_L2_L2_L2_L2+0 
	MOVF        SSD1306_FillTriangle_a_L0+1, 0 
	MOVWF       SSD1306_FillTriangle_t_L2_L2_L2_L2_L2_L2_L2+1 
	MOVF        SSD1306_FillTriangle_b_L0+0, 0 
	MOVWF       SSD1306_FillTriangle_a_L0+0 
	MOVF        SSD1306_FillTriangle_b_L0+1, 0 
	MOVWF       SSD1306_FillTriangle_a_L0+1 
	MOVF        SSD1306_FillTriangle_t_L2_L2_L2_L2_L2_L2_L2+0, 0 
	MOVWF       SSD1306_FillTriangle_b_L0+0 
	MOVF        SSD1306_FillTriangle_t_L2_L2_L2_L2_L2_L2_L2+1, 0 
	MOVWF       SSD1306_FillTriangle_b_L0+1 
L_SSD1306_FillTriangle67:
;ssd1306oled.c,746 :: 		SSD1306_DrawFastHLine(a, y, b - a + 1);
	MOVF        SSD1306_FillTriangle_a_L0+0, 0 
	MOVWF       FARG_SSD1306_DrawFastHLine_x+0 
	MOVF        SSD1306_FillTriangle_y_L0+0, 0 
	MOVWF       FARG_SSD1306_DrawFastHLine_y+0 
	MOVF        SSD1306_FillTriangle_a_L0+0, 0 
	SUBWF       SSD1306_FillTriangle_b_L0+0, 0 
	MOVWF       FARG_SSD1306_DrawFastHLine_w+0 
	INCF        FARG_SSD1306_DrawFastHLine_w+0, 1 
	CALL        _SSD1306_DrawFastHLine+0, 0
;ssd1306oled.c,736 :: 		for(y = y0; y <= last; y++) {
	INFSNZ      SSD1306_FillTriangle_y_L0+0, 1 
	INCF        SSD1306_FillTriangle_y_L0+1, 1 
;ssd1306oled.c,747 :: 		}
	GOTO        L_SSD1306_FillTriangle64
L_SSD1306_FillTriangle65:
;ssd1306oled.c,751 :: 		sa = dx12 * (y - y1);
	MOVF        FARG_SSD1306_FillTriangle_y1+0, 0 
	SUBWF       SSD1306_FillTriangle_y_L0+0, 0 
	MOVWF       R0 
	MOVF        FARG_SSD1306_FillTriangle_y1+1, 0 
	SUBWFB      SSD1306_FillTriangle_y_L0+1, 0 
	MOVWF       R1 
	MOVF        SSD1306_FillTriangle_dx12_L0+0, 0 
	MOVWF       R4 
	MOVF        SSD1306_FillTriangle_dx12_L0+1, 0 
	MOVWF       R5 
	CALL        _Mul_16X16_U+0, 0
	MOVF        R0, 0 
	MOVWF       SSD1306_FillTriangle_sa_L0+0 
	MOVF        R1, 0 
	MOVWF       SSD1306_FillTriangle_sa_L0+1 
	MOVLW       0
	BTFSC       R1, 7 
	MOVLW       255
	MOVWF       SSD1306_FillTriangle_sa_L0+2 
	MOVWF       SSD1306_FillTriangle_sa_L0+3 
;ssd1306oled.c,752 :: 		sb = dx02 * (y - y0);
	MOVF        FARG_SSD1306_FillTriangle_y0+0, 0 
	SUBWF       SSD1306_FillTriangle_y_L0+0, 0 
	MOVWF       R0 
	MOVF        FARG_SSD1306_FillTriangle_y0+1, 0 
	SUBWFB      SSD1306_FillTriangle_y_L0+1, 0 
	MOVWF       R1 
	MOVF        SSD1306_FillTriangle_dx02_L0+0, 0 
	MOVWF       R4 
	MOVF        SSD1306_FillTriangle_dx02_L0+1, 0 
	MOVWF       R5 
	CALL        _Mul_16X16_U+0, 0
	MOVF        R0, 0 
	MOVWF       SSD1306_FillTriangle_sb_L0+0 
	MOVF        R1, 0 
	MOVWF       SSD1306_FillTriangle_sb_L0+1 
	MOVLW       0
	BTFSC       R1, 7 
	MOVLW       255
	MOVWF       SSD1306_FillTriangle_sb_L0+2 
	MOVWF       SSD1306_FillTriangle_sb_L0+3 
;ssd1306oled.c,753 :: 		for(; y <= y2; y++) {
L_SSD1306_FillTriangle68:
	MOVLW       128
	XORWF       FARG_SSD1306_FillTriangle_y2+1, 0 
	MOVWF       R0 
	MOVLW       128
	XORWF       SSD1306_FillTriangle_y_L0+1, 0 
	SUBWF       R0, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_FillTriangle243
	MOVF        SSD1306_FillTriangle_y_L0+0, 0 
	SUBWF       FARG_SSD1306_FillTriangle_y2+0, 0 
L__SSD1306_FillTriangle243:
	BTFSS       STATUS+0, 0 
	GOTO        L_SSD1306_FillTriangle69
;ssd1306oled.c,754 :: 		a   = x1 + sa / dy12;
	MOVF        SSD1306_FillTriangle_dy12_L0+0, 0 
	MOVWF       R4 
	MOVF        SSD1306_FillTriangle_dy12_L0+1, 0 
	MOVWF       R5 
	MOVLW       0
	BTFSC       SSD1306_FillTriangle_dy12_L0+1, 7 
	MOVLW       255
	MOVWF       R6 
	MOVWF       R7 
	MOVF        SSD1306_FillTriangle_sa_L0+0, 0 
	MOVWF       R0 
	MOVF        SSD1306_FillTriangle_sa_L0+1, 0 
	MOVWF       R1 
	MOVF        SSD1306_FillTriangle_sa_L0+2, 0 
	MOVWF       R2 
	MOVF        SSD1306_FillTriangle_sa_L0+3, 0 
	MOVWF       R3 
	CALL        _Div_32x32_S+0, 0
	MOVF        FARG_SSD1306_FillTriangle_x1+0, 0 
	ADDWF       R0, 0 
	MOVWF       FLOC__SSD1306_FillTriangle+0 
	MOVF        FARG_SSD1306_FillTriangle_x1+1, 0 
	ADDWFC      R1, 0 
	MOVWF       FLOC__SSD1306_FillTriangle+1 
	MOVF        FLOC__SSD1306_FillTriangle+0, 0 
	MOVWF       SSD1306_FillTriangle_a_L0+0 
	MOVF        FLOC__SSD1306_FillTriangle+1, 0 
	MOVWF       SSD1306_FillTriangle_a_L0+1 
;ssd1306oled.c,755 :: 		b   = x0 + sb / dy02;
	MOVF        SSD1306_FillTriangle_dy02_L0+0, 0 
	MOVWF       R4 
	MOVF        SSD1306_FillTriangle_dy02_L0+1, 0 
	MOVWF       R5 
	MOVLW       0
	BTFSC       SSD1306_FillTriangle_dy02_L0+1, 7 
	MOVLW       255
	MOVWF       R6 
	MOVWF       R7 
	MOVF        SSD1306_FillTriangle_sb_L0+0, 0 
	MOVWF       R0 
	MOVF        SSD1306_FillTriangle_sb_L0+1, 0 
	MOVWF       R1 
	MOVF        SSD1306_FillTriangle_sb_L0+2, 0 
	MOVWF       R2 
	MOVF        SSD1306_FillTriangle_sb_L0+3, 0 
	MOVWF       R3 
	CALL        _Div_32x32_S+0, 0
	MOVF        FARG_SSD1306_FillTriangle_x0+0, 0 
	ADDWF       R0, 0 
	MOVWF       R4 
	MOVF        FARG_SSD1306_FillTriangle_x0+1, 0 
	ADDWFC      R1, 0 
	MOVWF       R5 
	MOVF        R4, 0 
	MOVWF       SSD1306_FillTriangle_b_L0+0 
	MOVF        R5, 0 
	MOVWF       SSD1306_FillTriangle_b_L0+1 
;ssd1306oled.c,756 :: 		sa += dx12;
	MOVF        SSD1306_FillTriangle_dx12_L0+0, 0 
	ADDWF       SSD1306_FillTriangle_sa_L0+0, 1 
	MOVF        SSD1306_FillTriangle_dx12_L0+1, 0 
	ADDWFC      SSD1306_FillTriangle_sa_L0+1, 1 
	MOVLW       0
	BTFSC       SSD1306_FillTriangle_dx12_L0+1, 7 
	MOVLW       255
	ADDWFC      SSD1306_FillTriangle_sa_L0+2, 1 
	ADDWFC      SSD1306_FillTriangle_sa_L0+3, 1 
;ssd1306oled.c,757 :: 		sb += dx02;
	MOVF        SSD1306_FillTriangle_dx02_L0+0, 0 
	ADDWF       SSD1306_FillTriangle_sb_L0+0, 1 
	MOVF        SSD1306_FillTriangle_dx02_L0+1, 0 
	ADDWFC      SSD1306_FillTriangle_sb_L0+1, 1 
	MOVLW       0
	BTFSC       SSD1306_FillTriangle_dx02_L0+1, 7 
	MOVLW       255
	ADDWFC      SSD1306_FillTriangle_sb_L0+2, 1 
	ADDWFC      SSD1306_FillTriangle_sb_L0+3, 1 
;ssd1306oled.c,762 :: 		if(a > b) ssd1306_swap(a, b);
	MOVLW       128
	XORWF       R5, 0 
	MOVWF       R0 
	MOVLW       128
	XORWF       FLOC__SSD1306_FillTriangle+1, 0 
	SUBWF       R0, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_FillTriangle244
	MOVF        FLOC__SSD1306_FillTriangle+0, 0 
	SUBWF       R4, 0 
L__SSD1306_FillTriangle244:
	BTFSC       STATUS+0, 0 
	GOTO        L_SSD1306_FillTriangle71
	MOVF        SSD1306_FillTriangle_a_L0+0, 0 
	MOVWF       SSD1306_FillTriangle_t_L2_L2_L2_L2_L2_L2_L2_L2+0 
	MOVF        SSD1306_FillTriangle_a_L0+1, 0 
	MOVWF       SSD1306_FillTriangle_t_L2_L2_L2_L2_L2_L2_L2_L2+1 
	MOVF        SSD1306_FillTriangle_b_L0+0, 0 
	MOVWF       SSD1306_FillTriangle_a_L0+0 
	MOVF        SSD1306_FillTriangle_b_L0+1, 0 
	MOVWF       SSD1306_FillTriangle_a_L0+1 
	MOVF        SSD1306_FillTriangle_t_L2_L2_L2_L2_L2_L2_L2_L2+0, 0 
	MOVWF       SSD1306_FillTriangle_b_L0+0 
	MOVF        SSD1306_FillTriangle_t_L2_L2_L2_L2_L2_L2_L2_L2+1, 0 
	MOVWF       SSD1306_FillTriangle_b_L0+1 
L_SSD1306_FillTriangle71:
;ssd1306oled.c,763 :: 		SSD1306_DrawFastHLine(a, y, b - a + 1);
	MOVF        SSD1306_FillTriangle_a_L0+0, 0 
	MOVWF       FARG_SSD1306_DrawFastHLine_x+0 
	MOVF        SSD1306_FillTriangle_y_L0+0, 0 
	MOVWF       FARG_SSD1306_DrawFastHLine_y+0 
	MOVF        SSD1306_FillTriangle_a_L0+0, 0 
	SUBWF       SSD1306_FillTriangle_b_L0+0, 0 
	MOVWF       FARG_SSD1306_DrawFastHLine_w+0 
	INCF        FARG_SSD1306_DrawFastHLine_w+0, 1 
	CALL        _SSD1306_DrawFastHLine+0, 0
;ssd1306oled.c,753 :: 		for(; y <= y2; y++) {
	INFSNZ      SSD1306_FillTriangle_y_L0+0, 1 
	INCF        SSD1306_FillTriangle_y_L0+1, 1 
;ssd1306oled.c,764 :: 		}
	GOTO        L_SSD1306_FillTriangle68
L_SSD1306_FillTriangle69:
;ssd1306oled.c,765 :: 		}
L_end_SSD1306_FillTriangle:
	RETURN      0
; end of _SSD1306_FillTriangle

_SSD1306_FillScreen:

;ssd1306oled.c,767 :: 		void SSD1306_FillScreen() {
;ssd1306oled.c,769 :: 		for (i = 0; i < (SSD1306_LCDWIDTH * SSD1306_LCDHEIGHT) / 8; i++)
	CLRF        R1 
	CLRF        R2 
L_SSD1306_FillScreen72:
	MOVLW       4
	SUBWF       R2, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_FillScreen246
	MOVLW       0
	SUBWF       R1, 0 
L__SSD1306_FillScreen246:
	BTFSC       STATUS+0, 0 
	GOTO        L_SSD1306_FillScreen73
;ssd1306oled.c,770 :: 		buffer[i] = 0xFF;
	MOVLW       si5351SDR_firmware_buffer+0
	ADDWF       R1, 0 
	MOVWF       FSR1L+0 
	MOVLW       hi_addr(si5351SDR_firmware_buffer+0)
	ADDWFC      R2, 0 
	MOVWF       FSR1L+1 
	MOVLW       255
	MOVWF       POSTINC1+0 
;ssd1306oled.c,769 :: 		for (i = 0; i < (SSD1306_LCDWIDTH * SSD1306_LCDHEIGHT) / 8; i++)
	INFSNZ      R1, 1 
	INCF        R2, 1 
;ssd1306oled.c,770 :: 		buffer[i] = 0xFF;
	GOTO        L_SSD1306_FillScreen72
L_SSD1306_FillScreen73:
;ssd1306oled.c,771 :: 		}
L_end_SSD1306_FillScreen:
	RETURN      0
; end of _SSD1306_FillScreen

_SSD1306_SetTextWrap:

;ssd1306oled.c,773 :: 		void SSD1306_SetTextWrap(bool w) {
;ssd1306oled.c,774 :: 		wrap = w;
	MOVF        FARG_SSD1306_SetTextWrap_w+0, 0 
	MOVWF       _wrap+0 
;ssd1306oled.c,775 :: 		}
L_end_SSD1306_SetTextWrap:
	RETURN      0
; end of _SSD1306_SetTextWrap

_SSD1306_InvertDisplay:

;ssd1306oled.c,778 :: 		void SSD1306_InvertDisplay(bool i) {
;ssd1306oled.c,779 :: 		if (i)
	MOVF        FARG_SSD1306_InvertDisplay_i+0, 1 
	BTFSC       STATUS+0, 2 
	GOTO        L_SSD1306_InvertDisplay75
;ssd1306oled.c,780 :: 		ssd1306_command(SSD1306_INVERTDISPLAY_);
	MOVLW       167
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
	GOTO        L_SSD1306_InvertDisplay76
L_SSD1306_InvertDisplay75:
;ssd1306oled.c,782 :: 		ssd1306_command(SSD1306_NORMALDISPLAY);
	MOVLW       166
	MOVWF       FARG_ssd1306_command_c+0 
	CALL        _ssd1306_command+0, 0
L_SSD1306_InvertDisplay76:
;ssd1306oled.c,783 :: 		}
L_end_SSD1306_InvertDisplay:
	RETURN      0
; end of _SSD1306_InvertDisplay

_SSD1306_TextSize:

;ssd1306oled.c,786 :: 		void SSD1306_TextSize(uint8_t t_size)
;ssd1306oled.c,788 :: 		if(t_size < 1)
	MOVLW       1
	SUBWF       FARG_SSD1306_TextSize_t_size+0, 0 
	BTFSC       STATUS+0, 0 
	GOTO        L_SSD1306_TextSize77
;ssd1306oled.c,789 :: 		t_size = 1;
	MOVLW       1
	MOVWF       FARG_SSD1306_TextSize_t_size+0 
L_SSD1306_TextSize77:
;ssd1306oled.c,790 :: 		text_size = t_size;
	MOVF        FARG_SSD1306_TextSize_t_size+0, 0 
	MOVWF       _text_size+0 
;ssd1306oled.c,791 :: 		}
L_end_SSD1306_TextSize:
	RETURN      0
; end of _SSD1306_TextSize

_SSD1306_GotoXY:

;ssd1306oled.c,794 :: 		void SSD1306_GotoXY(uint8_t x, uint8_t y)
;ssd1306oled.c,796 :: 		if((x >= SSD1306_LCDWIDTH) || (y >= SSD1306_LCDHEIGHT))
	MOVLW       128
	SUBWF       FARG_SSD1306_GotoXY_x+0, 0 
	BTFSC       STATUS+0, 0 
	GOTO        L__SSD1306_GotoXY180
	MOVLW       64
	SUBWF       FARG_SSD1306_GotoXY_y+0, 0 
	BTFSC       STATUS+0, 0 
	GOTO        L__SSD1306_GotoXY180
	GOTO        L_SSD1306_GotoXY80
L__SSD1306_GotoXY180:
;ssd1306oled.c,797 :: 		return;
	GOTO        L_end_SSD1306_GotoXY
L_SSD1306_GotoXY80:
;ssd1306oled.c,798 :: 		x_pos = x;
	MOVF        FARG_SSD1306_GotoXY_x+0, 0 
	MOVWF       _x_pos+0 
;ssd1306oled.c,799 :: 		y_pos = y;
	MOVF        FARG_SSD1306_GotoXY_y+0, 0 
	MOVWF       _y_pos+0 
;ssd1306oled.c,800 :: 		}
L_end_SSD1306_GotoXY:
	RETURN      0
; end of _SSD1306_GotoXY

_SSD1306_PutC:

;ssd1306oled.c,808 :: 		void SSD1306_PutC(uint8_t c) {
;ssd1306oled.c,811 :: 		if(c == '\a') {
	MOVF        FARG_SSD1306_PutC_c+0, 0 
	XORLW       7
	BTFSS       STATUS+0, 2 
	GOTO        L_SSD1306_PutC81
;ssd1306oled.c,812 :: 		x_pos = y_pos = 0;
	CLRF        _y_pos+0 
	CLRF        _x_pos+0 
;ssd1306oled.c,813 :: 		return;
	GOTO        L_end_SSD1306_PutC
;ssd1306oled.c,814 :: 		}
L_SSD1306_PutC81:
;ssd1306oled.c,815 :: 		if( (c == '\b') && (x_pos >= text_size * 6) ) {
	MOVF        FARG_SSD1306_PutC_c+0, 0 
	XORLW       8
	BTFSS       STATUS+0, 2 
	GOTO        L_SSD1306_PutC84
	MOVLW       6
	MULWF       _text_size+0 
	MOVF        PRODL+0, 0 
	MOVWF       R1 
	MOVF        PRODH+0, 0 
	MOVWF       R2 
	MOVLW       128
	MOVWF       R0 
	MOVLW       128
	XORWF       R2, 0 
	SUBWF       R0, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_PutC252
	MOVF        R1, 0 
	SUBWF       _x_pos+0, 0 
L__SSD1306_PutC252:
	BTFSS       STATUS+0, 0 
	GOTO        L_SSD1306_PutC84
L__SSD1306_PutC183:
;ssd1306oled.c,816 :: 		x_pos -= text_size * 6;
	MOVLW       6
	MULWF       _text_size+0 
	MOVF        PRODL+0, 0 
	MOVWF       R0 
	MOVF        R0, 0 
	SUBWF       _x_pos+0, 1 
;ssd1306oled.c,817 :: 		return;
	GOTO        L_end_SSD1306_PutC
;ssd1306oled.c,818 :: 		}
L_SSD1306_PutC84:
;ssd1306oled.c,819 :: 		if(c == '\r') {
	MOVF        FARG_SSD1306_PutC_c+0, 0 
	XORLW       13
	BTFSS       STATUS+0, 2 
	GOTO        L_SSD1306_PutC85
;ssd1306oled.c,820 :: 		x_pos = 0;
	CLRF        _x_pos+0 
;ssd1306oled.c,821 :: 		return;
	GOTO        L_end_SSD1306_PutC
;ssd1306oled.c,822 :: 		}
L_SSD1306_PutC85:
;ssd1306oled.c,823 :: 		if(c == '\n') {
	MOVF        FARG_SSD1306_PutC_c+0, 0 
	XORLW       10
	BTFSS       STATUS+0, 2 
	GOTO        L_SSD1306_PutC86
;ssd1306oled.c,824 :: 		y_pos += text_size * 8;
	MOVF        _text_size+0, 0 
	MOVWF       R0 
	RLCF        R0, 1 
	BCF         R0, 0 
	RLCF        R0, 1 
	BCF         R0, 0 
	RLCF        R0, 1 
	BCF         R0, 0 
	MOVF        R0, 0 
	ADDWF       _y_pos+0, 0 
	MOVWF       R2 
	MOVF        R2, 0 
	MOVWF       _y_pos+0 
;ssd1306oled.c,825 :: 		if((y_pos + text_size * 7) >= SSD1306_LCDHEIGHT)
	MOVLW       7
	MULWF       _text_size+0 
	MOVF        PRODL+0, 0 
	MOVWF       R0 
	MOVF        PRODH+0, 0 
	MOVWF       R1 
	MOVF        R2, 0 
	ADDWF       R0, 0 
	MOVWF       R2 
	MOVLW       0
	ADDWFC      R1, 0 
	MOVWF       R3 
	MOVLW       128
	XORWF       R3, 0 
	MOVWF       R0 
	MOVLW       128
	SUBWF       R0, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_PutC253
	MOVLW       64
	SUBWF       R2, 0 
L__SSD1306_PutC253:
	BTFSS       STATUS+0, 0 
	GOTO        L_SSD1306_PutC87
;ssd1306oled.c,826 :: 		y_pos = 0;
	CLRF        _y_pos+0 
L_SSD1306_PutC87:
;ssd1306oled.c,827 :: 		return;
	GOTO        L_end_SSD1306_PutC
;ssd1306oled.c,828 :: 		}
L_SSD1306_PutC86:
;ssd1306oled.c,830 :: 		if((c < ' ') || (c > '~'))
	MOVLW       32
	SUBWF       FARG_SSD1306_PutC_c+0, 0 
	BTFSS       STATUS+0, 0 
	GOTO        L__SSD1306_PutC182
	MOVF        FARG_SSD1306_PutC_c+0, 0 
	SUBLW       126
	BTFSS       STATUS+0, 0 
	GOTO        L__SSD1306_PutC182
	GOTO        L_SSD1306_PutC90
L__SSD1306_PutC182:
;ssd1306oled.c,831 :: 		c = '?';
	MOVLW       63
	MOVWF       FARG_SSD1306_PutC_c+0 
L_SSD1306_PutC90:
;ssd1306oled.c,832 :: 		for(i = 0; i < 5; i++ ) {
	CLRF        SSD1306_PutC_i_L0+0 
L_SSD1306_PutC91:
	MOVLW       5
	SUBWF       SSD1306_PutC_i_L0+0, 0 
	BTFSC       STATUS+0, 0 
	GOTO        L_SSD1306_PutC92
;ssd1306oled.c,833 :: 		line = font[(c - 32) * 5 + i];
	MOVLW       32
	SUBWF       FARG_SSD1306_PutC_c+0, 0 
	MOVWF       R0 
	CLRF        R1 
	MOVLW       0
	SUBWFB      R1, 1 
	MOVLW       5
	MOVWF       R4 
	MOVLW       0
	MOVWF       R5 
	CALL        _Mul_16X16_U+0, 0
	MOVF        SSD1306_PutC_i_L0+0, 0 
	ADDWF       R0, 1 
	MOVLW       0
	ADDWFC      R1, 1 
	MOVLW       _Font+0
	ADDWF       R0, 0 
	MOVWF       TBLPTR+0 
	MOVLW       hi_addr(_Font+0)
	ADDWFC      R1, 0 
	MOVWF       TBLPTR+1 
	MOVLW       higher_addr(_Font+0)
	MOVWF       TBLPTR+2 
	MOVLW       0
	BTFSC       R1, 7 
	MOVLW       255
	ADDWFC      TBLPTR+2, 1 
	TBLRD*+
	MOVFF       TABLAT+0, SSD1306_PutC_line_L0+0
;ssd1306oled.c,835 :: 		for(j = 0; j < 7; j++, line >>= 1) {
	CLRF        SSD1306_PutC_j_L0+0 
L_SSD1306_PutC94:
	MOVLW       7
	SUBWF       SSD1306_PutC_j_L0+0, 0 
	BTFSC       STATUS+0, 0 
	GOTO        L_SSD1306_PutC95
;ssd1306oled.c,836 :: 		if(line & 0x01)
	BTFSS       SSD1306_PutC_line_L0+0, 0 
	GOTO        L_SSD1306_PutC97
;ssd1306oled.c,837 :: 		SSD1306_Color = true;
	MOVLW       1
	MOVWF       _SSD1306_Color+0 
	GOTO        L_SSD1306_PutC98
L_SSD1306_PutC97:
;ssd1306oled.c,839 :: 		SSD1306_Color = false;
	CLRF        _SSD1306_Color+0 
L_SSD1306_PutC98:
;ssd1306oled.c,840 :: 		if(text_size == 1) SSD1306_DrawPixel(x_pos + i, y_pos + j);
	MOVF        _text_size+0, 0 
	XORLW       1
	BTFSS       STATUS+0, 2 
	GOTO        L_SSD1306_PutC99
	MOVF        SSD1306_PutC_i_L0+0, 0 
	ADDWF       _x_pos+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_x+0 
	MOVF        SSD1306_PutC_j_L0+0, 0 
	ADDWF       _y_pos+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_y+0 
	CALL        _SSD1306_DrawPixel+0, 0
	GOTO        L_SSD1306_PutC100
L_SSD1306_PutC99:
;ssd1306oled.c,841 :: 		else               SSD1306_FillRect(x_pos + (i * text_size), y_pos + (j * text_size), text_size, text_size);
	MOVF        SSD1306_PutC_i_L0+0, 0 
	MULWF       _text_size+0 
	MOVF        PRODL+0, 0 
	MOVWF       R0 
	MOVF        R0, 0 
	ADDWF       _x_pos+0, 0 
	MOVWF       FARG_SSD1306_FillRect_x+0 
	MOVF        SSD1306_PutC_j_L0+0, 0 
	MULWF       _text_size+0 
	MOVF        PRODL+0, 0 
	MOVWF       R0 
	MOVF        R0, 0 
	ADDWF       _y_pos+0, 0 
	MOVWF       FARG_SSD1306_FillRect_y+0 
	MOVF        _text_size+0, 0 
	MOVWF       FARG_SSD1306_FillRect_w+0 
	MOVF        _text_size+0, 0 
	MOVWF       FARG_SSD1306_FillRect_h+0 
	CALL        _SSD1306_FillRect+0, 0
L_SSD1306_PutC100:
;ssd1306oled.c,835 :: 		for(j = 0; j < 7; j++, line >>= 1) {
	INCF        SSD1306_PutC_j_L0+0, 1 
	RRCF        SSD1306_PutC_line_L0+0, 1 
	BCF         SSD1306_PutC_line_L0+0, 7 
;ssd1306oled.c,842 :: 		}
	GOTO        L_SSD1306_PutC94
L_SSD1306_PutC95:
;ssd1306oled.c,832 :: 		for(i = 0; i < 5; i++ ) {
	INCF        SSD1306_PutC_i_L0+0, 1 
;ssd1306oled.c,843 :: 		}
	GOTO        L_SSD1306_PutC91
L_SSD1306_PutC92:
;ssd1306oled.c,845 :: 		SSD1306_Color = false;
	CLRF        _SSD1306_Color+0 
;ssd1306oled.c,846 :: 		SSD1306_FillRect(x_pos + (5 * text_size), y_pos, text_size, 7 * text_size);
	MOVLW       5
	MULWF       _text_size+0 
	MOVF        PRODL+0, 0 
	MOVWF       R0 
	MOVF        R0, 0 
	ADDWF       _x_pos+0, 0 
	MOVWF       FARG_SSD1306_FillRect_x+0 
	MOVF        _y_pos+0, 0 
	MOVWF       FARG_SSD1306_FillRect_y+0 
	MOVF        _text_size+0, 0 
	MOVWF       FARG_SSD1306_FillRect_w+0 
	MOVLW       7
	MULWF       _text_size+0 
	MOVF        PRODL+0, 0 
	MOVWF       FARG_SSD1306_FillRect_h+0 
	CALL        _SSD1306_FillRect+0, 0
;ssd1306oled.c,848 :: 		x_pos += text_size * 6;
	MOVLW       6
	MULWF       _text_size+0 
	MOVF        PRODL+0, 0 
	MOVWF       R0 
	MOVF        R0, 0 
	ADDWF       _x_pos+0, 1 
;ssd1306oled.c,849 :: 		if (wrap && (x_pos + (text_size * 5)) >= SSD1306_LCDWIDTH)
	MOVF        _wrap+0, 1 
	BTFSC       STATUS+0, 2 
	GOTO        L_SSD1306_PutC103
	MOVLW       5
	MULWF       _text_size+0 
	MOVF        PRODL+0, 0 
	MOVWF       R0 
	MOVF        PRODH+0, 0 
	MOVWF       R1 
	MOVF        _x_pos+0, 0 
	ADDWF       R0, 0 
	MOVWF       R2 
	MOVLW       0
	ADDWFC      R1, 0 
	MOVWF       R3 
	MOVLW       128
	XORWF       R3, 0 
	MOVWF       R0 
	MOVLW       128
	SUBWF       R0, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_PutC254
	MOVLW       128
	SUBWF       R2, 0 
L__SSD1306_PutC254:
	BTFSS       STATUS+0, 0 
	GOTO        L_SSD1306_PutC103
L__SSD1306_PutC181:
;ssd1306oled.c,851 :: 		x_pos = 0;
	CLRF        _x_pos+0 
;ssd1306oled.c,852 :: 		y_pos += text_size * 8;
	MOVF        _text_size+0, 0 
	MOVWF       R0 
	RLCF        R0, 1 
	BCF         R0, 0 
	RLCF        R0, 1 
	BCF         R0, 0 
	RLCF        R0, 1 
	BCF         R0, 0 
	MOVF        R0, 0 
	ADDWF       _y_pos+0, 0 
	MOVWF       R2 
	MOVF        R2, 0 
	MOVWF       _y_pos+0 
;ssd1306oled.c,853 :: 		if((y_pos + text_size * 7) >= SSD1306_LCDHEIGHT)
	MOVLW       7
	MULWF       _text_size+0 
	MOVF        PRODL+0, 0 
	MOVWF       R0 
	MOVF        PRODH+0, 0 
	MOVWF       R1 
	MOVF        R2, 0 
	ADDWF       R0, 0 
	MOVWF       R2 
	MOVLW       0
	ADDWFC      R1, 0 
	MOVWF       R3 
	MOVLW       128
	XORWF       R3, 0 
	MOVWF       R0 
	MOVLW       128
	SUBWF       R0, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_PutC255
	MOVLW       64
	SUBWF       R2, 0 
L__SSD1306_PutC255:
	BTFSS       STATUS+0, 0 
	GOTO        L_SSD1306_PutC104
;ssd1306oled.c,854 :: 		y_pos = 0;
	CLRF        _y_pos+0 
L_SSD1306_PutC104:
;ssd1306oled.c,855 :: 		}
L_SSD1306_PutC103:
;ssd1306oled.c,856 :: 		}
L_end_SSD1306_PutC:
	RETURN      0
; end of _SSD1306_PutC

_SSD1306_Print:

;ssd1306oled.c,859 :: 		void SSD1306_Print(char *s) {
;ssd1306oled.c,860 :: 		uint8_t i = 0;
	CLRF        SSD1306_Print_i_L0+0 
;ssd1306oled.c,861 :: 		while (s[i] != '\0'){
L_SSD1306_Print105:
	MOVF        SSD1306_Print_i_L0+0, 0 
	ADDWF       FARG_SSD1306_Print_s+0, 0 
	MOVWF       FSR0L+0 
	MOVLW       0
	ADDWFC      FARG_SSD1306_Print_s+1, 0 
	MOVWF       FSR0L+1 
	MOVF        POSTINC0+0, 0 
	XORLW       0
	BTFSC       STATUS+0, 2 
	GOTO        L_SSD1306_Print106
;ssd1306oled.c,862 :: 		if (s[i] == ' ' && x_pos == 0 && wrap)
	MOVF        SSD1306_Print_i_L0+0, 0 
	ADDWF       FARG_SSD1306_Print_s+0, 0 
	MOVWF       FSR0L+0 
	MOVLW       0
	ADDWFC      FARG_SSD1306_Print_s+1, 0 
	MOVWF       FSR0L+1 
	MOVF        POSTINC0+0, 0 
	XORLW       32
	BTFSS       STATUS+0, 2 
	GOTO        L_SSD1306_Print109
	MOVF        _x_pos+0, 0 
	XORLW       0
	BTFSS       STATUS+0, 2 
	GOTO        L_SSD1306_Print109
	MOVF        _wrap+0, 1 
	BTFSC       STATUS+0, 2 
	GOTO        L_SSD1306_Print109
L__SSD1306_Print184:
;ssd1306oled.c,863 :: 		i++;
	INCF        SSD1306_Print_i_L0+0, 1 
	GOTO        L_SSD1306_Print110
L_SSD1306_Print109:
;ssd1306oled.c,865 :: 		SSD1306_PutC(s[i++]);
	MOVF        SSD1306_Print_i_L0+0, 0 
	ADDWF       FARG_SSD1306_Print_s+0, 0 
	MOVWF       FSR0L+0 
	MOVLW       0
	ADDWFC      FARG_SSD1306_Print_s+1, 0 
	MOVWF       FSR0L+1 
	MOVF        POSTINC0+0, 0 
	MOVWF       FARG_SSD1306_PutC_c+0 
	CALL        _SSD1306_PutC+0, 0
	INCF        SSD1306_Print_i_L0+0, 1 
L_SSD1306_Print110:
;ssd1306oled.c,866 :: 		}
	GOTO        L_SSD1306_Print105
L_SSD1306_Print106:
;ssd1306oled.c,867 :: 		}
L_end_SSD1306_Print:
	RETURN      0
; end of _SSD1306_Print

_SSD1306_PutCustomC:

;ssd1306oled.c,870 :: 		void SSD1306_PutCustomC(const uint8_t *c) {
;ssd1306oled.c,873 :: 		for(i = 0; i < 5; i++ ) {
	CLRF        SSD1306_PutCustomC_i_L0+0 
L_SSD1306_PutCustomC111:
	MOVLW       5
	SUBWF       SSD1306_PutCustomC_i_L0+0, 0 
	BTFSC       STATUS+0, 0 
	GOTO        L_SSD1306_PutCustomC112
;ssd1306oled.c,874 :: 		line = c[i];
	MOVF        SSD1306_PutCustomC_i_L0+0, 0 
	ADDWF       FARG_SSD1306_PutCustomC_c+0, 0 
	MOVWF       TBLPTR+0 
	MOVLW       0
	ADDWFC      FARG_SSD1306_PutCustomC_c+1, 0 
	MOVWF       TBLPTR+1 
	MOVLW       0
	ADDWFC      FARG_SSD1306_PutCustomC_c+2, 0 
	MOVWF       TBLPTR+2 
	TBLRD*+
	MOVFF       TABLAT+0, SSD1306_PutCustomC_line_L0+0
;ssd1306oled.c,876 :: 		for(j = 0; j < 7; j++, line >>= 1) {
	CLRF        SSD1306_PutCustomC_j_L0+0 
L_SSD1306_PutCustomC114:
	MOVLW       7
	SUBWF       SSD1306_PutCustomC_j_L0+0, 0 
	BTFSC       STATUS+0, 0 
	GOTO        L_SSD1306_PutCustomC115
;ssd1306oled.c,877 :: 		if(line & 0x01)
	BTFSS       SSD1306_PutCustomC_line_L0+0, 0 
	GOTO        L_SSD1306_PutCustomC117
;ssd1306oled.c,878 :: 		SSD1306_Color = 1;
	MOVLW       1
	MOVWF       _SSD1306_Color+0 
	GOTO        L_SSD1306_PutCustomC118
L_SSD1306_PutCustomC117:
;ssd1306oled.c,880 :: 		SSD1306_Color = 0;
	CLRF        _SSD1306_Color+0 
L_SSD1306_PutCustomC118:
;ssd1306oled.c,881 :: 		if(text_size == 1) SSD1306_DrawPixel(x_pos + i, y_pos + j);
	MOVF        _text_size+0, 0 
	XORLW       1
	BTFSS       STATUS+0, 2 
	GOTO        L_SSD1306_PutCustomC119
	MOVF        SSD1306_PutCustomC_i_L0+0, 0 
	ADDWF       _x_pos+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_x+0 
	MOVF        SSD1306_PutCustomC_j_L0+0, 0 
	ADDWF       _y_pos+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_y+0 
	CALL        _SSD1306_DrawPixel+0, 0
	GOTO        L_SSD1306_PutCustomC120
L_SSD1306_PutCustomC119:
;ssd1306oled.c,882 :: 		else               SSD1306_FillRect(x_pos + (i * text_size), y_pos + (j * text_size), text_size, text_size);
	MOVF        SSD1306_PutCustomC_i_L0+0, 0 
	MULWF       _text_size+0 
	MOVF        PRODL+0, 0 
	MOVWF       R0 
	MOVF        R0, 0 
	ADDWF       _x_pos+0, 0 
	MOVWF       FARG_SSD1306_FillRect_x+0 
	MOVF        SSD1306_PutCustomC_j_L0+0, 0 
	MULWF       _text_size+0 
	MOVF        PRODL+0, 0 
	MOVWF       R0 
	MOVF        R0, 0 
	ADDWF       _y_pos+0, 0 
	MOVWF       FARG_SSD1306_FillRect_y+0 
	MOVF        _text_size+0, 0 
	MOVWF       FARG_SSD1306_FillRect_w+0 
	MOVF        _text_size+0, 0 
	MOVWF       FARG_SSD1306_FillRect_h+0 
	CALL        _SSD1306_FillRect+0, 0
L_SSD1306_PutCustomC120:
;ssd1306oled.c,876 :: 		for(j = 0; j < 7; j++, line >>= 1) {
	INCF        SSD1306_PutCustomC_j_L0+0, 1 
	RRCF        SSD1306_PutCustomC_line_L0+0, 1 
	BCF         SSD1306_PutCustomC_line_L0+0, 7 
;ssd1306oled.c,883 :: 		}
	GOTO        L_SSD1306_PutCustomC114
L_SSD1306_PutCustomC115:
;ssd1306oled.c,873 :: 		for(i = 0; i < 5; i++ ) {
	INCF        SSD1306_PutCustomC_i_L0+0, 1 
;ssd1306oled.c,884 :: 		}
	GOTO        L_SSD1306_PutCustomC111
L_SSD1306_PutCustomC112:
;ssd1306oled.c,886 :: 		x_pos += (text_size * 6);
	MOVLW       6
	MULWF       _text_size+0 
	MOVF        PRODL+0, 0 
	MOVWF       R0 
	MOVF        R0, 0 
	ADDWF       _x_pos+0, 1 
;ssd1306oled.c,887 :: 		if (wrap && (x_pos + (text_size * 5)) >= SSD1306_LCDWIDTH)
	MOVF        _wrap+0, 1 
	BTFSC       STATUS+0, 2 
	GOTO        L_SSD1306_PutCustomC123
	MOVLW       5
	MULWF       _text_size+0 
	MOVF        PRODL+0, 0 
	MOVWF       R0 
	MOVF        PRODH+0, 0 
	MOVWF       R1 
	MOVF        _x_pos+0, 0 
	ADDWF       R0, 0 
	MOVWF       R2 
	MOVLW       0
	ADDWFC      R1, 0 
	MOVWF       R3 
	MOVLW       128
	XORWF       R3, 0 
	MOVWF       R0 
	MOVLW       128
	SUBWF       R0, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_PutCustomC258
	MOVLW       128
	SUBWF       R2, 0 
L__SSD1306_PutCustomC258:
	BTFSS       STATUS+0, 0 
	GOTO        L_SSD1306_PutCustomC123
L__SSD1306_PutCustomC185:
;ssd1306oled.c,889 :: 		x_pos = 0;
	CLRF        _x_pos+0 
;ssd1306oled.c,890 :: 		y_pos += text_size * 8;
	MOVF        _text_size+0, 0 
	MOVWF       R0 
	RLCF        R0, 1 
	BCF         R0, 0 
	RLCF        R0, 1 
	BCF         R0, 0 
	RLCF        R0, 1 
	BCF         R0, 0 
	MOVF        R0, 0 
	ADDWF       _y_pos+0, 0 
	MOVWF       R2 
	MOVF        R2, 0 
	MOVWF       _y_pos+0 
;ssd1306oled.c,891 :: 		if((y_pos + text_size * 7) >= SSD1306_LCDHEIGHT)
	MOVLW       7
	MULWF       _text_size+0 
	MOVF        PRODL+0, 0 
	MOVWF       R0 
	MOVF        PRODH+0, 0 
	MOVWF       R1 
	MOVF        R2, 0 
	ADDWF       R0, 0 
	MOVWF       R2 
	MOVLW       0
	ADDWFC      R1, 0 
	MOVWF       R3 
	MOVLW       128
	XORWF       R3, 0 
	MOVWF       R0 
	MOVLW       128
	SUBWF       R0, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_PutCustomC259
	MOVLW       64
	SUBWF       R2, 0 
L__SSD1306_PutCustomC259:
	BTFSS       STATUS+0, 0 
	GOTO        L_SSD1306_PutCustomC124
;ssd1306oled.c,892 :: 		y_pos = 0;
	CLRF        _y_pos+0 
L_SSD1306_PutCustomC124:
;ssd1306oled.c,893 :: 		}
L_SSD1306_PutCustomC123:
;ssd1306oled.c,894 :: 		}
L_end_SSD1306_PutCustomC:
	RETURN      0
; end of _SSD1306_PutCustomC

_SSD1306_DrawBMP:

;ssd1306oled.c,897 :: 		void SSD1306_DrawBMP(uint8_t x, uint8_t y, const uint8_t *bitmap, uint8_t w, uint8_t h)
;ssd1306oled.c,901 :: 		for (j = 0; j < h/8; j++) {
	CLRF        SSD1306_DrawBMP_j_L0+0 
	CLRF        SSD1306_DrawBMP_j_L0+1 
L_SSD1306_DrawBMP125:
	MOVF        FARG_SSD1306_DrawBMP_h+0, 0 
	MOVWF       R1 
	RRCF        R1, 1 
	BCF         R1, 7 
	RRCF        R1, 1 
	BCF         R1, 7 
	RRCF        R1, 1 
	BCF         R1, 7 
	MOVLW       0
	SUBWF       SSD1306_DrawBMP_j_L0+1, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__SSD1306_DrawBMP261
	MOVF        R1, 0 
	SUBWF       SSD1306_DrawBMP_j_L0+0, 0 
L__SSD1306_DrawBMP261:
	BTFSC       STATUS+0, 0 
	GOTO        L_SSD1306_DrawBMP126
;ssd1306oled.c,902 :: 		for(i = 0; i < w; i++)   {
	CLRF        SSD1306_DrawBMP_i_L0+0 
L_SSD1306_DrawBMP128:
	MOVF        FARG_SSD1306_DrawBMP_w+0, 0 
	SUBWF       SSD1306_DrawBMP_i_L0+0, 0 
	BTFSC       STATUS+0, 0 
	GOTO        L_SSD1306_DrawBMP129
;ssd1306oled.c,903 :: 		for(k = 0; k < 8; k++)  {
	CLRF        SSD1306_DrawBMP_k_L0+0 
L_SSD1306_DrawBMP131:
	MOVLW       8
	SUBWF       SSD1306_DrawBMP_k_L0+0, 0 
	BTFSC       STATUS+0, 0 
	GOTO        L_SSD1306_DrawBMP132
;ssd1306oled.c,904 :: 		if( bitmap[i + j*w] & 1 << k)
	MOVF        SSD1306_DrawBMP_j_L0+0, 0 
	MOVWF       R0 
	MOVF        SSD1306_DrawBMP_j_L0+1, 0 
	MOVWF       R1 
	MOVF        FARG_SSD1306_DrawBMP_w+0, 0 
	MOVWF       R4 
	MOVLW       0
	MOVWF       R5 
	CALL        _Mul_16X16_U+0, 0
	MOVF        SSD1306_DrawBMP_i_L0+0, 0 
	ADDWF       R0, 1 
	MOVLW       0
	ADDWFC      R1, 1 
	MOVF        R0, 0 
	ADDWF       FARG_SSD1306_DrawBMP_bitmap+0, 0 
	MOVWF       TBLPTR+0 
	MOVF        R1, 0 
	ADDWFC      FARG_SSD1306_DrawBMP_bitmap+1, 0 
	MOVWF       TBLPTR+1 
	MOVLW       0
	ADDWFC      FARG_SSD1306_DrawBMP_bitmap+2, 0 
	MOVWF       TBLPTR+2 
	TBLRD*+
	MOVFF       TABLAT+0, R3
	MOVF        SSD1306_DrawBMP_k_L0+0, 0 
	MOVWF       R2 
	MOVLW       1
	MOVWF       R0 
	MOVLW       0
	MOVWF       R1 
	MOVF        R2, 0 
L__SSD1306_DrawBMP262:
	BZ          L__SSD1306_DrawBMP263
	RLCF        R0, 1 
	BCF         R0, 0 
	RLCF        R1, 1 
	ADDLW       255
	GOTO        L__SSD1306_DrawBMP262
L__SSD1306_DrawBMP263:
	MOVF        R3, 0 
	ANDWF       R0, 1 
	MOVLW       0
	ANDWF       R1, 1 
	MOVF        R0, 0 
	IORWF       R1, 0 
	BTFSC       STATUS+0, 2 
	GOTO        L_SSD1306_DrawBMP134
;ssd1306oled.c,905 :: 		SSD1306_Color = true;
	MOVLW       1
	MOVWF       _SSD1306_Color+0 
	GOTO        L_SSD1306_DrawBMP135
L_SSD1306_DrawBMP134:
;ssd1306oled.c,907 :: 		SSD1306_Color = false;
	CLRF        _SSD1306_Color+0 
L_SSD1306_DrawBMP135:
;ssd1306oled.c,908 :: 		SSD1306_DrawPixel(x + i, y + j*8 + k);
	MOVF        SSD1306_DrawBMP_i_L0+0, 0 
	ADDWF       FARG_SSD1306_DrawBMP_x+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_x+0 
	MOVLW       3
	MOVWF       R1 
	MOVF        SSD1306_DrawBMP_j_L0+0, 0 
	MOVWF       R0 
	MOVF        R1, 0 
L__SSD1306_DrawBMP264:
	BZ          L__SSD1306_DrawBMP265
	RLCF        R0, 1 
	BCF         R0, 0 
	ADDLW       255
	GOTO        L__SSD1306_DrawBMP264
L__SSD1306_DrawBMP265:
	MOVF        R0, 0 
	ADDWF       FARG_SSD1306_DrawBMP_y+0, 0 
	MOVWF       FARG_SSD1306_DrawPixel_y+0 
	MOVF        SSD1306_DrawBMP_k_L0+0, 0 
	ADDWF       FARG_SSD1306_DrawPixel_y+0, 1 
	CALL        _SSD1306_DrawPixel+0, 0
;ssd1306oled.c,903 :: 		for(k = 0; k < 8; k++)  {
	INCF        SSD1306_DrawBMP_k_L0+0, 1 
;ssd1306oled.c,909 :: 		}
	GOTO        L_SSD1306_DrawBMP131
L_SSD1306_DrawBMP132:
;ssd1306oled.c,902 :: 		for(i = 0; i < w; i++)   {
	INCF        SSD1306_DrawBMP_i_L0+0, 1 
;ssd1306oled.c,910 :: 		}
	GOTO        L_SSD1306_DrawBMP128
L_SSD1306_DrawBMP129:
;ssd1306oled.c,901 :: 		for (j = 0; j < h/8; j++) {
	INFSNZ      SSD1306_DrawBMP_j_L0+0, 1 
	INCF        SSD1306_DrawBMP_j_L0+1, 1 
;ssd1306oled.c,911 :: 		}
	GOTO        L_SSD1306_DrawBMP125
L_SSD1306_DrawBMP126:
;ssd1306oled.c,912 :: 		}
L_end_SSD1306_DrawBMP:
	RETURN      0
; end of _SSD1306_DrawBMP

_sendRegister:

;si5351SDR_firmware.c,16 :: 		void sendRegister(char reg_addr, char reg_value){
;si5351SDR_firmware.c,17 :: 		I2C1_Start();
	CALL        _I2C1_Start+0, 0
;si5351SDR_firmware.c,18 :: 		I2C1_Wr(SI5351A_ADDRESS);
	MOVLW       192
	MOVWF       FARG_I2C1_Wr_data_+0 
	CALL        _I2C1_Wr+0, 0
;si5351SDR_firmware.c,19 :: 		I2C1_Wr(reg_addr);
	MOVF        FARG_sendRegister_reg_addr+0, 0 
	MOVWF       FARG_I2C1_Wr_data_+0 
	CALL        _I2C1_Wr+0, 0
;si5351SDR_firmware.c,20 :: 		I2C1_Wr(reg_value);
	MOVF        FARG_sendRegister_reg_value+0, 0 
	MOVWF       FARG_I2C1_Wr_data_+0 
	CALL        _I2C1_Wr+0, 0
;si5351SDR_firmware.c,21 :: 		I2C1_Stop();
	CALL        _I2C1_Stop+0, 0
;si5351SDR_firmware.c,22 :: 		}
L_end_sendRegister:
	RETURN      0
; end of _sendRegister

_si5351aSetFrequency:

;si5351SDR_firmware.c,23 :: 		void si5351aSetFrequency(unsigned long frequency){
;si5351SDR_firmware.c,26 :: 		unsigned long xtalFreq = Si5351A_XTAL_FREQ;
	MOVLW       44
	MOVWF       si5351aSetFrequency_xtalFreq_L0+0 
	MOVLW       117
	MOVWF       si5351aSetFrequency_xtalFreq_L0+1 
	MOVLW       125
	MOVWF       si5351aSetFrequency_xtalFreq_L0+2 
	MOVLW       1
	MOVWF       si5351aSetFrequency_xtalFreq_L0+3 
;si5351SDR_firmware.c,32 :: 		if(frequency < 9050001)divider = 124;
	MOVLW       0
	SUBWF       FARG_si5351aSetFrequency_frequency+3, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__si5351aSetFrequency268
	MOVLW       138
	SUBWF       FARG_si5351aSetFrequency_frequency+2, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__si5351aSetFrequency268
	MOVLW       23
	SUBWF       FARG_si5351aSetFrequency_frequency+1, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__si5351aSetFrequency268
	MOVLW       145
	SUBWF       FARG_si5351aSetFrequency_frequency+0, 0 
L__si5351aSetFrequency268:
	BTFSC       STATUS+0, 0 
	GOTO        L_si5351aSetFrequency136
	MOVLW       124
	MOVWF       si5351aSetFrequency_divider_L0+0 
	MOVLW       0
	MOVWF       si5351aSetFrequency_divider_L0+1 
L_si5351aSetFrequency136:
;si5351SDR_firmware.c,33 :: 		if(frequency > 9050000)divider = 44;
	MOVF        FARG_si5351aSetFrequency_frequency+3, 0 
	SUBLW       0
	BTFSS       STATUS+0, 2 
	GOTO        L__si5351aSetFrequency269
	MOVF        FARG_si5351aSetFrequency_frequency+2, 0 
	SUBLW       138
	BTFSS       STATUS+0, 2 
	GOTO        L__si5351aSetFrequency269
	MOVF        FARG_si5351aSetFrequency_frequency+1, 0 
	SUBLW       23
	BTFSS       STATUS+0, 2 
	GOTO        L__si5351aSetFrequency269
	MOVF        FARG_si5351aSetFrequency_frequency+0, 0 
	SUBLW       144
L__si5351aSetFrequency269:
	BTFSC       STATUS+0, 0 
	GOTO        L_si5351aSetFrequency137
	MOVLW       44
	MOVWF       si5351aSetFrequency_divider_L0+0 
	MOVLW       0
	MOVWF       si5351aSetFrequency_divider_L0+1 
L_si5351aSetFrequency137:
;si5351SDR_firmware.c,34 :: 		if(frequency > 16000000)divider = 20;
	MOVF        FARG_si5351aSetFrequency_frequency+3, 0 
	SUBLW       0
	BTFSS       STATUS+0, 2 
	GOTO        L__si5351aSetFrequency270
	MOVF        FARG_si5351aSetFrequency_frequency+2, 0 
	SUBLW       244
	BTFSS       STATUS+0, 2 
	GOTO        L__si5351aSetFrequency270
	MOVF        FARG_si5351aSetFrequency_frequency+1, 0 
	SUBLW       36
	BTFSS       STATUS+0, 2 
	GOTO        L__si5351aSetFrequency270
	MOVF        FARG_si5351aSetFrequency_frequency+0, 0 
	SUBLW       0
L__si5351aSetFrequency270:
	BTFSC       STATUS+0, 0 
	GOTO        L_si5351aSetFrequency138
	MOVLW       20
	MOVWF       si5351aSetFrequency_divider_L0+0 
	MOVLW       0
	MOVWF       si5351aSetFrequency_divider_L0+1 
L_si5351aSetFrequency138:
;si5351SDR_firmware.c,35 :: 		pllFreq = divider * frequency;        // Calculate the pllFrequency: the divider * desired output frequency
	MOVF        si5351aSetFrequency_divider_L0+0, 0 
	MOVWF       R0 
	MOVF        si5351aSetFrequency_divider_L0+1, 0 
	MOVWF       R1 
	MOVLW       0
	MOVWF       R2 
	MOVWF       R3 
	MOVF        FARG_si5351aSetFrequency_frequency+0, 0 
	MOVWF       R4 
	MOVF        FARG_si5351aSetFrequency_frequency+1, 0 
	MOVWF       R5 
	MOVF        FARG_si5351aSetFrequency_frequency+2, 0 
	MOVWF       R6 
	MOVF        FARG_si5351aSetFrequency_frequency+3, 0 
	MOVWF       R7 
	CALL        _Mul_32x32_U+0, 0
	MOVF        R0, 0 
	MOVWF       FLOC__si5351aSetFrequency+0 
	MOVF        R1, 0 
	MOVWF       FLOC__si5351aSetFrequency+1 
	MOVF        R2, 0 
	MOVWF       FLOC__si5351aSetFrequency+2 
	MOVF        R3, 0 
	MOVWF       FLOC__si5351aSetFrequency+3 
	MOVF        si5351aSetFrequency_xtalFreq_L0+0, 0 
	MOVWF       R4 
	MOVF        si5351aSetFrequency_xtalFreq_L0+1, 0 
	MOVWF       R5 
	MOVF        si5351aSetFrequency_xtalFreq_L0+2, 0 
	MOVWF       R6 
	MOVF        si5351aSetFrequency_xtalFreq_L0+3, 0 
	MOVWF       R7 
	MOVF        FLOC__si5351aSetFrequency+0, 0 
	MOVWF       R0 
	MOVF        FLOC__si5351aSetFrequency+1, 0 
	MOVWF       R1 
	MOVF        FLOC__si5351aSetFrequency+2, 0 
	MOVWF       R2 
	MOVF        FLOC__si5351aSetFrequency+3, 0 
	MOVWF       R3 
	CALL        _Div_32x32_U+0, 0
	MOVF        R0, 0 
	MOVWF       FLOC__si5351aSetFrequency+4 
	MOVF        R1, 0 
	MOVWF       FLOC__si5351aSetFrequency+5 
	MOVF        R2, 0 
	MOVWF       FLOC__si5351aSetFrequency+6 
	MOVF        R3, 0 
	MOVWF       FLOC__si5351aSetFrequency+7 
	MOVF        si5351aSetFrequency_xtalFreq_L0+0, 0 
	MOVWF       R4 
	MOVF        si5351aSetFrequency_xtalFreq_L0+1, 0 
	MOVWF       R5 
	MOVF        si5351aSetFrequency_xtalFreq_L0+2, 0 
	MOVWF       R6 
	MOVF        si5351aSetFrequency_xtalFreq_L0+3, 0 
	MOVWF       R7 
	MOVF        FLOC__si5351aSetFrequency+0, 0 
	MOVWF       R0 
	MOVF        FLOC__si5351aSetFrequency+1, 0 
	MOVWF       R1 
	MOVF        FLOC__si5351aSetFrequency+2, 0 
	MOVWF       R2 
	MOVF        FLOC__si5351aSetFrequency+3, 0 
	MOVWF       R3 
	CALL        _Div_32x32_U+0, 0
	MOVF        R8, 0 
	MOVWF       R0 
	MOVF        R9, 0 
	MOVWF       R1 
	MOVF        R10, 0 
	MOVWF       R2 
	MOVF        R11, 0 
	MOVWF       R3 
;si5351SDR_firmware.c,38 :: 		f = l;                                                        // mult is an integer that must be in the range 15..90
	CALL        _longword2double+0, 0
;si5351SDR_firmware.c,39 :: 		f *= 1048575;                                        // num and denom are the fractional parts, the numerator and denominator
	MOVLW       240
	MOVWF       R4 
	MOVLW       255
	MOVWF       R5 
	MOVLW       127
	MOVWF       R6 
	MOVLW       146
	MOVWF       R7 
	CALL        _Mul_32x32_FP+0, 0
	MOVF        R0, 0 
	MOVWF       FLOC__si5351aSetFrequency+0 
	MOVF        R1, 0 
	MOVWF       FLOC__si5351aSetFrequency+1 
	MOVF        R2, 0 
	MOVWF       FLOC__si5351aSetFrequency+2 
	MOVF        R3, 0 
	MOVWF       FLOC__si5351aSetFrequency+3 
	MOVF        si5351aSetFrequency_xtalFreq_L0+0, 0 
	MOVWF       R0 
	MOVF        si5351aSetFrequency_xtalFreq_L0+1, 0 
	MOVWF       R1 
	MOVF        si5351aSetFrequency_xtalFreq_L0+2, 0 
	MOVWF       R2 
	MOVF        si5351aSetFrequency_xtalFreq_L0+3, 0 
	MOVWF       R3 
	CALL        _longword2double+0, 0
;si5351SDR_firmware.c,40 :: 		f /= xtalFreq;                                        // each is 20 bits (range 0..1048575)
	MOVF        R0, 0 
	MOVWF       R4 
	MOVF        R1, 0 
	MOVWF       R5 
	MOVF        R2, 0 
	MOVWF       R6 
	MOVF        R3, 0 
	MOVWF       R7 
	MOVF        FLOC__si5351aSetFrequency+0, 0 
	MOVWF       R0 
	MOVF        FLOC__si5351aSetFrequency+1, 0 
	MOVWF       R1 
	MOVF        FLOC__si5351aSetFrequency+2, 0 
	MOVWF       R2 
	MOVF        FLOC__si5351aSetFrequency+3, 0 
	MOVWF       R3 
	CALL        _Div_32x32_FP+0, 0
;si5351SDR_firmware.c,41 :: 		num = f;                                                // the actual multiplier is  mult + num / denom
	CALL        _double2longword+0, 0
;si5351SDR_firmware.c,43 :: 		setupPLL(SI_SYNTH_PLL_A, mult, num, denom);      // Set up PLL A with the calculated multiplication ratio
	MOVLW       26
	MOVWF       FARG_setupPLL+0 
	MOVF        FLOC__si5351aSetFrequency+4, 0 
	MOVWF       FARG_setupPLL+0 
	MOVF        R0, 0 
	MOVWF       FARG_setupPLL+0 
	MOVF        R1, 0 
	MOVWF       FARG_setupPLL+1 
	MOVF        R2, 0 
	MOVWF       FARG_setupPLL+2 
	MOVF        R3, 0 
	MOVWF       FARG_setupPLL+3 
	MOVLW       255
	MOVWF       FARG_setupPLL+0 
	MOVLW       255
	MOVWF       FARG_setupPLL+1 
	MOVLW       15
	MOVWF       FARG_setupPLL+2 
	MOVLW       0
	MOVWF       FARG_setupPLL+3 
	CALL        _setupPLL+0, 0
;si5351SDR_firmware.c,44 :: 		setupMultisynth(SI_SYNTH_MS_0, divider, SI_R_DIV_1);
	MOVLW       42
	MOVWF       FARG_setupMultisynth+0 
	MOVF        si5351aSetFrequency_divider_L0+0, 0 
	MOVWF       FARG_setupMultisynth+0 
	MOVF        si5351aSetFrequency_divider_L0+1, 0 
	MOVWF       FARG_setupMultisynth+1 
	MOVLW       0
	MOVWF       FARG_setupMultisynth+2 
	MOVWF       FARG_setupMultisynth+3 
	CLRF        FARG_setupMultisynth+0 
	CALL        _setupMultisynth+0, 0
;si5351SDR_firmware.c,45 :: 		setupMultisynth(SI_SYNTH_MS_1, divider, SI_R_DIV_1);
	MOVLW       50
	MOVWF       FARG_setupMultisynth+0 
	MOVF        si5351aSetFrequency_divider_L0+0, 0 
	MOVWF       FARG_setupMultisynth+0 
	MOVF        si5351aSetFrequency_divider_L0+1, 0 
	MOVWF       FARG_setupMultisynth+1 
	MOVLW       0
	MOVWF       FARG_setupMultisynth+2 
	MOVWF       FARG_setupMultisynth+3 
	CLRF        FARG_setupMultisynth+0 
	CALL        _setupMultisynth+0, 0
;si5351SDR_firmware.c,46 :: 		sendRegister(CLK0_PHOFF,divider);
	MOVLW       165
	MOVWF       FARG_sendRegister_reg_addr+0 
	MOVF        si5351aSetFrequency_divider_L0+0, 0 
	MOVWF       FARG_sendRegister_reg_value+0 
	CALL        _sendRegister+0, 0
;si5351SDR_firmware.c,47 :: 		sendRegister(CLK1_PHOFF, 0);
	MOVLW       166
	MOVWF       FARG_sendRegister_reg_addr+0 
	CLRF        FARG_sendRegister_reg_value+0 
	CALL        _sendRegister+0, 0
;si5351SDR_firmware.c,48 :: 		}
L_end_si5351aSetFrequency:
	RETURN      0
; end of _si5351aSetFrequency

_setupPLL:

;si5351SDR_firmware.c,50 :: 		void setupPLL(unsigned char pll, unsigned char mult, unsigned long num, unsigned long denom){
;si5351SDR_firmware.c,55 :: 		P1 = (unsigned long)(128 * ((float)num / (float)denom));
	MOVF        FARG_setupPLL_num+0, 0 
	MOVWF       R0 
	MOVF        FARG_setupPLL_num+1, 0 
	MOVWF       R1 
	MOVF        FARG_setupPLL_num+2, 0 
	MOVWF       R2 
	MOVF        FARG_setupPLL_num+3, 0 
	MOVWF       R3 
	CALL        _longword2double+0, 0
	MOVF        R0, 0 
	MOVWF       FLOC__setupPLL+0 
	MOVF        R1, 0 
	MOVWF       FLOC__setupPLL+1 
	MOVF        R2, 0 
	MOVWF       FLOC__setupPLL+2 
	MOVF        R3, 0 
	MOVWF       FLOC__setupPLL+3 
	MOVF        FARG_setupPLL_denom+0, 0 
	MOVWF       R0 
	MOVF        FARG_setupPLL_denom+1, 0 
	MOVWF       R1 
	MOVF        FARG_setupPLL_denom+2, 0 
	MOVWF       R2 
	MOVF        FARG_setupPLL_denom+3, 0 
	MOVWF       R3 
	CALL        _longword2double+0, 0
	MOVF        R0, 0 
	MOVWF       R4 
	MOVF        R1, 0 
	MOVWF       R5 
	MOVF        R2, 0 
	MOVWF       R6 
	MOVF        R3, 0 
	MOVWF       R7 
	MOVF        FLOC__setupPLL+0, 0 
	MOVWF       R0 
	MOVF        FLOC__setupPLL+1, 0 
	MOVWF       R1 
	MOVF        FLOC__setupPLL+2, 0 
	MOVWF       R2 
	MOVF        FLOC__setupPLL+3, 0 
	MOVWF       R3 
	CALL        _Div_32x32_FP+0, 0
	MOVLW       0
	MOVWF       R4 
	MOVLW       0
	MOVWF       R5 
	MOVLW       0
	MOVWF       R6 
	MOVLW       134
	MOVWF       R7 
	CALL        _Mul_32x32_FP+0, 0
	CALL        _double2longword+0, 0
	MOVF        R0, 0 
	MOVWF       setupPLL_P1_L0+0 
	MOVF        R1, 0 
	MOVWF       setupPLL_P1_L0+1 
	MOVF        R2, 0 
	MOVWF       setupPLL_P1_L0+2 
	MOVF        R3, 0 
	MOVWF       setupPLL_P1_L0+3 
;si5351SDR_firmware.c,56 :: 		P1 = (unsigned long)(128 * (unsigned long)(mult) + P1 - 512);
	MOVF        FARG_setupPLL_mult+0, 0 
	MOVWF       setupPLL_P1_L0+0 
	MOVLW       0
	MOVWF       setupPLL_P1_L0+1 
	MOVWF       setupPLL_P1_L0+2 
	MOVWF       setupPLL_P1_L0+3 
	MOVLW       7
	MOVWF       R4 
	MOVF        R4, 0 
L__setupPLL272:
	BZ          L__setupPLL273
	RLCF        setupPLL_P1_L0+0, 1 
	BCF         setupPLL_P1_L0+0, 0 
	RLCF        setupPLL_P1_L0+1, 1 
	RLCF        setupPLL_P1_L0+2, 1 
	RLCF        setupPLL_P1_L0+3, 1 
	ADDLW       255
	GOTO        L__setupPLL272
L__setupPLL273:
	MOVF        R0, 0 
	ADDWF       setupPLL_P1_L0+0, 1 
	MOVF        R1, 0 
	ADDWFC      setupPLL_P1_L0+1, 1 
	MOVF        R2, 0 
	ADDWFC      setupPLL_P1_L0+2, 1 
	MOVF        R3, 0 
	ADDWFC      setupPLL_P1_L0+3, 1 
	MOVLW       0
	SUBWF       setupPLL_P1_L0+0, 1 
	MOVLW       2
	SUBWFB      setupPLL_P1_L0+1, 1 
	MOVLW       0
	SUBWFB      setupPLL_P1_L0+2, 1 
	SUBWFB      setupPLL_P1_L0+3, 1 
;si5351SDR_firmware.c,57 :: 		P2 = (unsigned long)(128 * ((float)num / (float)denom));
	MOVF        R0, 0 
	MOVWF       setupPLL_P2_L0+0 
	MOVF        R1, 0 
	MOVWF       setupPLL_P2_L0+1 
	MOVF        R2, 0 
	MOVWF       setupPLL_P2_L0+2 
	MOVF        R3, 0 
	MOVWF       setupPLL_P2_L0+3 
;si5351SDR_firmware.c,58 :: 		P2 = (unsigned long)(128 * num - denom * P2);
	MOVLW       7
	MOVWF       R4 
	MOVF        FARG_setupPLL_num+0, 0 
	MOVWF       setupPLL_P2_L0+0 
	MOVF        FARG_setupPLL_num+1, 0 
	MOVWF       setupPLL_P2_L0+1 
	MOVF        FARG_setupPLL_num+2, 0 
	MOVWF       setupPLL_P2_L0+2 
	MOVF        FARG_setupPLL_num+3, 0 
	MOVWF       setupPLL_P2_L0+3 
	MOVF        R4, 0 
L__setupPLL274:
	BZ          L__setupPLL275
	RLCF        setupPLL_P2_L0+0, 1 
	BCF         setupPLL_P2_L0+0, 0 
	RLCF        setupPLL_P2_L0+1, 1 
	RLCF        setupPLL_P2_L0+2, 1 
	RLCF        setupPLL_P2_L0+3, 1 
	ADDLW       255
	GOTO        L__setupPLL274
L__setupPLL275:
	MOVF        FARG_setupPLL_denom+0, 0 
	MOVWF       R4 
	MOVF        FARG_setupPLL_denom+1, 0 
	MOVWF       R5 
	MOVF        FARG_setupPLL_denom+2, 0 
	MOVWF       R6 
	MOVF        FARG_setupPLL_denom+3, 0 
	MOVWF       R7 
	CALL        _Mul_32x32_U+0, 0
	MOVF        R0, 0 
	SUBWF       setupPLL_P2_L0+0, 1 
	MOVF        R1, 0 
	SUBWFB      setupPLL_P2_L0+1, 1 
	MOVF        R2, 0 
	SUBWFB      setupPLL_P2_L0+2, 1 
	MOVF        R3, 0 
	SUBWFB      setupPLL_P2_L0+3, 1 
;si5351SDR_firmware.c,59 :: 		P3 = denom;
	MOVF        FARG_setupPLL_denom+0, 0 
	MOVWF       setupPLL_P3_L0+0 
	MOVF        FARG_setupPLL_denom+1, 0 
	MOVWF       setupPLL_P3_L0+1 
	MOVF        FARG_setupPLL_denom+2, 0 
	MOVWF       setupPLL_P3_L0+2 
	MOVF        FARG_setupPLL_denom+3, 0 
	MOVWF       setupPLL_P3_L0+3 
;si5351SDR_firmware.c,61 :: 		sendRegister(pll + 0, (P3 & 0x0000FF00) >> 8);
	MOVF        FARG_setupPLL_pll+0, 0 
	MOVWF       FARG_sendRegister_reg_addr+0 
	MOVLW       0
	ANDWF       FARG_setupPLL_denom+0, 0 
	MOVWF       R5 
	MOVLW       255
	ANDWF       FARG_setupPLL_denom+1, 0 
	MOVWF       R6 
	MOVF        FARG_setupPLL_denom+2, 0 
	MOVWF       R7 
	MOVF        FARG_setupPLL_denom+3, 0 
	MOVWF       R8 
	MOVLW       0
	ANDWF       R7, 1 
	ANDWF       R8, 1 
	MOVF        R6, 0 
	MOVWF       R0 
	MOVF        R7, 0 
	MOVWF       R1 
	MOVF        R8, 0 
	MOVWF       R2 
	CLRF        R3 
	MOVF        R0, 0 
	MOVWF       FARG_sendRegister_reg_value+0 
	CALL        _sendRegister+0, 0
;si5351SDR_firmware.c,62 :: 		sendRegister(pll + 1, (P3 & 0x000000FF));
	MOVF        FARG_setupPLL_pll+0, 0 
	ADDLW       1
	MOVWF       FARG_sendRegister_reg_addr+0 
	MOVLW       255
	ANDWF       setupPLL_P3_L0+0, 0 
	MOVWF       FARG_sendRegister_reg_value+0 
	CALL        _sendRegister+0, 0
;si5351SDR_firmware.c,63 :: 		sendRegister(pll + 2, (P1 & 0x00030000) >> 16);
	MOVLW       2
	ADDWF       FARG_setupPLL_pll+0, 0 
	MOVWF       FARG_sendRegister_reg_addr+0 
	MOVLW       0
	ANDWF       setupPLL_P1_L0+0, 0 
	MOVWF       R5 
	MOVLW       0
	ANDWF       setupPLL_P1_L0+1, 0 
	MOVWF       R6 
	MOVLW       3
	ANDWF       setupPLL_P1_L0+2, 0 
	MOVWF       R7 
	MOVLW       0
	ANDWF       setupPLL_P1_L0+3, 0 
	MOVWF       R8 
	MOVF        R7, 0 
	MOVWF       R0 
	MOVF        R8, 0 
	MOVWF       R1 
	CLRF        R2 
	CLRF        R3 
	MOVF        R0, 0 
	MOVWF       FARG_sendRegister_reg_value+0 
	CALL        _sendRegister+0, 0
;si5351SDR_firmware.c,64 :: 		sendRegister(pll + 3, (P1 & 0x0000FF00) >> 8);
	MOVLW       3
	ADDWF       FARG_setupPLL_pll+0, 0 
	MOVWF       FARG_sendRegister_reg_addr+0 
	MOVLW       0
	ANDWF       setupPLL_P1_L0+0, 0 
	MOVWF       R5 
	MOVLW       255
	ANDWF       setupPLL_P1_L0+1, 0 
	MOVWF       R6 
	MOVF        setupPLL_P1_L0+2, 0 
	MOVWF       R7 
	MOVF        setupPLL_P1_L0+3, 0 
	MOVWF       R8 
	MOVLW       0
	ANDWF       R7, 1 
	ANDWF       R8, 1 
	MOVF        R6, 0 
	MOVWF       R0 
	MOVF        R7, 0 
	MOVWF       R1 
	MOVF        R8, 0 
	MOVWF       R2 
	CLRF        R3 
	MOVF        R0, 0 
	MOVWF       FARG_sendRegister_reg_value+0 
	CALL        _sendRegister+0, 0
;si5351SDR_firmware.c,65 :: 		sendRegister(pll + 4, (P1 & 0x000000FF));
	MOVLW       4
	ADDWF       FARG_setupPLL_pll+0, 0 
	MOVWF       FARG_sendRegister_reg_addr+0 
	MOVLW       255
	ANDWF       setupPLL_P1_L0+0, 0 
	MOVWF       FARG_sendRegister_reg_value+0 
	CALL        _sendRegister+0, 0
;si5351SDR_firmware.c,66 :: 		sendRegister(pll + 5, ((P3 & 0x000F0000) >> 12) | ((P2 & 0x000F0000) >> 16));
	MOVLW       5
	ADDWF       FARG_setupPLL_pll+0, 0 
	MOVWF       FARG_sendRegister_reg_addr+0 
	MOVLW       0
	ANDWF       setupPLL_P3_L0+0, 0 
	MOVWF       R1 
	MOVLW       0
	ANDWF       setupPLL_P3_L0+1, 0 
	MOVWF       R2 
	MOVLW       15
	ANDWF       setupPLL_P3_L0+2, 0 
	MOVWF       R3 
	MOVLW       0
	ANDWF       setupPLL_P3_L0+3, 0 
	MOVWF       R4 
	MOVLW       12
	MOVWF       R0 
	MOVF        R1, 0 
	MOVWF       R9 
	MOVF        R2, 0 
	MOVWF       R10 
	MOVF        R3, 0 
	MOVWF       R11 
	MOVF        R4, 0 
	MOVWF       R12 
	MOVF        R0, 0 
L__setupPLL276:
	BZ          L__setupPLL277
	RRCF        R12, 1 
	RRCF        R11, 1 
	RRCF        R10, 1 
	RRCF        R9, 1 
	BCF         R12, 7 
	ADDLW       255
	GOTO        L__setupPLL276
L__setupPLL277:
	MOVLW       0
	ANDWF       setupPLL_P2_L0+0, 0 
	MOVWF       R5 
	MOVLW       0
	ANDWF       setupPLL_P2_L0+1, 0 
	MOVWF       R6 
	MOVLW       15
	ANDWF       setupPLL_P2_L0+2, 0 
	MOVWF       R7 
	MOVLW       0
	ANDWF       setupPLL_P2_L0+3, 0 
	MOVWF       R8 
	MOVF        R7, 0 
	MOVWF       R0 
	MOVF        R8, 0 
	MOVWF       R1 
	CLRF        R2 
	CLRF        R3 
	MOVF        R0, 0 
	IORWF       R9, 0 
	MOVWF       FARG_sendRegister_reg_value+0 
	CALL        _sendRegister+0, 0
;si5351SDR_firmware.c,67 :: 		sendRegister(pll + 6, (P2 & 0x0000FF00) >> 8);
	MOVLW       6
	ADDWF       FARG_setupPLL_pll+0, 0 
	MOVWF       FARG_sendRegister_reg_addr+0 
	MOVLW       0
	ANDWF       setupPLL_P2_L0+0, 0 
	MOVWF       R5 
	MOVLW       255
	ANDWF       setupPLL_P2_L0+1, 0 
	MOVWF       R6 
	MOVF        setupPLL_P2_L0+2, 0 
	MOVWF       R7 
	MOVF        setupPLL_P2_L0+3, 0 
	MOVWF       R8 
	MOVLW       0
	ANDWF       R7, 1 
	ANDWF       R8, 1 
	MOVF        R6, 0 
	MOVWF       R0 
	MOVF        R7, 0 
	MOVWF       R1 
	MOVF        R8, 0 
	MOVWF       R2 
	CLRF        R3 
	MOVF        R0, 0 
	MOVWF       FARG_sendRegister_reg_value+0 
	CALL        _sendRegister+0, 0
;si5351SDR_firmware.c,68 :: 		sendRegister(pll + 7, (P2 & 0x000000FF));
	MOVLW       7
	ADDWF       FARG_setupPLL_pll+0, 0 
	MOVWF       FARG_sendRegister_reg_addr+0 
	MOVLW       255
	ANDWF       setupPLL_P2_L0+0, 0 
	MOVWF       FARG_sendRegister_reg_value+0 
	CALL        _sendRegister+0, 0
;si5351SDR_firmware.c,69 :: 		}
L_end_setupPLL:
	RETURN      0
; end of _setupPLL

_setupMultisynth:

;si5351SDR_firmware.c,71 :: 		void setupMultisynth(unsigned char synth, unsigned long divider, unsigned char rDiv){
;si5351SDR_firmware.c,75 :: 		P1 = 128 * divider - 512;
	MOVLW       7
	MOVWF       R0 
	MOVF        FARG_setupMultisynth_divider+0, 0 
	MOVWF       setupMultisynth_P1_L0+0 
	MOVF        FARG_setupMultisynth_divider+1, 0 
	MOVWF       setupMultisynth_P1_L0+1 
	MOVF        FARG_setupMultisynth_divider+2, 0 
	MOVWF       setupMultisynth_P1_L0+2 
	MOVF        FARG_setupMultisynth_divider+3, 0 
	MOVWF       setupMultisynth_P1_L0+3 
	MOVF        R0, 0 
L__setupMultisynth279:
	BZ          L__setupMultisynth280
	RLCF        setupMultisynth_P1_L0+0, 1 
	BCF         setupMultisynth_P1_L0+0, 0 
	RLCF        setupMultisynth_P1_L0+1, 1 
	RLCF        setupMultisynth_P1_L0+2, 1 
	RLCF        setupMultisynth_P1_L0+3, 1 
	ADDLW       255
	GOTO        L__setupMultisynth279
L__setupMultisynth280:
	MOVLW       0
	SUBWF       setupMultisynth_P1_L0+0, 1 
	MOVLW       2
	SUBWFB      setupMultisynth_P1_L0+1, 1 
	MOVLW       0
	SUBWFB      setupMultisynth_P1_L0+2, 1 
	SUBWFB      setupMultisynth_P1_L0+3, 1 
;si5351SDR_firmware.c,76 :: 		P2 = 0; // P2 = 0, P3 = 1 forces an integer value for the divider
	CLRF        setupMultisynth_P2_L0+0 
	CLRF        setupMultisynth_P2_L0+1 
	CLRF        setupMultisynth_P2_L0+2 
	CLRF        setupMultisynth_P2_L0+3 
;si5351SDR_firmware.c,77 :: 		P3 = 1;
	MOVLW       1
	MOVWF       setupMultisynth_P3_L0+0 
	MOVLW       0
	MOVWF       setupMultisynth_P3_L0+1 
	MOVWF       setupMultisynth_P3_L0+2 
	MOVWF       setupMultisynth_P3_L0+3 
;si5351SDR_firmware.c,78 :: 		sendRegister(synth + 0,   (P3 & 0x0000FF00) >> 8);
	MOVF        FARG_setupMultisynth_synth+0, 0 
	MOVWF       FARG_sendRegister_reg_addr+0 
	CLRF        R5 
	CLRF        R6 
	CLRF        R7 
	CLRF        R8 
	MOVF        R6, 0 
	MOVWF       R0 
	MOVF        R7, 0 
	MOVWF       R1 
	MOVF        R8, 0 
	MOVWF       R2 
	CLRF        R3 
	MOVF        R0, 0 
	MOVWF       FARG_sendRegister_reg_value+0 
	CALL        _sendRegister+0, 0
;si5351SDR_firmware.c,79 :: 		sendRegister(synth + 1,   (P3 & 0x000000FF));
	MOVF        FARG_setupMultisynth_synth+0, 0 
	ADDLW       1
	MOVWF       FARG_sendRegister_reg_addr+0 
	MOVLW       255
	ANDWF       setupMultisynth_P3_L0+0, 0 
	MOVWF       FARG_sendRegister_reg_value+0 
	CALL        _sendRegister+0, 0
;si5351SDR_firmware.c,80 :: 		sendRegister(synth + 2,   ((P1 & 0x00030000) >> 16) | rDiv);
	MOVLW       2
	ADDWF       FARG_setupMultisynth_synth+0, 0 
	MOVWF       FARG_sendRegister_reg_addr+0 
	MOVLW       0
	ANDWF       setupMultisynth_P1_L0+0, 0 
	MOVWF       R5 
	MOVLW       0
	ANDWF       setupMultisynth_P1_L0+1, 0 
	MOVWF       R6 
	MOVLW       3
	ANDWF       setupMultisynth_P1_L0+2, 0 
	MOVWF       R7 
	MOVLW       0
	ANDWF       setupMultisynth_P1_L0+3, 0 
	MOVWF       R8 
	MOVF        R7, 0 
	MOVWF       R0 
	MOVF        R8, 0 
	MOVWF       R1 
	CLRF        R2 
	CLRF        R3 
	MOVF        FARG_setupMultisynth_rDiv+0, 0 
	IORWF       R0, 0 
	MOVWF       FARG_sendRegister_reg_value+0 
	CALL        _sendRegister+0, 0
;si5351SDR_firmware.c,81 :: 		sendRegister(synth + 3,   (P1 & 0x0000FF00) >> 8);
	MOVLW       3
	ADDWF       FARG_setupMultisynth_synth+0, 0 
	MOVWF       FARG_sendRegister_reg_addr+0 
	MOVLW       0
	ANDWF       setupMultisynth_P1_L0+0, 0 
	MOVWF       R5 
	MOVLW       255
	ANDWF       setupMultisynth_P1_L0+1, 0 
	MOVWF       R6 
	MOVF        setupMultisynth_P1_L0+2, 0 
	MOVWF       R7 
	MOVF        setupMultisynth_P1_L0+3, 0 
	MOVWF       R8 
	MOVLW       0
	ANDWF       R7, 1 
	ANDWF       R8, 1 
	MOVF        R6, 0 
	MOVWF       R0 
	MOVF        R7, 0 
	MOVWF       R1 
	MOVF        R8, 0 
	MOVWF       R2 
	CLRF        R3 
	MOVF        R0, 0 
	MOVWF       FARG_sendRegister_reg_value+0 
	CALL        _sendRegister+0, 0
;si5351SDR_firmware.c,82 :: 		sendRegister(synth + 4,   (P1 & 0x000000FF));
	MOVLW       4
	ADDWF       FARG_setupMultisynth_synth+0, 0 
	MOVWF       FARG_sendRegister_reg_addr+0 
	MOVLW       255
	ANDWF       setupMultisynth_P1_L0+0, 0 
	MOVWF       FARG_sendRegister_reg_value+0 
	CALL        _sendRegister+0, 0
;si5351SDR_firmware.c,83 :: 		sendRegister(synth + 5,   ((P3 & 0x000F0000) >> 12) | ((P2 & 0x000F0000) >> 16));
	MOVLW       5
	ADDWF       FARG_setupMultisynth_synth+0, 0 
	MOVWF       FARG_sendRegister_reg_addr+0 
	MOVLW       0
	ANDWF       setupMultisynth_P3_L0+0, 0 
	MOVWF       R1 
	MOVLW       0
	ANDWF       setupMultisynth_P3_L0+1, 0 
	MOVWF       R2 
	MOVLW       15
	ANDWF       setupMultisynth_P3_L0+2, 0 
	MOVWF       R3 
	MOVLW       0
	ANDWF       setupMultisynth_P3_L0+3, 0 
	MOVWF       R4 
	MOVLW       12
	MOVWF       R0 
	MOVF        R1, 0 
	MOVWF       R9 
	MOVF        R2, 0 
	MOVWF       R10 
	MOVF        R3, 0 
	MOVWF       R11 
	MOVF        R4, 0 
	MOVWF       R12 
	MOVF        R0, 0 
L__setupMultisynth281:
	BZ          L__setupMultisynth282
	RRCF        R12, 1 
	RRCF        R11, 1 
	RRCF        R10, 1 
	RRCF        R9, 1 
	BCF         R12, 7 
	ADDLW       255
	GOTO        L__setupMultisynth281
L__setupMultisynth282:
	MOVLW       0
	ANDWF       setupMultisynth_P2_L0+0, 0 
	MOVWF       R5 
	MOVLW       0
	ANDWF       setupMultisynth_P2_L0+1, 0 
	MOVWF       R6 
	MOVLW       15
	ANDWF       setupMultisynth_P2_L0+2, 0 
	MOVWF       R7 
	MOVLW       0
	ANDWF       setupMultisynth_P2_L0+3, 0 
	MOVWF       R8 
	MOVF        R7, 0 
	MOVWF       R0 
	MOVF        R8, 0 
	MOVWF       R1 
	CLRF        R2 
	CLRF        R3 
	MOVF        R0, 0 
	IORWF       R9, 0 
	MOVWF       FARG_sendRegister_reg_value+0 
	CALL        _sendRegister+0, 0
;si5351SDR_firmware.c,84 :: 		sendRegister(synth + 6,   (P2 & 0x0000FF00) >> 8);
	MOVLW       6
	ADDWF       FARG_setupMultisynth_synth+0, 0 
	MOVWF       FARG_sendRegister_reg_addr+0 
	MOVLW       0
	ANDWF       setupMultisynth_P2_L0+0, 0 
	MOVWF       R5 
	MOVLW       255
	ANDWF       setupMultisynth_P2_L0+1, 0 
	MOVWF       R6 
	MOVF        setupMultisynth_P2_L0+2, 0 
	MOVWF       R7 
	MOVF        setupMultisynth_P2_L0+3, 0 
	MOVWF       R8 
	MOVLW       0
	ANDWF       R7, 1 
	ANDWF       R8, 1 
	MOVF        R6, 0 
	MOVWF       R0 
	MOVF        R7, 0 
	MOVWF       R1 
	MOVF        R8, 0 
	MOVWF       R2 
	CLRF        R3 
	MOVF        R0, 0 
	MOVWF       FARG_sendRegister_reg_value+0 
	CALL        _sendRegister+0, 0
;si5351SDR_firmware.c,85 :: 		sendRegister(synth + 7,   (P2 & 0x000000FF));
	MOVLW       7
	ADDWF       FARG_setupMultisynth_synth+0, 0 
	MOVWF       FARG_sendRegister_reg_addr+0 
	MOVLW       255
	ANDWF       setupMultisynth_P2_L0+0, 0 
	MOVWF       FARG_sendRegister_reg_value+0 
	CALL        _sendRegister+0, 0
;si5351SDR_firmware.c,86 :: 		}
L_end_setupMultisynth:
	RETURN      0
; end of _setupMultisynth

_ADCRead:

;si5351SDR_firmware.c,89 :: 		unsigned ADCRead(){
;si5351SDR_firmware.c,90 :: 		unsigned A2DSample = 0;
	CLRF        ADCRead_A2DSample_L0+0 
	CLRF        ADCRead_A2DSample_L0+1 
;si5351SDR_firmware.c,91 :: 		ADCON0.Go = 1 ;
	BSF         ADCON0+0, 1 
;si5351SDR_firmware.c,92 :: 		while(ADCON0.Go == 1){}
L_ADCRead139:
	BTFSS       ADCON0+0, 1 
	GOTO        L_ADCRead140
	GOTO        L_ADCRead139
L_ADCRead140:
;si5351SDR_firmware.c,93 :: 		Hi(A2DSample) = ADRESH;
	MOVF        ADRESH+0, 0 
	MOVWF       ADCRead_A2DSample_L0+1 
;si5351SDR_firmware.c,94 :: 		Lo(A2DSample) = ADRESL;
	MOVF        ADRESL+0, 0 
	MOVWF       ADCRead_A2DSample_L0+0 
;si5351SDR_firmware.c,95 :: 		return A2DSample;
	MOVF        ADCRead_A2DSample_L0+0, 0 
	MOVWF       R0 
	MOVF        ADCRead_A2DSample_L0+1, 0 
	MOVWF       R1 
;si5351SDR_firmware.c,96 :: 		}
L_end_ADCRead:
	RETURN      0
; end of _ADCRead

_BatCheck:

;si5351SDR_firmware.c,98 :: 		void BatCheck(){
;si5351SDR_firmware.c,99 :: 		while(PrintCnt < 50){
L_BatCheck141:
	MOVLW       0
	SUBWF       _PrintCnt+1, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__BatCheck285
	MOVLW       50
	SUBWF       _PrintCnt+0, 0 
L__BatCheck285:
	BTFSC       STATUS+0, 0 
	GOTO        L_BatCheck142
;si5351SDR_firmware.c,100 :: 		PrintCnt ++;
	INFSNZ      _PrintCnt+0, 1 
	INCF        _PrintCnt+1, 1 
;si5351SDR_firmware.c,101 :: 		VBat = ADCRead();
	CALL        _ADCRead+0, 0
	MOVF        R0, 0 
	MOVWF       FLOC__BatCheck+0 
	MOVF        R1, 0 
	MOVWF       FLOC__BatCheck+1 
	MOVF        FLOC__BatCheck+0, 0 
	MOVWF       _VBat+0 
	MOVF        FLOC__BatCheck+1, 0 
	MOVWF       _VBat+1 
;si5351SDR_firmware.c,102 :: 		VBat = (VBat*(N-1) + VBat)/N;
	MOVF        FLOC__BatCheck+0, 0 
	MOVWF       R0 
	MOVF        FLOC__BatCheck+1, 0 
	MOVWF       R1 
	MOVLW       19
	MOVWF       R4 
	MOVLW       0
	MOVWF       R5 
	CALL        _Mul_16X16_U+0, 0
	MOVF        FLOC__BatCheck+0, 0 
	ADDWF       R0, 1 
	MOVF        FLOC__BatCheck+1, 0 
	ADDWFC      R1, 1 
	MOVLW       20
	MOVWF       R4 
	MOVLW       0
	MOVWF       R5 
	CALL        _Div_16X16_U+0, 0
	MOVF        R0, 0 
	MOVWF       _VBat+0 
	MOVF        R1, 0 
	MOVWF       _VBat+1 
;si5351SDR_firmware.c,103 :: 		VBat = (VBat * 52)/80;
	MOVLW       52
	MOVWF       R4 
	MOVLW       0
	MOVWF       R5 
	CALL        _Mul_16X16_U+0, 0
	MOVLW       80
	MOVWF       R4 
	MOVLW       0
	MOVWF       R5 
	CALL        _Div_16X16_U+0, 0
	MOVF        R0, 0 
	MOVWF       _VBat+0 
	MOVF        R1, 0 
	MOVWF       _VBat+1 
;si5351SDR_firmware.c,104 :: 		}
	GOTO        L_BatCheck141
L_BatCheck142:
;si5351SDR_firmware.c,105 :: 		wordtostr(VBat,LCDText);
	MOVF        _VBat+0, 0 
	MOVWF       FARG_WordToStr_input+0 
	MOVF        _VBat+1, 0 
	MOVWF       FARG_WordToStr_input+1 
	MOVLW       _LCDText+0
	MOVWF       FARG_WordToStr_output+0 
	MOVLW       hi_addr(_LCDText+0)
	MOVWF       FARG_WordToStr_output+1 
	CALL        _WordToStr+0, 0
;si5351SDR_firmware.c,106 :: 		LCDText[0] = LCDTExt[2];
	MOVF        _LCDText+2, 0 
	MOVWF       _LCDText+0 
;si5351SDR_firmware.c,107 :: 		LCDText[1] = '.';
	MOVLW       46
	MOVWF       _LCDText+1 
;si5351SDR_firmware.c,108 :: 		LCDText[2] = LCDTExt[3];
	MOVF        _LCDText+3, 0 
	MOVWF       _LCDText+2 
;si5351SDR_firmware.c,109 :: 		LCDText[3] = 0;
	CLRF        _LCDText+3 
;si5351SDR_firmware.c,110 :: 		SSD1306_GotoXY(26,10);
	MOVLW       26
	MOVWF       FARG_SSD1306_GotoXY_x+0 
	MOVLW       10
	MOVWF       FARG_SSD1306_GotoXY_y+0 
	CALL        _SSD1306_GotoXY+0, 0
;si5351SDR_firmware.c,111 :: 		SSD1306_TextSize(2);
	MOVLW       2
	MOVWF       FARG_SSD1306_TextSize_t_size+0 
	CALL        _SSD1306_TextSize+0, 0
;si5351SDR_firmware.c,112 :: 		SSD1306_Print("BATTERY");
	MOVLW       ?lstr1_si5351SDR_firmware+0
	MOVWF       FARG_SSD1306_Print_s+0 
	MOVLW       hi_addr(?lstr1_si5351SDR_firmware+0)
	MOVWF       FARG_SSD1306_Print_s+1 
	CALL        _SSD1306_Print+0, 0
;si5351SDR_firmware.c,113 :: 		SSD1306_GotoXY(45,30);
	MOVLW       45
	MOVWF       FARG_SSD1306_GotoXY_x+0 
	MOVLW       30
	MOVWF       FARG_SSD1306_GotoXY_y+0 
	CALL        _SSD1306_GotoXY+0, 0
;si5351SDR_firmware.c,114 :: 		SSD1306_Print(LCDText);
	MOVLW       _LCDText+0
	MOVWF       FARG_SSD1306_Print_s+0 
	MOVLW       hi_addr(_LCDText+0)
	MOVWF       FARG_SSD1306_Print_s+1 
	CALL        _SSD1306_Print+0, 0
;si5351SDR_firmware.c,115 :: 		SSD1306_Print("v");
	MOVLW       ?lstr2_si5351SDR_firmware+0
	MOVWF       FARG_SSD1306_Print_s+0 
	MOVLW       hi_addr(?lstr2_si5351SDR_firmware+0)
	MOVWF       FARG_SSD1306_Print_s+1 
	CALL        _SSD1306_Print+0, 0
;si5351SDR_firmware.c,116 :: 		SSD1306_Display();
	CALL        _SSD1306_Display+0, 0
;si5351SDR_firmware.c,117 :: 		PrintCnt = 0;
	CLRF        _PrintCnt+0 
	CLRF        _PrintCnt+1 
;si5351SDR_firmware.c,118 :: 		delay_ms(2500);
	MOVLW       51
	MOVWF       R11, 0
	MOVLW       187
	MOVWF       R12, 0
	MOVLW       223
	MOVWF       R13, 0
L_BatCheck143:
	DECFSZ      R13, 1, 1
	BRA         L_BatCheck143
	DECFSZ      R12, 1, 1
	BRA         L_BatCheck143
	DECFSZ      R11, 1, 1
	BRA         L_BatCheck143
	NOP
	NOP
;si5351SDR_firmware.c,119 :: 		}
L_end_BatCheck:
	RETURN      0
; end of _BatCheck

_Tune:

;si5351SDR_firmware.c,121 :: 		void Tune(){
;si5351SDR_firmware.c,122 :: 		TuneFlag = 0x00;
	CLRF        _TuneFlag+0 
;si5351SDR_firmware.c,123 :: 		while(EncodIn){
L_Tune144:
	MOVLW       3
	ANDWF       PORTA+0, 0 
	MOVWF       R0 
	BTFSC       STATUS+0, 2 
	GOTO        L_Tune145
;si5351SDR_firmware.c,124 :: 		SelectMode();
	CALL        _SelectMode+0, 0
;si5351SDR_firmware.c,125 :: 		SelectStep();
	CALL        _SelectStep+0, 0
;si5351SDR_firmware.c,126 :: 		delay_ms(2);
	MOVLW       11
	MOVWF       R12, 0
	MOVLW       98
	MOVWF       R13, 0
L_Tune146:
	DECFSZ      R13, 1, 1
	BRA         L_Tune146
	DECFSZ      R12, 1, 1
	BRA         L_Tune146
	NOP
;si5351SDR_firmware.c,127 :: 		}
	GOTO        L_Tune144
L_Tune145:
;si5351SDR_firmware.c,128 :: 		while((EncodIn)== 0){
L_Tune147:
	MOVLW       3
	ANDWF       PORTA+0, 0 
	MOVWF       R1 
	MOVF        R1, 0 
	XORLW       0
	BTFSS       STATUS+0, 2 
	GOTO        L_Tune148
;si5351SDR_firmware.c,129 :: 		SelectMode();
	CALL        _SelectMode+0, 0
;si5351SDR_firmware.c,130 :: 		SelectStep();
	CALL        _SelectStep+0, 0
;si5351SDR_firmware.c,131 :: 		}
	GOTO        L_Tune147
L_Tune148:
;si5351SDR_firmware.c,132 :: 		delay_ms(3);
	MOVLW       16
	MOVWF       R12, 0
	MOVLW       148
	MOVWF       R13, 0
L_Tune149:
	DECFSZ      R13, 1, 1
	BRA         L_Tune149
	DECFSZ      R12, 1, 1
	BRA         L_Tune149
	NOP
;si5351SDR_firmware.c,133 :: 		Freq+=(EncodeVals[EncodIn]*StepVal);
	MOVLW       3
	ANDWF       PORTA+0, 0 
	MOVWF       R0 
	MOVLW       _EncodeVals+0
	MOVWF       FSR0L+0 
	MOVLW       hi_addr(_EncodeVals+0)
	MOVWF       FSR0L+1 
	MOVF        R0, 0 
	ADDWF       FSR0L+0, 1 
	BTFSC       STATUS+0, 0 
	INCF        FSR0L+1, 1 
	MOVF        POSTINC0+0, 0 
	MOVWF       R0 
	MOVLW       0
	BTFSC       R0, 7 
	MOVLW       255
	MOVWF       R1 
	MOVWF       R2 
	MOVWF       R3 
	MOVF        _StepVal+0, 0 
	MOVWF       R4 
	MOVF        _StepVal+1, 0 
	MOVWF       R5 
	MOVF        _StepVal+2, 0 
	MOVWF       R6 
	MOVF        _StepVal+3, 0 
	MOVWF       R7 
	CALL        _Mul_32x32_U+0, 0
	MOVF        R0, 0 
	ADDWF       _Freq+0, 0 
	MOVWF       R4 
	MOVF        R1, 0 
	ADDWFC      _Freq+1, 0 
	MOVWF       R5 
	MOVF        R2, 0 
	ADDWFC      _Freq+2, 0 
	MOVWF       R6 
	MOVF        R3, 0 
	ADDWFC      _Freq+3, 0 
	MOVWF       R7 
	MOVF        R4, 0 
	MOVWF       _Freq+0 
	MOVF        R5, 0 
	MOVWF       _Freq+1 
	MOVF        R6, 0 
	MOVWF       _Freq+2 
	MOVF        R7, 0 
	MOVWF       _Freq+3 
;si5351SDR_firmware.c,134 :: 		if(freq > 21000000)freq = 21000000;
	MOVF        R7, 0 
	SUBLW       1
	BTFSS       STATUS+0, 2 
	GOTO        L__Tune287
	MOVF        R6, 0 
	SUBLW       64
	BTFSS       STATUS+0, 2 
	GOTO        L__Tune287
	MOVF        R5, 0 
	SUBLW       111
	BTFSS       STATUS+0, 2 
	GOTO        L__Tune287
	MOVF        R4, 0 
	SUBLW       64
L__Tune287:
	BTFSC       STATUS+0, 0 
	GOTO        L_Tune150
	MOVLW       64
	MOVWF       _Freq+0 
	MOVLW       111
	MOVWF       _Freq+1 
	MOVLW       64
	MOVWF       _Freq+2 
	MOVLW       1
	MOVWF       _Freq+3 
L_Tune150:
;si5351SDR_firmware.c,135 :: 		if(freq < 2700000) freq = 2700000;
	MOVLW       0
	SUBWF       _Freq+3, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__Tune288
	MOVLW       41
	SUBWF       _Freq+2, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__Tune288
	MOVLW       50
	SUBWF       _Freq+1, 0 
	BTFSS       STATUS+0, 2 
	GOTO        L__Tune288
	MOVLW       224
	SUBWF       _Freq+0, 0 
L__Tune288:
	BTFSC       STATUS+0, 0 
	GOTO        L_Tune151
	MOVLW       224
	MOVWF       _Freq+0 
	MOVLW       50
	MOVWF       _Freq+1 
	MOVLW       41
	MOVWF       _Freq+2 
	MOVLW       0
	MOVWF       _Freq+3 
L_Tune151:
;si5351SDR_firmware.c,136 :: 		TuneFlag = 0xFF;
	MOVLW       255
	MOVWF       _TuneFlag+0 
;si5351SDR_firmware.c,137 :: 		}
L_end_Tune:
	RETURN      0
; end of _Tune

_SelectStep:

;si5351SDR_firmware.c,139 :: 		unsigned long SelectStep(){
;si5351SDR_firmware.c,140 :: 		if(StepSW == 1){
	BTFSS       PORTA+0, 2 
	GOTO        L_SelectStep152
;si5351SDR_firmware.c,141 :: 		StepCnt++;
	INCF        _StepCnt+0, 1 
;si5351SDR_firmware.c,142 :: 		while(StepSW == 1);
L_SelectStep153:
	BTFSS       PORTA+0, 2 
	GOTO        L_SelectStep154
	GOTO        L_SelectStep153
L_SelectStep154:
;si5351SDR_firmware.c,143 :: 		delay_ms(100);
	MOVLW       3
	MOVWF       R11, 0
	MOVLW       8
	MOVWF       R12, 0
	MOVLW       119
	MOVWF       R13, 0
L_SelectStep155:
	DECFSZ      R13, 1, 1
	BRA         L_SelectStep155
	DECFSZ      R12, 1, 1
	BRA         L_SelectStep155
	DECFSZ      R11, 1, 1
	BRA         L_SelectStep155
;si5351SDR_firmware.c,144 :: 		if(StepCnt > 6)StepCnt = 1;
	MOVF        _StepCnt+0, 0 
	SUBLW       6
	BTFSC       STATUS+0, 0 
	GOTO        L_SelectStep156
	MOVLW       1
	MOVWF       _StepCnt+0 
L_SelectStep156:
;si5351SDR_firmware.c,145 :: 		switch(StepCnt){
	GOTO        L_SelectStep157
;si5351SDR_firmware.c,146 :: 		case 1: StepVal = 10; print_10Hz; break;
L_SelectStep159:
	MOVLW       10
	MOVWF       _StepVal+0 
	MOVLW       0
	MOVWF       _StepVal+1 
	MOVWF       _StepVal+2 
	MOVWF       _StepVal+3 
	MOVLW       2
	MOVWF       FARG_SSD1306_TextSize_t_size+0 
	CALL        _SSD1306_TextSize+0, 0
	MOVLW       4
	MOVWF       FARG_SSD1306_GotoXY_x+0 
	MOVLW       47
	MOVWF       FARG_SSD1306_GotoXY_y+0 
	CALL        _SSD1306_GotoXY+0, 0
	MOVLW       ?lstr3_si5351SDR_firmware+0
	MOVWF       FARG_SSD1306_Print_s+0 
	MOVLW       hi_addr(?lstr3_si5351SDR_firmware+0)
	MOVWF       FARG_SSD1306_Print_s+1 
	CALL        _SSD1306_Print+0, 0
	CALL        _SSD1306_Display+0, 0
	GOTO        L_SelectStep158
;si5351SDR_firmware.c,147 :: 		case 2: StepVal = 100; print_100Hz; break;
L_SelectStep160:
	MOVLW       100
	MOVWF       _StepVal+0 
	MOVLW       0
	MOVWF       _StepVal+1 
	MOVWF       _StepVal+2 
	MOVWF       _StepVal+3 
	MOVLW       2
	MOVWF       FARG_SSD1306_TextSize_t_size+0 
	CALL        _SSD1306_TextSize+0, 0
	MOVLW       4
	MOVWF       FARG_SSD1306_GotoXY_x+0 
	MOVLW       47
	MOVWF       FARG_SSD1306_GotoXY_y+0 
	CALL        _SSD1306_GotoXY+0, 0
	MOVLW       ?lstr4_si5351SDR_firmware+0
	MOVWF       FARG_SSD1306_Print_s+0 
	MOVLW       hi_addr(?lstr4_si5351SDR_firmware+0)
	MOVWF       FARG_SSD1306_Print_s+1 
	CALL        _SSD1306_Print+0, 0
	CALL        _SSD1306_Display+0, 0
	GOTO        L_SelectStep158
;si5351SDR_firmware.c,148 :: 		case 3: StepVal = 1000; print_1KHz;  break;
L_SelectStep161:
	MOVLW       232
	MOVWF       _StepVal+0 
	MOVLW       3
	MOVWF       _StepVal+1 
	MOVLW       0
	MOVWF       _StepVal+2 
	MOVWF       _StepVal+3 
	MOVLW       2
	MOVWF       FARG_SSD1306_TextSize_t_size+0 
	CALL        _SSD1306_TextSize+0, 0
	MOVLW       4
	MOVWF       FARG_SSD1306_GotoXY_x+0 
	MOVLW       47
	MOVWF       FARG_SSD1306_GotoXY_y+0 
	CALL        _SSD1306_GotoXY+0, 0
	MOVLW       ?lstr5_si5351SDR_firmware+0
	MOVWF       FARG_SSD1306_Print_s+0 
	MOVLW       hi_addr(?lstr5_si5351SDR_firmware+0)
	MOVWF       FARG_SSD1306_Print_s+1 
	CALL        _SSD1306_Print+0, 0
	CALL        _SSD1306_Display+0, 0
	GOTO        L_SelectStep158
;si5351SDR_firmware.c,149 :: 		case 4: StepVal = 5000; print_5KHz;  break;
L_SelectStep162:
	MOVLW       136
	MOVWF       _StepVal+0 
	MOVLW       19
	MOVWF       _StepVal+1 
	MOVLW       0
	MOVWF       _StepVal+2 
	MOVWF       _StepVal+3 
	MOVLW       2
	MOVWF       FARG_SSD1306_TextSize_t_size+0 
	CALL        _SSD1306_TextSize+0, 0
	MOVLW       4
	MOVWF       FARG_SSD1306_GotoXY_x+0 
	MOVLW       47
	MOVWF       FARG_SSD1306_GotoXY_y+0 
	CALL        _SSD1306_GotoXY+0, 0
	MOVLW       ?lstr6_si5351SDR_firmware+0
	MOVWF       FARG_SSD1306_Print_s+0 
	MOVLW       hi_addr(?lstr6_si5351SDR_firmware+0)
	MOVWF       FARG_SSD1306_Print_s+1 
	CALL        _SSD1306_Print+0, 0
	CALL        _SSD1306_Display+0, 0
	GOTO        L_SelectStep158
;si5351SDR_firmware.c,150 :: 		case 5: StepVal = 100000; print_100KHz;  break;
L_SelectStep163:
	MOVLW       160
	MOVWF       _StepVal+0 
	MOVLW       134
	MOVWF       _StepVal+1 
	MOVLW       1
	MOVWF       _StepVal+2 
	MOVLW       0
	MOVWF       _StepVal+3 
	MOVLW       2
	MOVWF       FARG_SSD1306_TextSize_t_size+0 
	CALL        _SSD1306_TextSize+0, 0
	MOVLW       4
	MOVWF       FARG_SSD1306_GotoXY_x+0 
	MOVLW       47
	MOVWF       FARG_SSD1306_GotoXY_y+0 
	CALL        _SSD1306_GotoXY+0, 0
	MOVLW       ?lstr7_si5351SDR_firmware+0
	MOVWF       FARG_SSD1306_Print_s+0 
	MOVLW       hi_addr(?lstr7_si5351SDR_firmware+0)
	MOVWF       FARG_SSD1306_Print_s+1 
	CALL        _SSD1306_Print+0, 0
	CALL        _SSD1306_Display+0, 0
	GOTO        L_SelectStep158
;si5351SDR_firmware.c,151 :: 		case 6: StepVal = 1; print_1Hz; break;
L_SelectStep164:
	MOVLW       1
	MOVWF       _StepVal+0 
	MOVLW       0
	MOVWF       _StepVal+1 
	MOVWF       _StepVal+2 
	MOVWF       _StepVal+3 
	MOVLW       2
	MOVWF       FARG_SSD1306_TextSize_t_size+0 
	CALL        _SSD1306_TextSize+0, 0
	MOVLW       4
	MOVWF       FARG_SSD1306_GotoXY_x+0 
	MOVLW       47
	MOVWF       FARG_SSD1306_GotoXY_y+0 
	CALL        _SSD1306_GotoXY+0, 0
	MOVLW       ?lstr8_si5351SDR_firmware+0
	MOVWF       FARG_SSD1306_Print_s+0 
	MOVLW       hi_addr(?lstr8_si5351SDR_firmware+0)
	MOVWF       FARG_SSD1306_Print_s+1 
	CALL        _SSD1306_Print+0, 0
	CALL        _SSD1306_Display+0, 0
	GOTO        L_SelectStep158
;si5351SDR_firmware.c,152 :: 		}
L_SelectStep157:
	MOVF        _StepCnt+0, 0 
	XORLW       1
	BTFSC       STATUS+0, 2 
	GOTO        L_SelectStep159
	MOVF        _StepCnt+0, 0 
	XORLW       2
	BTFSC       STATUS+0, 2 
	GOTO        L_SelectStep160
	MOVF        _StepCnt+0, 0 
	XORLW       3
	BTFSC       STATUS+0, 2 
	GOTO        L_SelectStep161
	MOVF        _StepCnt+0, 0 
	XORLW       4
	BTFSC       STATUS+0, 2 
	GOTO        L_SelectStep162
	MOVF        _StepCnt+0, 0 
	XORLW       5
	BTFSC       STATUS+0, 2 
	GOTO        L_SelectStep163
	MOVF        _StepCnt+0, 0 
	XORLW       6
	BTFSC       STATUS+0, 2 
	GOTO        L_SelectStep164
L_SelectStep158:
;si5351SDR_firmware.c,153 :: 		}
L_SelectStep152:
;si5351SDR_firmware.c,154 :: 		return StepVal;
	MOVF        _StepVal+0, 0 
	MOVWF       R0 
	MOVF        _StepVal+1, 0 
	MOVWF       R1 
	MOVF        _StepVal+2, 0 
	MOVWF       R2 
	MOVF        _StepVal+3, 0 
	MOVWF       R3 
;si5351SDR_firmware.c,155 :: 		}
L_end_SelectStep:
	RETURN      0
; end of _SelectStep

_DisplayFreq:

;si5351SDR_firmware.c,157 :: 		void DisplayFreq(){
;si5351SDR_firmware.c,158 :: 		longtostr(Freq, LCDText);
	MOVF        _Freq+0, 0 
	MOVWF       FARG_LongToStr_input+0 
	MOVF        _Freq+1, 0 
	MOVWF       FARG_LongToStr_input+1 
	MOVF        _Freq+2, 0 
	MOVWF       FARG_LongToStr_input+2 
	MOVF        _Freq+3, 0 
	MOVWF       FARG_LongToStr_input+3 
	MOVLW       _LCDText+0
	MOVWF       FARG_LongToStr_output+0 
	MOVLW       hi_addr(_LCDText+0)
	MOVWF       FARG_LongToStr_output+1 
	CALL        _LongToStr+0, 0
;si5351SDR_firmware.c,159 :: 		LCDText[0] =  LCDText[3];
	MOVF        _LCDText+3, 0 
	MOVWF       _LCDText+0 
;si5351SDR_firmware.c,160 :: 		LCDText[1] =  LCDText[4];
	MOVF        _LCDText+4, 0 
	MOVWF       _LCDText+1 
;si5351SDR_firmware.c,161 :: 		LCDText[2] = 0;
	CLRF        _LCDText+2 
;si5351SDR_firmware.c,162 :: 		SSD1306_GotoXY(1,10);
	MOVLW       1
	MOVWF       FARG_SSD1306_GotoXY_x+0 
	MOVLW       10
	MOVWF       FARG_SSD1306_GotoXY_y+0 
	CALL        _SSD1306_GotoXY+0, 0
;si5351SDR_firmware.c,163 :: 		SSD1306_TextSize(3);
	MOVLW       3
	MOVWF       FARG_SSD1306_TextSize_t_size+0 
	CALL        _SSD1306_TextSize+0, 0
;si5351SDR_firmware.c,164 :: 		SSD1306_Print(LCDText);
	MOVLW       _LCDText+0
	MOVWF       FARG_SSD1306_Print_s+0 
	MOVLW       hi_addr(_LCDText+0)
	MOVWF       FARG_SSD1306_Print_s+1 
	CALL        _SSD1306_Print+0, 0
;si5351SDR_firmware.c,165 :: 		SSD1306_Print(".");
	MOVLW       ?lstr9_si5351SDR_firmware+0
	MOVWF       FARG_SSD1306_Print_s+0 
	MOVLW       hi_addr(?lstr9_si5351SDR_firmware+0)
	MOVWF       FARG_SSD1306_Print_s+1 
	CALL        _SSD1306_Print+0, 0
;si5351SDR_firmware.c,166 :: 		LCDText[0] =  LCDText[5];
	MOVF        _LCDText+5, 0 
	MOVWF       _LCDText+0 
;si5351SDR_firmware.c,167 :: 		LCDText[1] =  LCDText[6];
	MOVF        _LCDText+6, 0 
	MOVWF       _LCDText+1 
;si5351SDR_firmware.c,168 :: 		LCDText[2] =  LCDText[7];
	MOVF        _LCDText+7, 0 
	MOVWF       _LCDText+2 
;si5351SDR_firmware.c,169 :: 		LCDText[3] =  LCDText[8];
	MOVF        _LCDText+8, 0 
	MOVWF       _LCDText+3 
;si5351SDR_firmware.c,170 :: 		LCDText[4] =  0;
	CLRF        _LCDText+4 
;si5351SDR_firmware.c,171 :: 		SSD1306_Print(LCDText);
	MOVLW       _LCDText+0
	MOVWF       FARG_SSD1306_Print_s+0 
	MOVLW       hi_addr(_LCDText+0)
	MOVWF       FARG_SSD1306_Print_s+1 
	CALL        _SSD1306_Print+0, 0
;si5351SDR_firmware.c,172 :: 		SSD1306_GotoXY(112,35);
	MOVLW       112
	MOVWF       FARG_SSD1306_GotoXY_x+0 
	MOVLW       35
	MOVWF       FARG_SSD1306_GotoXY_y+0 
	CALL        _SSD1306_GotoXY+0, 0
;si5351SDR_firmware.c,173 :: 		SSD1306_TextSize(1);
	MOVLW       1
	MOVWF       FARG_SSD1306_TextSize_t_size+0 
	CALL        _SSD1306_TextSize+0, 0
;si5351SDR_firmware.c,174 :: 		LCDText[0] =  LCDText[9];
	MOVF        _LCDText+9, 0 
	MOVWF       _LCDText+0 
;si5351SDR_firmware.c,175 :: 		LCDText[1] =  LCDText[10];
	MOVF        _LCDText+10, 0 
	MOVWF       _LCDText+1 
;si5351SDR_firmware.c,176 :: 		LCDText[2] = 0;
	CLRF        _LCDText+2 
;si5351SDR_firmware.c,177 :: 		SSD1306_Print(LCDText);
	MOVLW       _LCDText+0
	MOVWF       FARG_SSD1306_Print_s+0 
	MOVLW       hi_addr(_LCDText+0)
	MOVWF       FARG_SSD1306_Print_s+1 
	CALL        _SSD1306_Print+0, 0
;si5351SDR_firmware.c,178 :: 		SSD1306_Display();
	CALL        _SSD1306_Display+0, 0
;si5351SDR_firmware.c,179 :: 		}
L_end_DisplayFreq:
	RETURN      0
; end of _DisplayFreq

_SelectMode:

;si5351SDR_firmware.c,181 :: 		void SelectMode(){
;si5351SDR_firmware.c,182 :: 		if(ModeSW == 1){
	BTFSS       PORTA+0, 3 
	GOTO        L_SelectMode165
;si5351SDR_firmware.c,183 :: 		ModeCnt++;
	INCF        _ModeCnt+0, 1 
;si5351SDR_firmware.c,184 :: 		while(ModeSW == 1);
L_SelectMode166:
	BTFSS       PORTA+0, 3 
	GOTO        L_SelectMode167
	GOTO        L_SelectMode166
L_SelectMode167:
;si5351SDR_firmware.c,185 :: 		delay_ms(100);
	MOVLW       3
	MOVWF       R11, 0
	MOVLW       8
	MOVWF       R12, 0
	MOVLW       119
	MOVWF       R13, 0
L_SelectMode168:
	DECFSZ      R13, 1, 1
	BRA         L_SelectMode168
	DECFSZ      R12, 1, 1
	BRA         L_SelectMode168
	DECFSZ      R11, 1, 1
	BRA         L_SelectMode168
;si5351SDR_firmware.c,186 :: 		if(ModeCnt > 3)ModeCnt = 1;
	MOVF        _ModeCnt+0, 0 
	SUBLW       3
	BTFSC       STATUS+0, 0 
	GOTO        L_SelectMode169
	MOVLW       1
	MOVWF       _ModeCnt+0 
L_SelectMode169:
;si5351SDR_firmware.c,187 :: 		switch(ModeCnt){
	GOTO        L_SelectMode170
;si5351SDR_firmware.c,188 :: 		case 1: AMSel; print_AM; break;
L_SelectMode172:
	CLRF        PORTC+0 
	MOVLW       2
	MOVWF       FARG_SSD1306_TextSize_t_size+0 
	CALL        _SSD1306_TextSize+0, 0
	MOVLW       90
	MOVWF       FARG_SSD1306_GotoXY_x+0 
	MOVLW       47
	MOVWF       FARG_SSD1306_GotoXY_y+0 
	CALL        _SSD1306_GotoXY+0, 0
	MOVLW       ?lstr10_si5351SDR_firmware+0
	MOVWF       FARG_SSD1306_Print_s+0 
	MOVLW       hi_addr(?lstr10_si5351SDR_firmware+0)
	MOVWF       FARG_SSD1306_Print_s+1 
	CALL        _SSD1306_Print+0, 0
	CALL        _SSD1306_Display+0, 0
	GOTO        L_SelectMode171
;si5351SDR_firmware.c,189 :: 		case 2: LSBSel; print_LSB; break;
L_SelectMode173:
	MOVLW       2
	MOVWF       PORTC+0 
	MOVLW       2
	MOVWF       FARG_SSD1306_TextSize_t_size+0 
	CALL        _SSD1306_TextSize+0, 0
	MOVLW       90
	MOVWF       FARG_SSD1306_GotoXY_x+0 
	MOVLW       47
	MOVWF       FARG_SSD1306_GotoXY_y+0 
	CALL        _SSD1306_GotoXY+0, 0
	MOVLW       ?lstr11_si5351SDR_firmware+0
	MOVWF       FARG_SSD1306_Print_s+0 
	MOVLW       hi_addr(?lstr11_si5351SDR_firmware+0)
	MOVWF       FARG_SSD1306_Print_s+1 
	CALL        _SSD1306_Print+0, 0
	CALL        _SSD1306_Display+0, 0
	GOTO        L_SelectMode171
;si5351SDR_firmware.c,190 :: 		case 3: USBSel; print_USB; break;
L_SelectMode174:
	MOVLW       1
	MOVWF       PORTC+0 
	MOVLW       2
	MOVWF       FARG_SSD1306_TextSize_t_size+0 
	CALL        _SSD1306_TextSize+0, 0
	MOVLW       90
	MOVWF       FARG_SSD1306_GotoXY_x+0 
	MOVLW       47
	MOVWF       FARG_SSD1306_GotoXY_y+0 
	CALL        _SSD1306_GotoXY+0, 0
	MOVLW       ?lstr12_si5351SDR_firmware+0
	MOVWF       FARG_SSD1306_Print_s+0 
	MOVLW       hi_addr(?lstr12_si5351SDR_firmware+0)
	MOVWF       FARG_SSD1306_Print_s+1 
	CALL        _SSD1306_Print+0, 0
	CALL        _SSD1306_Display+0, 0
	GOTO        L_SelectMode171
;si5351SDR_firmware.c,191 :: 		}
L_SelectMode170:
	MOVF        _ModeCnt+0, 0 
	XORLW       1
	BTFSC       STATUS+0, 2 
	GOTO        L_SelectMode172
	MOVF        _ModeCnt+0, 0 
	XORLW       2
	BTFSC       STATUS+0, 2 
	GOTO        L_SelectMode173
	MOVF        _ModeCnt+0, 0 
	XORLW       3
	BTFSC       STATUS+0, 2 
	GOTO        L_SelectMode174
L_SelectMode171:
;si5351SDR_firmware.c,192 :: 		sendRegister(SI_PLL_RESET, 0xA0);
	MOVLW       177
	MOVWF       FARG_sendRegister_reg_addr+0 
	MOVLW       160
	MOVWF       FARG_sendRegister_reg_value+0 
	CALL        _sendRegister+0, 0
;si5351SDR_firmware.c,193 :: 		}
L_SelectMode165:
;si5351SDR_firmware.c,194 :: 		}
L_end_SelectMode:
	RETURN      0
; end of _SelectMode

_Init_Main:

;si5351SDR_firmware.c,196 :: 		void Init_Main(){
;si5351SDR_firmware.c,197 :: 		OSCCON = 0b01111010; //set up for 16 MHZ internal oscillator
	MOVLW       122
	MOVWF       OSCCON+0 
;si5351SDR_firmware.c,198 :: 		ANSELA = 0b00010000;
	MOVLW       16
	MOVWF       ANSELA+0 
;si5351SDR_firmware.c,199 :: 		ANSELC = 0b00000000;
	CLRF        ANSELC+0 
;si5351SDR_firmware.c,200 :: 		PORTA =  0b00000000;
	CLRF        PORTA+0 
;si5351SDR_firmware.c,201 :: 		TRISA =  0b11111111;
	MOVLW       255
	MOVWF       TRISA+0 
;si5351SDR_firmware.c,202 :: 		TRISC =  0b00000000;
	CLRF        TRISC+0 
;si5351SDR_firmware.c,203 :: 		PORTC =  0b00000000;
	CLRF        PORTC+0 
;si5351SDR_firmware.c,204 :: 		I2C1_Init(800000);
	MOVLW       5
	MOVWF       SSP1ADD+0 
	CALL        _I2C1_Init+0, 0
;si5351SDR_firmware.c,205 :: 		VREFCON0 = 0b10100000;
	MOVLW       160
	MOVWF       VREFCON0+0 
;si5351SDR_firmware.c,206 :: 		ADCON0 =   0b00010001;
	MOVLW       17
	MOVWF       ADCON0+0 
;si5351SDR_firmware.c,207 :: 		ADCON1 =   0b00001000;
	MOVLW       8
	MOVWF       ADCON1+0 
;si5351SDR_firmware.c,208 :: 		ADCON2 =   0b10010010;
	MOVLW       146
	MOVWF       ADCON2+0 
;si5351SDR_firmware.c,209 :: 		delay_ms(20);
	MOVLW       104
	MOVWF       R12, 0
	MOVLW       228
	MOVWF       R13, 0
L_Init_Main175:
	DECFSZ      R13, 1, 1
	BRA         L_Init_Main175
	DECFSZ      R12, 1, 1
	BRA         L_Init_Main175
	NOP
;si5351SDR_firmware.c,210 :: 		sendRegister(CLK_ENABLE_CONTROL, 0x00);
	MOVLW       3
	MOVWF       FARG_sendRegister_reg_addr+0 
	CLRF        FARG_sendRegister_reg_value+0 
	CALL        _sendRegister+0, 0
;si5351SDR_firmware.c,211 :: 		sendRegister(SI_CLK0_CONTROL, 0x0F);
	MOVLW       16
	MOVWF       FARG_sendRegister_reg_addr+0 
	MOVLW       15
	MOVWF       FARG_sendRegister_reg_value+0 
	CALL        _sendRegister+0, 0
;si5351SDR_firmware.c,212 :: 		sendRegister(SI_CLK1_CONTROL, 0x0F);
	MOVLW       17
	MOVWF       FARG_sendRegister_reg_addr+0 
	MOVLW       15
	MOVWF       FARG_sendRegister_reg_value+0 
	CALL        _sendRegister+0, 0
;si5351SDR_firmware.c,213 :: 		sendRegister(SI_CLK2_CONTROL, 0x2C);
	MOVLW       18
	MOVWF       FARG_sendRegister_reg_addr+0 
	MOVLW       44
	MOVWF       FARG_sendRegister_reg_value+0 
	CALL        _sendRegister+0, 0
;si5351SDR_firmware.c,214 :: 		setupPLL(SI_SYNTH_PLL_B, 25, 1048575, 1048575);
	MOVLW       34
	MOVWF       FARG_setupPLL_pll+0 
	MOVLW       25
	MOVWF       FARG_setupPLL_mult+0 
	MOVLW       255
	MOVWF       FARG_setupPLL_num+0 
	MOVLW       255
	MOVWF       FARG_setupPLL_num+1 
	MOVLW       15
	MOVWF       FARG_setupPLL_num+2 
	MOVLW       0
	MOVWF       FARG_setupPLL_num+3 
	MOVLW       255
	MOVWF       FARG_setupPLL_denom+0 
	MOVLW       255
	MOVWF       FARG_setupPLL_denom+1 
	MOVLW       15
	MOVWF       FARG_setupPLL_denom+2 
	MOVLW       0
	MOVWF       FARG_setupPLL_denom+3 
	CALL        _setupPLL+0, 0
;si5351SDR_firmware.c,215 :: 		setupMultisynth(SI_SYNTH_MS_2, 845, SI_R_DIV_16);
	MOVLW       58
	MOVWF       FARG_setupMultisynth_synth+0 
	MOVLW       77
	MOVWF       FARG_setupMultisynth_divider+0 
	MOVLW       3
	MOVWF       FARG_setupMultisynth_divider+1 
	MOVLW       0
	MOVWF       FARG_setupMultisynth_divider+2 
	MOVWF       FARG_setupMultisynth_divider+3 
	MOVLW       64
	MOVWF       FARG_setupMultisynth_rDiv+0 
	CALL        _setupMultisynth+0, 0
;si5351SDR_firmware.c,216 :: 		si5351aSetFrequency(freq);
	MOVF        _Freq+0, 0 
	MOVWF       FARG_si5351aSetFrequency_frequency+0 
	MOVF        _Freq+1, 0 
	MOVWF       FARG_si5351aSetFrequency_frequency+1 
	MOVF        _Freq+2, 0 
	MOVWF       FARG_si5351aSetFrequency_frequency+2 
	MOVF        _Freq+3, 0 
	MOVWF       FARG_si5351aSetFrequency_frequency+3 
	CALL        _si5351aSetFrequency+0, 0
;si5351SDR_firmware.c,217 :: 		sendRegister(SI_PLL_RESET, 0xA0);
	MOVLW       177
	MOVWF       FARG_sendRegister_reg_addr+0 
	MOVLW       160
	MOVWF       FARG_sendRegister_reg_value+0 
	CALL        _sendRegister+0, 0
;si5351SDR_firmware.c,218 :: 		StepVal = 1000;
	MOVLW       232
	MOVWF       _StepVal+0 
	MOVLW       3
	MOVWF       _StepVal+1 
	MOVLW       0
	MOVWF       _StepVal+2 
	MOVWF       _StepVal+3 
;si5351SDR_firmware.c,220 :: 		SSD1306_Begin(SSD1306_SWITCHCAPVCC, SSD1306_I2C_ADDRESS);
	MOVLW       2
	MOVWF       FARG_SSD1306_Begin_vccstate+0 
	MOVLW       120
	MOVWF       FARG_SSD1306_Begin_i2caddr+0 
	CALL        _SSD1306_Begin+0, 0
;si5351SDR_firmware.c,221 :: 		SSD1306_Color = false;
	CLRF        _SSD1306_Color+0 
;si5351SDR_firmware.c,222 :: 		SSD1306_ClearDisplay();
	CALL        _SSD1306_ClearDisplay+0, 0
;si5351SDR_firmware.c,223 :: 		SSD1306_Display();
	CALL        _SSD1306_Display+0, 0
;si5351SDR_firmware.c,224 :: 		BatCheck();
	CALL        _BatCheck+0, 0
;si5351SDR_firmware.c,225 :: 		SSD1306_ClearDisplay();
	CALL        _SSD1306_ClearDisplay+0, 0
;si5351SDR_firmware.c,226 :: 		DisplayFreq();
	CALL        _DisplayFreq+0, 0
;si5351SDR_firmware.c,227 :: 		SSD1306_TextSize(2);
	MOVLW       2
	MOVWF       FARG_SSD1306_TextSize_t_size+0 
	CALL        _SSD1306_TextSize+0, 0
;si5351SDR_firmware.c,228 :: 		print_AM;
	MOVLW       2
	MOVWF       FARG_SSD1306_TextSize_t_size+0 
	CALL        _SSD1306_TextSize+0, 0
	MOVLW       90
	MOVWF       FARG_SSD1306_GotoXY_x+0 
	MOVLW       47
	MOVWF       FARG_SSD1306_GotoXY_y+0 
	CALL        _SSD1306_GotoXY+0, 0
	MOVLW       ?lstr13_si5351SDR_firmware+0
	MOVWF       FARG_SSD1306_Print_s+0 
	MOVLW       hi_addr(?lstr13_si5351SDR_firmware+0)
	MOVWF       FARG_SSD1306_Print_s+1 
	CALL        _SSD1306_Print+0, 0
	CALL        _SSD1306_Display+0, 0
;si5351SDR_firmware.c,229 :: 		print_1KHz;
	MOVLW       2
	MOVWF       FARG_SSD1306_TextSize_t_size+0 
	CALL        _SSD1306_TextSize+0, 0
	MOVLW       4
	MOVWF       FARG_SSD1306_GotoXY_x+0 
	MOVLW       47
	MOVWF       FARG_SSD1306_GotoXY_y+0 
	CALL        _SSD1306_GotoXY+0, 0
	MOVLW       ?lstr14_si5351SDR_firmware+0
	MOVWF       FARG_SSD1306_Print_s+0 
	MOVLW       hi_addr(?lstr14_si5351SDR_firmware+0)
	MOVWF       FARG_SSD1306_Print_s+1 
	CALL        _SSD1306_Print+0, 0
	CALL        _SSD1306_Display+0, 0
;si5351SDR_firmware.c,231 :: 		}
L_end_Init_Main:
	RETURN      0
; end of _Init_Main

_main:

;si5351SDR_firmware.c,233 :: 		void main(){
;si5351SDR_firmware.c,234 :: 		Init_Main();
	CALL        _Init_Main+0, 0
;si5351SDR_firmware.c,235 :: 		while(1){
L_main176:
;si5351SDR_firmware.c,236 :: 		Tune();
	CALL        _Tune+0, 0
;si5351SDR_firmware.c,237 :: 		if(TuneFlag){
	MOVF        _TuneFlag+0, 1 
	BTFSC       STATUS+0, 2 
	GOTO        L_main178
;si5351SDR_firmware.c,238 :: 		si5351aSetFrequency(freq);
	MOVF        _Freq+0, 0 
	MOVWF       FARG_si5351aSetFrequency_frequency+0 
	MOVF        _Freq+1, 0 
	MOVWF       FARG_si5351aSetFrequency_frequency+1 
	MOVF        _Freq+2, 0 
	MOVWF       FARG_si5351aSetFrequency_frequency+2 
	MOVF        _Freq+3, 0 
	MOVWF       FARG_si5351aSetFrequency_frequency+3 
	CALL        _si5351aSetFrequency+0, 0
;si5351SDR_firmware.c,239 :: 		DisplayFreq();
	CALL        _DisplayFreq+0, 0
;si5351SDR_firmware.c,240 :: 		}
L_main178:
;si5351SDR_firmware.c,241 :: 		}
	GOTO        L_main176
;si5351SDR_firmware.c,242 :: 		}
L_end_main:
	GOTO        $+0
; end of _main
